/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.chat;

import com.imcode.imcms.servlet.chat.ChatControl;
import imcode.external.chat.Chat;
import imcode.external.chat.ChatBase;
import imcode.external.chat.ChatMember;
import imcode.external.chat.ChatMessage;
import imcode.external.chat.ChatSessionsSingleton;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Date;
import java.util.ListIterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ChatBoard
extends ChatBase {
    private static final String HTML_TEMPLATE = "chat_messages.html";
    private static final String HTML_HR = "last_msg_hr.html";
    private static final String CHAT_KICKOUT_TEMPLATE = "chat_kickout_message.html";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        Utility.setNoCache(res);
        UserDomainObject user = this.getUserObj(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            this.log("user not authorized");
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        ChatMember myMember = this.getChatMember(req);
        if (myMember.isKickedOut()) {
            String result = ChatControl.getParsedChatLeavePage(myMember, imcref, CHAT_KICKOUT_TEMPLATE);
            res.getWriter().write(result);
            HttpSession session = ChatSessionsSingleton.getSession(myMember);
            ChatBoard.cleanUpSessionParams(session);
            return;
        }
        StringBuffer sendMsgString = new StringBuffer("");
        Chat myChat = myMember.getParent();
        String libName = ChatBoard.getTemplateSetDirectoryName(myChat.getChatId());
        boolean showPrivateMessages = myMember.isShowPrivateMessagesEnabled();
        boolean autoReload = myMember.isAutoRefreshEnabled();
        String time = myMember.getRefreshTime() + "";
        String chatRefresh = ChatBoard.getChatRefresh(autoReload, time, req);
        int lastMsgInt = myMember.getLastMsgNr();
        ListIterator msgIter = myMember.getMessages();
        while (msgIter.hasNext()) {
            ChatMessage message = (ChatMessage)msgIter.next();
            if (lastMsgInt == message.getIdNumber()) {
                sendMsgString.append(imcref.getTemplateFromSubDirectoryOfDirectory(HTML_HR, user, null, "103", ChatBoard.getTemplateSetDirectoryName(myChat.getChatId())));
            }
            sendMsgString.append(message.getLine(showPrivateMessages, myMember, imcref, user, libName));
        }
        Vector<String> tags = new Vector<String>();
        tags.add("#CHAT_REFRESH#");
        tags.add(chatRefresh);
        tags.add("#CHAT_MESSAGES#");
        tags.add(sendMsgString.toString());
        this.sendHtml(req, res, tags, HTML_TEMPLATE, null);
        myMember.setLastRequest(new Date());
    }

    private static String getChatRefresh(boolean autoReload, String time, HttpServletRequest req) {
        String chatRefresh = "";
        if (autoReload) {
            chatRefresh = "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"" + time + ";URL=" + req.getRequestURI() + "\">";
        }
        return chatRefresh;
    }

    private ChatMember getChatMember(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        ChatMember myMember = (ChatMember)session.getAttribute("theChatMember");
        return myMember;
    }
}

