/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.billboard;

import com.imcode.imcms.servlet.billboard.BillBoard;
import imcode.external.diverse.SettingsAccessor;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BillBoardError
extends BillBoard {
    private static final String ERROR_FILE_2 = "billboard_user_error.htm";
    private String myErrorMessage;

    public BillBoardError() {
        this.myErrorMessage = "";
    }

    public BillBoardError(HttpServletRequest req, HttpServletResponse res, int errorCode, UserDomainObject user) throws IOException {
        VariableManager vm = new VariableManager();
        String myErrorMessage = this.getErrorMessage(req, errorCode);
        vm.addProperty("ERROR_MESSAGE", myErrorMessage);
        this.sendErrorHtml(req, res, vm, ERROR_FILE_2, user);
    }

    public String getErrorMsg() {
        return this.myErrorMessage;
    }

    public String getErrorMessage(HttpServletRequest req, int errCode) {
        try {
            SettingsAccessor setObj = new SettingsAccessor("errmsg.ini", Utility.getLoggedOnUser(req), "104");
            setObj.setDelimiter("=");
            setObj.loadSettings();
            this.myErrorMessage = setObj.getSetting("" + errCode);
            if (this.myErrorMessage == null) {
                this.myErrorMessage = "Missing Errorcode " + errCode;
            }
        }
        catch (Exception e) {
            this.log("An error occured while reading the errmsg.ini file");
        }
        return this.myErrorMessage;
    }

    public BillBoardError(HttpServletRequest req, HttpServletResponse res, String header, int errorCode, String fileName, UserDomainObject user) throws IOException {
        VariableManager vm = new VariableManager();
        this.myErrorMessage = this.getErrorMessage(req, errorCode);
        vm.addProperty("ERROR_CODE", "" + errorCode);
        vm.addProperty("ERROR_HEADER", header);
        vm.addProperty("ERROR_MESSAGE", this.myErrorMessage);
        this.sendErrorHtml(req, res, vm, fileName, user);
    }

    private void sendErrorHtml(HttpServletRequest req, HttpServletResponse res, VariableManager vm, String htmlFile, UserDomainObject user) throws IOException {
        File templateLib = this.getExternalTemplateFolder(req);
        String imagePath = this.getExternalImageFolder(req);
        vm.addProperty("IMAGE_URL", imagePath);
        vm.addProperty("SERVLET_URL", "");
        ImcmsServices imcref = Imcms.getServices();
        String html = imcref.getTemplateFromSubDirectoryOfDirectory(htmlFile, user, vm.getTagsAndData(), "104", "original");
        PrintWriter out = res.getWriter();
        Utility.setDefaultHtmlContentType(res);
        out.println(html);
    }
}

