/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.billboard;

import com.imcode.imcms.servlet.billboard.BillBoard;
import com.imcode.imcms.servlet.billboard.BillBoardError;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BillBoardDisc
extends BillBoard {
    private static final String PREVIOUS_DISC_LIST_TEMPLATE = "billboard_disc_list_previous.htm";
    private static final String NEXT_DISC_LIST_TEMPLATE = "billboard_disc_list_next.htm";
    private static final String NEW_DISC_TEMPLATE = "billboard_disc_new_button.htm";
    private static final String ADMIN_LINK_TEMPLATE = "billboard_disc_admin_link.htm";
    private String HTML_TEMPLATE = "billboard_disc.htm";
    private String A_HREF_HTML = "billboard_disc_list.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        Properties params = this.getPropertiesOfBillBoardSessionParameters(req);
        ImcmsServices imcref = Imcms.getServices();
        if (req.getParameter("UPDATE") != null) {
            Properties reqParams = this.getRequestParameters(req);
            String aSectionId = reqParams.getProperty("SECTION_ID");
            HttpSession session = req.getSession(false);
            if (session != null) {
                String latestDiscId = "-1";
                session.setAttribute("BillBoard.disc_id", (Object)latestDiscId);
                session.setAttribute("BillBoard.section_id", (Object)aSectionId);
                session.setAttribute("BillBoard.disc_index", (Object)"0");
            }
            res.sendRedirect("BillBoardDiscView");
            return;
        }
        if (req.getParameter("ADD") != null) {
            HttpSession session;
            if (req.getParameter("ADDNEW") != null && (session = req.getSession(false)) != null) {
                session.removeAttribute("billPrevData");
            }
            res.sendRedirect("BillBoardAdd?ADDTYPE=Discussion");
            return;
        }
        if (req.getParameter("NEXT") != null || req.getParameter("NEXT.x") != null) {
            String nbrOfDiscsStr = imcref.sqlProcedureStr("B_GetNbrOfDiscs", new String[]{params.getProperty("SECTION_ID")});
            int nbrOfDiscs = 0;
            String showDiscsStr = imcref.sqlProcedureStr("B_GetNbrOfDiscsToShow", new String[]{params.getProperty("SECTION_ID")});
            int showDiscsCounter = Integer.parseInt(showDiscsStr);
            try {
                nbrOfDiscs = Integer.parseInt(nbrOfDiscsStr);
            }
            catch (Exception e) {
                nbrOfDiscs = 0;
                this.log("GetNbrOfDiscs returned null");
            }
            int currIndex = this.getDiscIndex(req);
            if (currIndex + showDiscsCounter < nbrOfDiscs) {
                this.increaseDiscIndex(req, showDiscsCounter);
            }
            res.sendRedirect("BillBoardDiscView");
            return;
        }
        if (req.getParameter("PREVIOUS") != null || req.getParameter("PREVIOUS.x") != null) {
            String showDiscsStr = imcref.sqlProcedureStr("B_GetNbrOfDiscsToShow", new String[]{params.getProperty("SECTION_ID")});
            int showDiscsCounter = Integer.parseInt(showDiscsStr);
            this.decreaseDiscIndex(req, showDiscsCounter);
            res.sendRedirect("BillBoardDiscView");
            return;
        }
        if (req.getParameter("SEARCH") != null) {
            BillBoardError msgErr;
            boolean itsOk;
            params = this.getSearchParameters(req, params);
            String searchMsg = "";
            boolean searchParamsOk = true;
            String currSection = "";
            String aSectionId = params.getProperty("SECTION_ID");
            currSection = "" + imcref.sqlProcedureStr("B_GetSectionName", new String[]{aSectionId});
            String metaId = params.getProperty("META_ID");
            if ((params = this.buildSearchDateParams(params)) == null) {
                this.log("An illegal searchdateparameter was sent to server");
                BillBoardError msgErr2 = new BillBoardError();
                searchMsg = msgErr2.getErrorMessage(req, 42);
                searchParamsOk = false;
            }
            if (searchParamsOk && !(itsOk = this.checkSearchWords(params))) {
                BillBoardError msgErr3 = new BillBoardError();
                searchMsg = msgErr3.getErrorMessage(req, 40);
                searchParamsOk = false;
            }
            String[][] sqlAnswer = null;
            if (searchParamsOk) {
                String searchW = params.getProperty("SEARCH");
                String category = params.getProperty("CATEGORY");
                String frDate = params.getProperty("FR_DATE");
                String toDate = params.getProperty("TO_DATE");
                sqlAnswer = imcref.sqlProcedureMulti("B_SearchText", new String[]{metaId, aSectionId, category, searchW, frDate, toDate + " 23:59:59"});
            }
            File templateLib = super.getExternalTemplateFolder(req);
            File aHreHtmlFile = new File(templateLib, this.A_HREF_HTML);
            Vector tagsV = this.buildTags();
            String allRecs = "";
            if (sqlAnswer != null) {
                if (sqlAnswer.length > 0 && (allRecs = this.preParse(sqlAnswer, tagsV, aHreHtmlFile)) == null) {
                    msgErr = new BillBoardError();
                    allRecs = msgErr.getErrorMessage(req, 41);
                    msgErr = null;
                }
            } else if (searchParamsOk) {
                msgErr = new BillBoardError();
                allRecs = msgErr.getErrorMessage(req, 41);
                msgErr = null;
            }
            VariableManager vm = new VariableManager();
            if (allRecs == null || allRecs.equals("")) {
                vm.addProperty("A_HREF_LIST", searchMsg);
            } else {
                vm.addProperty("A_HREF_LIST", allRecs);
            }
            String newDiscButton = "&nbsp;";
            int intMetaId = Integer.parseInt(metaId);
            DocumentMapper documentMapper = imcref.getDocumentMapper();
            DocumentDomainObject document = documentMapper.getDocument(intMetaId);
            if (user.canAccess(document) && imcref.checkDocAdminRights(intMetaId, user)) {
                VariableManager vmButtons = new VariableManager();
                vmButtons.addProperty("#SERVLET_URL#", "");
                vmButtons.addProperty("#IMAGE_URL#", this.getExternalImageFolder(req));
                newDiscButton = this.getTemplate(NEW_DISC_TEMPLATE, user, vmButtons.getTagsAndData());
            }
            vm.addProperty("CURRENT_SECTION_NAME", currSection);
            vm.addProperty("PREVIOUS_BUTTON", "&nbsp;");
            vm.addProperty("NEXT_BUTTON", "&nbsp;");
            vm.addProperty("NEW_DISC_BUTTON", newDiscButton);
            vm.addProperty("ADMIN_LINK_HTML", ADMIN_LINK_TEMPLATE);
            this.sendHtml(req, res, vm, this.HTML_TEMPLATE);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Properties params = this.getPropertiesOfBillBoardSessionParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            this.log("user == null so return");
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            this.log("user == null so return");
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        String aMetaId = params.getProperty("META_ID");
        int metaId = Integer.parseInt(aMetaId);
        String aSectionId = params.getProperty("SECTION_ID");
        File aHrefHtmlFile = new File(super.getExternalTemplateFolder(req), this.A_HREF_HTML);
        String[][] sqlAnswer = imcref.sqlProcedureMulti("B_GetAllBillsToShow", new String[]{aMetaId, aSectionId});
        File templateLib = this.getExternalTemplateFolder(req);
        String previousButton = "&nbsp;";
        String nextButton = "&nbsp;";
        String newDiscButton = "&nbsp;";
        VariableManager vmButtons = new VariableManager();
        vmButtons.addProperty("#SERVLET_URL#", "");
        vmButtons.addProperty("#IMAGE_URL#", this.getExternalImageFolder(req));
        String allRecs = "";
        int discIndexPos = this.getDiscIndex(req);
        int showDiscsCounter = 0;
        if (sqlAnswer.length > 0) {
            Vector tagsV = this.buildTags();
            String showDiscsStr = imcref.sqlProcedureStr("B_GetNbrOfDiscsToShow", new String[]{params.getProperty("SECTION_ID")});
            showDiscsCounter = Integer.parseInt(showDiscsStr);
            if (sqlAnswer.length > 0) {
                String[][] newArr = sqlAnswer;
                allRecs = this.preParse(newArr, tagsV, aHrefHtmlFile);
            }
            if (discIndexPos != 0) {
                previousButton = this.getTemplate(PREVIOUS_DISC_LIST_TEMPLATE, user, vmButtons.getTagsAndData());
            }
            if (sqlAnswer.length / 4 - 1 > discIndexPos + showDiscsCounter) {
                nextButton = this.getTemplate(NEXT_DISC_LIST_TEMPLATE, user, vmButtons.getTagsAndData());
            }
        }
        String currSection = "" + imcref.sqlProcedureStr("B_GetSectionName", new String[]{params.getProperty("SECTION_ID")});
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(metaId);
        if (user.canAccess(document) && imcref.checkDocAdminRights(metaId, user)) {
            newDiscButton = this.getTemplate(NEW_DISC_TEMPLATE, user, vmButtons.getTagsAndData());
        }
        VariableManager vm = new VariableManager();
        vm.addProperty("PREVIOUS_BUTTON", previousButton);
        vm.addProperty("NEXT_BUTTON", nextButton);
        vm.addProperty("NEW_DISC_BUTTON", newDiscButton);
        vm.addProperty("A_HREF_LIST", allRecs);
        vm.addProperty("CURRENT_SECTION_NAME", currSection);
        vm.addProperty("ADMIN_LINK_HTML", ADMIN_LINK_TEMPLATE);
        this.sendHtml(req, res, vm, this.HTML_TEMPLATE);
    }

    private String preParse(String[][] DBArr, Vector tagsV, File htmlCodeFile) throws IOException {
        String htmlStr = "";
        for (int i = 0; i < DBArr.length; ++i) {
            Vector<String> dataV = new Vector<String>(9);
            for (int j = 0; j < DBArr[i].length; ++j) {
                dataV.add(DBArr[i][j]);
            }
            dataV.add("BillBoardReply?");
            htmlStr = htmlStr + this.parseOneRecord(tagsV, dataV, htmlCodeFile);
        }
        return htmlStr;
    }

    private void increaseDiscIndex(HttpServletRequest req, int incFactor) {
        HttpSession session = null;
        session = req.getSession(false);
        if (session != null) {
            String indexStr = (String)session.getAttribute("BillBoard.disc_index");
            int anInt = Integer.parseInt(indexStr) + incFactor;
            session.setAttribute("BillBoard.disc_index", (Object)("" + anInt));
        }
    }

    private void decreaseDiscIndex(HttpServletRequest req, int incFactor) {
        HttpSession session = null;
        session = req.getSession(false);
        if (session != null) {
            String indexStr = (String)session.getAttribute("BillBoard.disc_index");
            int anInt = Integer.parseInt(indexStr) - incFactor;
            if (anInt < 0) {
                anInt = 0;
            }
            session.setAttribute("BillBoard.disc_index", (Object)("" + anInt));
        }
    }

    private int getDiscIndex(HttpServletRequest req) {
        try {
            HttpSession session = req.getSession(false);
            if (session != null) {
                String indexStr = (String)session.getAttribute("BillBoard.disc_index");
                int anInt = Integer.parseInt(indexStr);
                return anInt;
            }
        }
        catch (Exception e) {
            this.log("GetDiscIndex failed!");
            return 0;
        }
        return 0;
    }

    private Properties getPropertiesOfBillBoardSessionParameters(HttpServletRequest req) {
        Properties reqParams = MetaInfo.createPropertiesFromMetaInfoParameters(super.getBillBoardSessionParameters(req));
        HttpSession session = req.getSession(false);
        if (session != null) {
            String sectionId = (String)session.getAttribute("BillBoard.section_id") == null ? "" : (String)session.getAttribute("BillBoard.section_id");
            String discIndex = (String)session.getAttribute("BillBoard.disc_index") == null ? "" : (String)session.getAttribute("BillBoard.disc_index");
            reqParams.setProperty("DISC_INDEX", discIndex);
            reqParams.setProperty("SECTION_ID", sectionId);
        }
        return reqParams;
    }

    private Properties getRequestParameters(HttpServletRequest req) {
        Properties reqParams = new Properties();
        String confForumId = req.getParameter("section_id");
        String discIndex = "";
        HttpSession session = req.getSession(false);
        if (session != null) {
            if (confForumId == null) {
                confForumId = (String)session.getAttribute("BillBoard.section_id");
            }
            if ((discIndex = (String)session.getAttribute("BillBoard.disc_index")) == null || discIndex.equalsIgnoreCase("null")) {
                discIndex = "0";
            }
        }
        reqParams.setProperty("SECTION_ID", confForumId);
        reqParams.setProperty("DISC_INDEX", discIndex);
        return reqParams;
    }

    private Properties getSearchParameters(HttpServletRequest req, Properties params) {
        String cat = req.getParameter("CATEGORY") == null ? "" : req.getParameter("CATEGORY");
        String search = req.getParameter("SEARCH") == null ? "" : req.getParameter("SEARCH");
        String fromDate = req.getParameter("FR_DATE") == null ? "" : req.getParameter("FR_DATE");
        String fromVal = req.getParameter("FR_VALUE") == null ? "" : req.getParameter("FR_VALUE");
        String toDate = req.getParameter("TO_DATE") == null ? "" : req.getParameter("TO_DATE");
        String toVal = req.getParameter("TO_VALUE") == null ? "" : req.getParameter("TO_VALUE");
        params.setProperty("CATEGORY", super.verifySqlText(cat.trim()));
        params.setProperty("SEARCH", super.verifySqlText(search.trim()));
        params.setProperty("FR_DATE", super.verifySqlText(fromDate.trim()));
        params.setProperty("TO_DATE", super.verifySqlText(toDate.trim()));
        params.setProperty("FR_VALUE", super.verifySqlText(fromVal.trim()));
        params.setProperty("TO_VALUE", super.verifySqlText(toVal.trim()));
        return params;
    }

    private Vector buildTags() {
        Vector<String> tagsV = new Vector<String>();
        tagsV.add("#DISC_ID#");
        tagsV.add("#HEADLINE#");
        tagsV.add("#C_REPLIES#");
        tagsV.add("#A_DATE#");
        tagsV.add("#REPLY_URL#");
        return tagsV;
    }

    public void log(String msg) {
        super.log("BillBoardDisc: " + msg);
    }

    private Properties buildSearchDateParams(Properties p) {
        GregorianCalendar today = new GregorianCalendar();
        today.set(5, today.get(5) + 1);
        int tYear = today.get(1);
        int tMonth = 1 + today.get(2);
        int tDay = today.get(5);
        today.set(5, today.get(5) - 2);
        int yYear = today.get(1);
        int yMonth = 1 + today.get(2);
        int yDay = today.get(5);
        if (p.getProperty("TO_DATE").equals("") || p.getProperty("TO_DATE").equalsIgnoreCase(p.getProperty("TO_VALUE"))) {
            p.setProperty("TO_DATE", "" + tYear + "-" + tMonth + "-" + tDay);
        }
        if (p.getProperty("FR_DATE").equals("") || p.getProperty("FR_DATE").equalsIgnoreCase(p.getProperty("FR_VALUE"))) {
            p.setProperty("FR_DATE", "" + yYear + "-" + yMonth + "-" + yDay);
        }
        Date fromDate = null;
        Date toDate = null;
        try {
            fromDate = Date.valueOf(p.getProperty("FR_DATE"));
            toDate = Date.valueOf(p.getProperty("TO_DATE"));
        }
        catch (Exception e) {
            this.log("Invalid FROM date: " + fromDate);
            this.log("Invalid TO date: " + toDate);
            return null;
        }
        return p;
    }

    private boolean checkSearchWords(Properties p) {
        String str = p.getProperty("SEARCH").trim();
        if (str.equalsIgnoreCase("")) {
            return false;
        }
        return str.length() > 2;
    }
}

