/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import com.imcode.imcms.flow.EditBrowserDocumentPageFlow;
import com.imcode.test.mock.MockHttpServletRequest;
import imcode.server.Config;
import imcode.server.ImcmsServices;
import imcode.server.db.Database;
import imcode.server.db.MockDatabase;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentPermissionSetMapper;
import imcode.server.document.index.DocumentIndex;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.util.Clock;
import java.util.Map;
import junit.framework.TestCase;

public class TestEditBrowserDocumentPageFlow
extends TestCase {
    EditBrowserDocumentPageFlow editBrowserDocumentPageFlow;
    private BrowserDocumentDomainObject browserDocument;
    private BrowserDocumentDomainObject.Browser otherBrowser;
    private DocumentMapper documentMapper;

    protected void setUp() throws Exception {
        super.setUp();
        this.browserDocument = new BrowserDocumentDomainObject();
        this.otherBrowser = new BrowserDocumentDomainObject.Browser(1, "Other", 1);
        this.editBrowserDocumentPageFlow = new EditBrowserDocumentPageFlow(this.browserDocument, null, null);
        this.documentMapper = new MockDocumentMapper(null, new MockDatabase(), null, null, null, null, new Config());
    }

    public void testGetAddedBrowsersFromRequest() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setupAddParameter("browsers", new String[0]);
        request.setupAddParameter("destination_" + BrowserDocumentDomainObject.Browser.DEFAULT.getId(), "1001");
        request.setupAddParameter("destination_" + this.otherBrowser.getId(), "1002");
        Map addedBrowsers = this.editBrowserDocumentPageFlow.getAddedBrowsersFromRequest(request, this.documentMapper);
        TestEditBrowserDocumentPageFlow.assertEquals((Object)new Integer(1002), addedBrowsers.get(this.otherBrowser));
        TestEditBrowserDocumentPageFlow.assertEquals((Object)new Integer(1001), addedBrowsers.get(BrowserDocumentDomainObject.Browser.DEFAULT));
    }

    public class MockDocumentMapper
    extends DocumentMapper {
        public MockDocumentMapper(ImcmsServices services, Database database, ImcmsAuthenticatorAndUserAndRoleMapper userRegistry, DocumentPermissionSetMapper documentPermissionSetMapper, DocumentIndex documentIndex, Clock clock, Config config) {
            super(services, database, userRegistry, documentPermissionSetMapper, documentIndex, clock, config);
        }

        protected BrowserDocumentDomainObject.Browser createBrowserFromSqlRow(String[] sqlRow) {
            return TestEditBrowserDocumentPageFlow.this.otherBrowser;
        }
    }
}

