/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api.contrib;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.TextDocument;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class DateTextFieldTextDocumentComparator
extends Document.Comparator {
    private String datePattern = "yyyy-MM-dd";
    private int textFieldNumber;

    public DateTextFieldTextDocumentComparator(int textFieldNumber) {
        this.textFieldNumber = textFieldNumber;
    }

    public DateTextFieldTextDocumentComparator(int textFieldNumber, String datePattern) {
        this(textFieldNumber);
        this.datePattern = datePattern;
    }

    private int compareDate(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        return date1.compareTo(date2);
    }

    private int compareDateStrings(String s1, String s2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
        Date date1 = null;
        Date date2 = null;
        if (StringUtils.isBlank((String)s1) && StringUtils.isBlank((String)s2)) {
            return 0;
        }
        if (StringUtils.isBlank((String)s1)) {
            return -1;
        }
        if (StringUtils.isBlank((String)s2)) {
            return 1;
        }
        try {
            date1 = simpleDateFormat.parse(s1);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            date2 = simpleDateFormat.parse(s2);
        }
        catch (ParseException ex1) {
            // empty catch block
        }
        return this.compareDate(date1, date2);
    }

    protected int compareDocuments(Document d1, Document d2) throws NoPermissionException {
        try {
            TextDocument textDocument1 = (TextDocument)d1;
            TextDocument textDocument2 = (TextDocument)d2;
            if (textDocument1 == null && textDocument2 == null) {
                return 0;
            }
            if (textDocument1 == null) {
                return -1;
            }
            if (textDocument2 == null) {
                return 1;
            }
            int result = this.compareDateStrings(textDocument1.getTextField(this.textFieldNumber).getText(), textDocument2.getTextField(this.textFieldNumber).getText());
            if (result != 0) {
                return result;
            }
            if (textDocument1.getId() > textDocument2.getId()) {
                return 1;
            }
            if (textDocument1.getId() < textDocument2.getId()) {
                return -1;
            }
            return 0;
        }
        catch (NoPermissionException ex) {
            throw new RuntimeException(this.getClass().getName() + ".compare(): Failed to get text fields.", ex);
        }
    }
}

