/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.TextDocument;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.parser.ParserParameters;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class TextDocumentViewing {
    private TextDocument textDocument;
    private ParserParameters parserParameters;
    private static final String REQUEST_ATTRIBUTE__VIEWING = TextDocumentViewing.class.getName();

    public TextDocumentViewing(ParserParameters parserParameters) {
        this.parserParameters = parserParameters;
        this.textDocument = new TextDocument((TextDocumentDomainObject)parserParameters.getDocumentRequest().getDocument(), ContentManagementSystem.fromRequest((ServletRequest)parserParameters.getDocumentRequest().getHttpServletRequest()));
    }

    public static TextDocumentViewing fromRequest(HttpServletRequest request) {
        return (TextDocumentViewing)request.getAttribute(REQUEST_ATTRIBUTE__VIEWING);
    }

    public TextDocument getTextDocument() {
        return this.textDocument;
    }

    public boolean isEditing() {
        return this.parserParameters.isAnyMode();
    }

    public boolean isEditingTexts() {
        return this.parserParameters.isTextMode();
    }

    public boolean isEditingImages() {
        return this.parserParameters.isImageMode();
    }

    public boolean isEditingMenus() {
        return this.parserParameters.isMenuMode();
    }

    public boolean isEditingIncludes() {
        return this.parserParameters.isIncludesMode();
    }

    public boolean isEditingTemplate() {
        return this.parserParameters.isTemplateMode();
    }

    public Integer getEditedMenuIndex() {
        return this.parserParameters.getEditingMenuIndex();
    }

    public static TextDocumentViewing putInRequest(TextDocumentViewing viewing) {
        HttpServletRequest httpServletRequest = viewing.parserParameters.getDocumentRequest().getHttpServletRequest();
        TextDocumentViewing previousViewing = TextDocumentViewing.fromRequest(httpServletRequest);
        httpServletRequest.setAttribute(REQUEST_ATTRIBUTE__VIEWING, (Object)viewing);
        return previousViewing;
    }
}

