/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.log;

import imcode.server.DocumentRequest;
import imcode.server.Revisits;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.or.ObjectRenderer;

public class FakeRequestRenderer
implements ObjectRenderer {
    private static final String REDIRECT_PREFIX = "/RD";

    public String doRender(Object o) {
        DocumentRequest docReq = (DocumentRequest)o;
        DocumentDomainObject document = docReq.getDocument();
        DocumentDomainObject referrer = docReq.getReferrer();
        StringBuffer result = new StringBuffer(docReq.getHttpServletRequest().getRemoteAddr());
        result.append(' ').append(docReq.getUser().getId());
        result.append(" sessionID=").append(docReq.getHttpServletRequest().getSession().getId());
        Revisits revisits = docReq.getRevisits();
        result.append(";imVisits=").append(revisits.getRevisitsId());
        if (null != revisits.getRevisitsDate()) {
            result.append(revisits.getRevisitsDate());
        }
        result.append(' ').append(docReq.getHttpServletRequest().getContextPath()).append(REDIRECT_PREFIX).append(this.renderDocument(document));
        if (null != referrer) {
            result.append(' ').append(docReq.getHttpServletRequest().getContextPath()).append(REDIRECT_PREFIX).append(this.renderDocument(referrer));
        }
        return result.toString();
    }

    private String renderDocument(DocumentDomainObject document) {
        Object[] sections = document.getSections();
        int metaId = document.getId();
        int docType = document.getDocumentTypeId();
        String headline = document.getHeadline();
        StringBuffer result = new StringBuffer();
        result.append('/');
        if (0 < sections.length) {
            result.append(this.lossyUrlEncode(StringUtils.join((Object[])sections, (String)",")));
        } else {
            result.append('_');
        }
        result.append('/');
        result.append(metaId);
        result.append('/');
        result.append(docType);
        result.append('/');
        result.append(this.lossyUrlEncode(headline));
        result.append('/');
        if (document instanceof TextDocumentDomainObject) {
            TemplateDomainObject template = ((TextDocumentDomainObject)document).getTemplate();
            result.append(this.lossyUrlEncode(template.getName()));
        }
        result.append('/');
        return result.toString();
    }

    private final String lossyUrlEncode(String url) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (' ' == c) {
                result.append('_');
                continue;
            }
            if (',' == c || '.' == c || '-' == c || '_' == c) {
                result.append(c);
                continue;
            }
            if (c < ' ' || c >= '\u0080' && c < '\u00a0') continue;
            if (c < '\u0100' && Character.isLetterOrDigit(c)) {
                result.append(c);
                continue;
            }
            try {
                result.append(URLEncoder.encode("" + c, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        return result.toString();
    }
}

