/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class Prefs {
    private static final Hashtable hash = new Hashtable();
    private static File configPath = null;

    public static void setConfigPath(File confPath) {
        configPath = confPath;
    }

    public static void flush() {
        hash.clear();
    }

    public static String get(String key, String file) throws IOException {
        return Prefs.get(key, new File(configPath, file));
    }

    private static String get(String key, File file) throws IOException {
        String temp = Prefs.getProperties(file).getProperty(key);
        if (temp == null) {
            hash.remove(file);
        }
        return Prefs.getProperties(file).getProperty(key);
    }

    public static Properties getProperties(String file) throws IOException {
        return Prefs.getProperties(new File(configPath, file));
    }

    private static Properties getProperties(File file) throws IOException {
        Properties prop = (Properties)hash.get(file);
        if (prop == null) {
            FileInputStream in;
            try {
                in = new FileInputStream(file);
            }
            catch (IOException ex) {
                throw new IOException("Prefs: File not found: " + file.getAbsolutePath());
            }
            prop = new Properties();
            prop.load(in);
            hash.put(file, prop);
        }
        return prop;
    }
}

