/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.util.MultipartParser;
import java.util.LinkedList;

public class MultipartFormdataParser {
    private MultipartParser mp;
    private String[] names;

    public MultipartFormdataParser(byte[] data, String contenttype) {
        this.mp = new MultipartParser(data, contenttype);
        this.names = new String[this.mp.countParts()];
        for (int i = 0; i < this.mp.countParts(); ++i) {
            this.names[i] = this.mp.getHeaderParams(i, "content-disposition").getProperty("name");
        }
    }

    public String[] getParameterValues(String name) {
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name)) continue;
            list.add(this.mp.getBody(i));
        }
        if (list.size() == 0) {
            return null;
        }
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (String)list.get(i);
        }
        return ret;
    }

    public String getParameter(String name) {
        String[] ret = this.getParameterValues(name);
        if (ret == null) {
            return null;
        }
        return ret[0];
    }

    public String getFilename(String name) {
        String filename = null;
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name)) continue;
            filename = this.mp.getHeaderParams(i, "content-disposition").getProperty("filename");
            filename = filename.substring(filename.lastIndexOf(47) + 1);
            filename = filename.substring(filename.lastIndexOf(92) + 1);
        }
        return filename;
    }
}

