/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.util.HttpSessionAttribute;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;

public class HttpSessionUtils {
    private static final Logger log = Logger.getLogger((String)HttpSessionUtils.class.getName());
    private static final String SESSION_ATTRIBUTE_NAME__SESSION_MAP = HttpSessionUtils.class.getName() + ".sessionMap";
    private static final int MAX_COUNT__SESSION_OBJECTS = 7;

    private HttpSessionUtils() {
    }

    public static void setSessionAttributeAndSetNameInRequestAttribute(Serializable objectToAddToSession, HttpServletRequest request, String sessionAttributeNameRequestAttributeName) {
        String sessionAttributeName = objectToAddToSession instanceof HttpSessionAttribute ? ((HttpSessionAttribute)((Object)objectToAddToSession)).getSessionAttributeName() : HttpSessionUtils.getSessionAttributeNameFromRequest(request, sessionAttributeNameRequestAttributeName);
        if (null == sessionAttributeName || !objectToAddToSession.equals(HttpSessionUtils.get(request, sessionAttributeName))) {
            sessionAttributeName = HttpSessionUtils.createUniqueNameForObject(objectToAddToSession);
            HttpSessionUtils.put(request, sessionAttributeName, objectToAddToSession);
        }
        request.setAttribute(sessionAttributeNameRequestAttributeName, (Object)sessionAttributeName);
    }

    private static Object get(HttpServletRequest request, String sessionAttributeName) {
        return HttpSessionUtils.getSessionMap(request).get((Object)sessionAttributeName);
    }

    public static void put(HttpServletRequest request, String sessionAttributeName, Serializable objectToAddToSession) {
        LRUMap sessionMap = HttpSessionUtils.getSessionMap(request);
        if (sessionMap.isFull()) {
            log.debug((Object)"SessionMap is full. Least recently used object will be evicted.");
        }
        if (objectToAddToSession instanceof HttpSessionAttribute) {
            ((HttpSessionAttribute)((Object)objectToAddToSession)).setSessionAttributeName(sessionAttributeName);
        }
        sessionMap.put((Object)sessionAttributeName, (Object)objectToAddToSession);
        log.debug((Object)("Put in session: \"" + sessionAttributeName + "\": " + objectToAddToSession.getClass() + ". Size: " + sessionMap.size()));
    }

    private static LRUMap getSessionMap(HttpServletRequest request) {
        HttpSession session = request.getSession();
        LRUMap sessionMap = (LRUMap)session.getAttribute(SESSION_ATTRIBUTE_NAME__SESSION_MAP);
        if (null == sessionMap) {
            sessionMap = new LRUMap(7);
            session.setAttribute(SESSION_ATTRIBUTE_NAME__SESSION_MAP, (Object)sessionMap);
        }
        return sessionMap;
    }

    public static String createUniqueNameForObject(Object object) {
        return Integer.toString(object.getClass().hashCode(), 36) + RandomStringUtils.randomAlphanumeric((int)4);
    }

    public static Object getSessionAttributeWithNameInRequest(HttpServletRequest request, String requestAttributeOrParameterName) {
        String sessionAttributeName = HttpSessionUtils.getSessionAttributeNameFromRequest(request, requestAttributeOrParameterName);
        LRUMap sessionMap = HttpSessionUtils.getSessionMap(request);
        Object sessionAttribute = sessionMap.get(sessionAttributeName);
        if (null == sessionAttribute) {
            HttpSessionUtils.removeSessionAttribute(request, sessionAttributeName);
        }
        return sessionAttribute;
    }

    public static Object removeSessionAttributeWithNameInRequest(HttpServletRequest request, String requestAttributeOrParameterName) {
        String sessionAttributeName = HttpSessionUtils.getSessionAttributeNameFromRequest(request, requestAttributeOrParameterName);
        return HttpSessionUtils.removeSessionAttribute(request, sessionAttributeName);
    }

    public static Object removeSessionAttribute(HttpServletRequest request, String sessionAttributeName) {
        LRUMap sessionMap = HttpSessionUtils.getSessionMap(request);
        Object object = sessionMap.remove(sessionAttributeName);
        if (null != object) {
            log.debug((Object)("Removed from session: \"" + sessionAttributeName + "\": " + object.getClass() + ". Size: " + sessionMap.size()));
        }
        return object;
    }

    public static String getSessionAttributeNameFromRequest(HttpServletRequest request, String requestAttributeOrParameterName) {
        String sessionAttributeName = (String)request.getAttribute(requestAttributeOrParameterName);
        if (null == sessionAttributeName) {
            sessionAttributeName = request.getParameter(requestAttributeOrParameterName);
        }
        return sessionAttributeName;
    }
}

