/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.user.ImmutableRoleDomainObject;
import imcode.server.user.RolePermissionDomainObject;
import imcode.util.LocalizedMessage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class RoleDomainObject
implements Serializable,
Comparable {
    public static final RoleDomainObject SUPERADMIN = new ImmutableRoleDomainObject(0, "Superadmin", 1);
    public static final RoleDomainObject USERADMIN = new ImmutableRoleDomainObject(1, "Useradmin", 2);
    public static final RoleDomainObject USERS = new ImmutableRoleDomainObject(2, "Users", 0);
    public static final RolePermissionDomainObject PASSWORD_MAIL_PERMISSION = new RolePermissionDomainObject(1, new LocalizedMessage("role_permission/password_by_email/description"));
    public static final RolePermissionDomainObject CONFERENCE_REGISTRATION_PERMISSION = new RolePermissionDomainObject(2, new LocalizedMessage("role_permission/conference_register/description"));
    public static final RolePermissionDomainObject ADMIN_PAGES_PERMISSION = new RolePermissionDomainObject(4, new LocalizedMessage("role_permission/admin_pages_access/desciption"));
    private static final RolePermissionDomainObject[] ALL_ROLE_PERMISSIONS = new RolePermissionDomainObject[]{PASSWORD_MAIL_PERMISSION, CONFERENCE_REGISTRATION_PERMISSION, ADMIN_PAGES_PERMISSION};
    private int id;
    private String name;
    private int adminRoleId;
    private Set permissions = new HashSet();
    public static final int SUPERADMIN_ID = SUPERADMIN.getId();
    public static final int USERADMIN_ID = USERADMIN.getId();
    public static final int USERS_ID = USERS.getId();

    public RoleDomainObject(String name) {
        this(0, name, 0);
    }

    public RoleDomainObject(int roleId, String roleName, int adminRoleId) {
        this.id = roleId;
        this.name = roleName;
        this.adminRoleId = adminRoleId;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleDomainObject)) {
            return false;
        }
        RoleDomainObject roleDomainObject = (RoleDomainObject)o;
        if (this.isAdminRole() || roleDomainObject.isAdminRole()) {
            return this.adminRoleId == roleDomainObject.adminRoleId;
        }
        return this.id == roleDomainObject.id;
    }

    public int hashCode() {
        if (this.isAdminRole()) {
            return -this.adminRoleId;
        }
        return this.id;
    }

    public String toString() {
        return "(role " + this.id + " \"" + this.name + "\" " + this.adminRoleId + ")";
    }

    public boolean isAdminRole() {
        return 0 != this.adminRoleId;
    }

    public int compareTo(Object o) {
        return this.name.compareToIgnoreCase(((RoleDomainObject)o).name);
    }

    public void addPermission(RolePermissionDomainObject permission) {
        this.permissions.add(permission);
    }

    public boolean hasPermission(RolePermissionDomainObject permission) {
        return this.permissions.contains(permission);
    }

    public void removePermission(RolePermissionDomainObject permission) {
        this.permissions.remove(permission);
    }

    public RolePermissionDomainObject[] getPermissions() {
        return this.permissions.toArray(new RolePermissionDomainObject[this.permissions.size()]);
    }

    public void addUnionOfPermissionIdsToRole(int unionOfRolePermissionIds) {
        for (int i = 0; i < ALL_ROLE_PERMISSIONS.length; ++i) {
            RolePermissionDomainObject permission = ALL_ROLE_PERMISSIONS[i];
            if (!this.bitIsSet(unionOfRolePermissionIds, permission.getId())) continue;
            this.addPermission(permission);
        }
    }

    private boolean bitIsSet(int unionOfRolePermissionIds, int bitValue) {
        return 0 != (unionOfRolePermissionIds & bitValue);
    }

    public static RolePermissionDomainObject[] getAllRolePermissions() {
        return ALL_ROLE_PERMISSIONS;
    }
}

