/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import com.imcode.imcms.api.TextDocumentViewing;
import imcode.server.DocumentRequest;
import imcode.server.ImcmsServices;
import imcode.server.LanguageMapper;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.textdocument.FileDocumentImageSource;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.parser.MenuParser;
import imcode.server.parser.ParserParameters;
import imcode.server.parser.TextDocumentParser;
import imcode.server.user.UserDomainObject;
import imcode.util.FileCache;
import imcode.util.Html;
import imcode.util.ImcmsImageUtils;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

class TagParser {
    private static Pattern HTML_PREBODY_PATTERN = null;
    private static Pattern HTML_POSTBODY_PATTERN = null;
    private static Pattern IMCMS_TAG_PATTERN = null;
    private static Pattern IMCMS_END_TAG_PATTERN = null;
    private static Pattern ATTRIBUTES_PATTERN;
    private static final Logger log;
    private FileCache fileCache = new FileCache();
    private final Substitution NULL_SUBSTITUTION = new StringSubstitution("");
    private TextDocumentParser textDocParser;
    private boolean includeMode;
    private int includeLevel;
    private int implicitIncludeNumber = 1;
    private Map textMap;
    private boolean textMode;
    private int implicitTextNumber = 1;
    private Map imageMap;
    private boolean imageMode;
    private int implicitImageNumber = 1;
    private ImcmsServices service;
    private ParserParameters parserParameters;
    private DocumentRequest documentRequest;
    private TextDocumentDomainObject document;
    private TextDocumentViewing viewing;

    TagParser(TextDocumentParser textdocparser, ParserParameters parserParameters, int includelevel, TextDocumentViewing viewing) {
        this.textDocParser = textdocparser;
        this.parserParameters = parserParameters;
        this.documentRequest = parserParameters.getDocumentRequest();
        this.document = (TextDocumentDomainObject)this.documentRequest.getDocument();
        this.service = this.documentRequest.getServices();
        this.includeMode = viewing.isEditingIncludes();
        this.includeLevel = includelevel;
        this.textMode = viewing.isEditingTexts();
        this.textMap = this.document.getTexts();
        this.imageMode = viewing.isEditingImages();
        this.imageMap = TagParser.getImageMap(this.document, this.imageMode, this.documentRequest);
        this.viewing = viewing;
    }

    private static Map getImageMap(TextDocumentDomainObject document, boolean imageMode, DocumentRequest documentRequest) {
        Map images = document.getImages();
        HashMap<Integer, String> imageMap = new HashMap<Integer, String>();
        Iterator iterator = images.keySet().iterator();
        while (iterator.hasNext()) {
            Integer imageIndex = (Integer)iterator.next();
            ImageDomainObject image = (ImageDomainObject)images.get(imageIndex);
            ImageSource imageSource = image.getSource();
            if (imageSource instanceof FileDocumentImageSource && !imageMode && !documentRequest.getUser().canAccess(((FileDocumentImageSource)imageSource).getFileDocument())) continue;
            imageMap.put(imageIndex, ImcmsImageUtils.getImageHtmlTag(image, documentRequest.getHttpServletRequest()));
        }
        return imageMap;
    }

    private String tagMetaId() {
        return "" + this.document.getId();
    }

    private String tagSection(Properties attributes) {
        return this.tagSections(attributes);
    }

    private String tagSections(Properties attributes) {
        Object[] section = this.document.getSections();
        String separator = attributes.getProperty("separator", ",");
        return StringUtils.join((Object[])section, (String)separator);
    }

    private String tagInclude(Properties attributes, PatternMatcher patMat) {
        int no;
        if (this.shouldOutputNothingAccordingToMode(attributes, this.includeMode)) {
            return "";
        }
        String attributevalue = attributes.getProperty("no");
        if (null != attributevalue) {
            try {
                no = Integer.parseInt(attributevalue.trim());
                this.implicitIncludeNumber = no + 1;
            }
            catch (NumberFormatException ex) {
                return "<!-- imcms:include no failed: " + ex + " -->";
            }
        } else {
            attributevalue = attributes.getProperty("path");
            if (null != attributevalue) {
                return this.includePath(attributevalue);
            }
            attributevalue = attributes.getProperty("file");
            if (null != attributevalue) {
                return this.includeFile(attributevalue, patMat);
            }
            attributevalue = attributes.getProperty("document");
            if (null != attributevalue) {
                return this.includeDocument(attributevalue, attributes, patMat);
            }
            attributevalue = attributes.getProperty("url");
            if (null != attributevalue) {
                return this.includeUrl(attributevalue, attributes);
            }
            no = this.implicitIncludeNumber++;
        }
        return this.includeEditing(attributes, no, patMat);
    }

    private String includePath(String path) {
        HttpServletRequest request = this.documentRequest.getHttpServletRequest();
        MetaIdHeaderHttpServletRequest metaIdHeaderHttpServletRequest = new MetaIdHeaderHttpServletRequest(request, this.document.getId());
        try {
            return Utility.getContents(path, (HttpServletRequest)metaIdHeaderHttpServletRequest, this.documentRequest.getHttpServletResponse());
        }
        catch (ServletException ex) {
            return "<!-- imcms:include path failed: " + (Object)((Object)ex) + " -->";
        }
        catch (IOException ex) {
            return "<!-- imcms:include path failed: " + ex + " -->";
        }
    }

    private String includeEditing(Properties attributes, int no, PatternMatcher patMat) {
        try {
            String label = this.getLabel(attributes);
            Integer includedDocumentId = this.document.getIncludedDocumentId(no);
            if (this.includeMode) {
                HttpServletRequest request = this.documentRequest.getHttpServletRequest();
                HttpServletResponse response = this.documentRequest.getHttpServletResponse();
                UserDomainObject user = this.documentRequest.getUser();
                try {
                    request.setAttribute("includingDocument", (Object)this.document);
                    request.setAttribute("includedDocumentId", (Object)includedDocumentId);
                    request.setAttribute("label", (Object)label);
                    request.setAttribute("includeIndex", (Object)new Integer(no));
                    return Utility.getContents("/imcms/" + user.getLanguageIso639_2() + "/jsp/docadmin/text/edit_include.jsp", request, response);
                }
                catch (Exception e) {
                    throw new UnhandledException((Throwable)e);
                }
            }
            if (this.includeLevel > 0) {
                if (null == includedDocumentId) {
                    return "";
                }
                ParserParameters includedDocumentParserParameters = this.createIncludedDocumentParserParameters(this.parserParameters, includedDocumentId, attributes);
                String documentStr = this.textDocParser.parsePage(includedDocumentParserParameters, this.includeLevel - 1);
                documentStr = Util.substitute((PatternMatcher)patMat, (Pattern)HTML_PREBODY_PATTERN, (Substitution)this.NULL_SUBSTITUTION, (String)documentStr);
                documentStr = Util.substitute((PatternMatcher)patMat, (Pattern)HTML_POSTBODY_PATTERN, (Substitution)this.NULL_SUBSTITUTION, (String)documentStr);
                return documentStr;
            }
            return "<!-- imcms:include failed: max include-level reached. -->";
        }
        catch (IOException ex) {
            return "<!-- imcms:include failed: " + ex + " -->";
        }
    }

    private String includeUrl(String attribute, Properties attributes) {
        String urlStr = attribute;
        try {
            int charsRead;
            URL url;
            String urlProtocol;
            String commaSeparatedNamesOfParametersToSend = attributes.getProperty("sendparameters");
            urlStr = urlStr + (-1 == urlStr.indexOf(63) ? "?" : "&");
            Set parameterNamesToSend = this.createSetFromCommaSeparatedString(commaSeparatedNamesOfParametersToSend);
            urlStr = urlStr + this.createQueryStringFromRequest(this.documentRequest.getHttpServletRequest(), parameterNamesToSend);
            if (urlStr.startsWith("/")) {
                urlStr = this.documentRequest.getHttpServletRequest().getScheme() + "://" + this.documentRequest.getHttpServletRequest().getServerName() + ':' + this.documentRequest.getHttpServletRequest().getServerPort() + urlStr;
            }
            if ("file".equalsIgnoreCase(urlProtocol = (url = new URL(urlStr)).getProtocol())) {
                return "<!-- imcms:include url failed: file-url not allowed -->";
            }
            String sessionId = this.documentRequest.getHttpServletRequest().getSession().getId();
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("User-Agent", this.documentRequest.getHttpServletRequest().getHeader("User-agent"));
            if (null != attributes.getProperty("sendsessionid")) {
                urlConnection.addRequestProperty("Cookie", "JSESSIONID=" + sessionId);
            }
            if (null != attributes.getProperty("sendcookies")) {
                Cookie[] requestCookies = this.documentRequest.getHttpServletRequest().getCookies();
                for (int i = 0; requestCookies != null && i < requestCookies.length; ++i) {
                    Cookie theCookie = requestCookies[i];
                    if ("JSESSIONID".equals(theCookie.getName())) continue;
                    urlConnection.addRequestProperty("Cookie", theCookie.getName() + "=" + theCookie.getValue());
                }
            }
            if (null != attributes.getProperty("sendmetaid")) {
                urlConnection.setRequestProperty("X-Meta-Id", "" + this.document.getId());
            }
            InputStream connectionInputStream = urlConnection.getInputStream();
            String contentType = urlConnection.getContentType();
            String contentEncoding = StringUtils.substringAfter((String)contentType, (String)"charset=");
            if ("".equals(contentEncoding)) {
                contentEncoding = "windows-1252";
            }
            InputStreamReader urlInput = new InputStreamReader(connectionInputStream, contentEncoding);
            int URL_BUFFER_LEN = 16384;
            char[] buffer = new char[16384];
            StringBuffer urlResult = new StringBuffer();
            while (-1 != (charsRead = urlInput.read(buffer, 0, 16384))) {
                urlResult.append(buffer, 0, charsRead);
            }
            return urlResult.toString();
        }
        catch (MalformedURLException ex) {
            return "<!-- imcms:include url failed: " + ex + " -->";
        }
        catch (IOException ex) {
            return "<!-- imcms:include url failed: " + ex + " -->";
        }
        catch (RuntimeException ex) {
            return "<!-- imcms:include url failed: " + ex + " -->";
        }
    }

    private String includeDocument(String attributevalue, Properties attributes, PatternMatcher patMat) {
        try {
            if (this.includeLevel > 0) {
                int included_meta_id = Integer.parseInt(attributevalue);
                ParserParameters includedDocumentParserParameters = this.createIncludedDocumentParserParameters(this.parserParameters, included_meta_id, attributes);
                String documentStr = this.textDocParser.parsePage(includedDocumentParserParameters, this.includeLevel - 1);
                documentStr = Util.substitute((PatternMatcher)patMat, (Pattern)HTML_PREBODY_PATTERN, (Substitution)this.NULL_SUBSTITUTION, (String)documentStr);
                documentStr = Util.substitute((PatternMatcher)patMat, (Pattern)HTML_POSTBODY_PATTERN, (Substitution)this.NULL_SUBSTITUTION, (String)documentStr);
                return documentStr;
            }
        }
        catch (NumberFormatException ex) {
            return "<!-- imcms:include document failed: " + ex + " -->";
        }
        catch (IOException ex) {
            return "<!-- imcms:include document failed: " + ex + " -->";
        }
        catch (RuntimeException ex) {
            return "<!-- imcms:include document failed: " + ex + " -->";
        }
        return "";
    }

    private String includeFile(String attributevalue, PatternMatcher patMat) {
        try {
            return this.replaceTags(patMat, this.fileCache.getCachedFileString(new File(this.service.getIncludePath(), attributevalue)), false);
        }
        catch (IOException ex) {
            return "<!-- imcms:include file failed: " + ex + " -->";
        }
    }

    private ParserParameters createIncludedDocumentParserParameters(ParserParameters parserParameters, int included_meta_id, Properties attributes) {
        ParserParameters includedParserParameters = null;
        try {
            includedParserParameters = (ParserParameters)parserParameters.clone();
            includedParserParameters.setTemplate(attributes.getProperty("template"));
            includedParserParameters.setParameter(attributes.getProperty("param"));
            includedParserParameters.getDocumentRequest().setDocument(this.service.getDocumentMapper().getDocument(included_meta_id));
            includedParserParameters.getDocumentRequest().setReferrer(this.document);
            includedParserParameters.setFlags(0);
            includedParserParameters.setAdminButtonsVisible(false);
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        return includedParserParameters;
    }

    private String createQueryStringFromRequest(HttpServletRequest httpServletRequest, Set parameterNamesToSend) {
        ArrayList<String> parameterNameValuePairs = new ArrayList<String>();
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (null != parameterNamesToSend && !parameterNamesToSend.contains(parameterName)) continue;
            String[] parameterValues = httpServletRequest.getParameterValues(parameterName);
            for (int i = 0; i < parameterValues.length; ++i) {
                String parameterValue = parameterValues[i];
                parameterNameValuePairs.add(URLEncoder.encode(parameterName) + '=' + URLEncoder.encode(parameterValue));
            }
        }
        return StringUtils.join(parameterNameValuePairs.iterator(), (char)'&');
    }

    private Set createSetFromCommaSeparatedString(String commaSeparatedNames) {
        if (null == commaSeparatedNames) {
            return null;
        }
        StringTokenizer commaAndWhitespaceSeparatedTokenizer = new StringTokenizer(commaSeparatedNames, ", \t\r\n");
        HashSet<String> names = new HashSet<String>();
        while (commaAndWhitespaceSeparatedTokenizer.hasMoreTokens()) {
            String parameterName = commaAndWhitespaceSeparatedTokenizer.nextToken();
            names.add(parameterName);
        }
        return names;
    }

    private String tagText(Properties attributes, PatternMatcher patMat) {
        TextDomainObject text;
        int no;
        if (this.shouldOutputNothingAccordingToMode(attributes, this.textMode)) {
            return "";
        }
        String noStr = attributes.getProperty("no");
        if (null == noStr) {
            no = this.implicitTextNumber++;
            text = (TextDomainObject)this.textMap.get(new Integer(no));
        } else {
            noStr = noStr.trim();
            no = Integer.parseInt(noStr);
            text = (TextDomainObject)this.textMap.get(new Integer(no));
            this.implicitTextNumber = no + 1;
        }
        String result = "";
        if (text != null) {
            result = text.toHtmlString();
            if (text.getType() == 1) {
                result = this.replaceTags(patMat, result, true);
            }
        }
        if (this.textMode) {
            HttpServletRequest request = this.documentRequest.getHttpServletRequest();
            HttpServletResponse response = this.documentRequest.getHttpServletResponse();
            String formatsAttribute = attributes.getProperty("formats", "");
            String[] formats = null != formatsAttribute ? formatsAttribute.split("\\W+") : null;
            request.setAttribute("document", (Object)this.documentRequest.getDocument());
            request.setAttribute("textIndex", (Object)new Integer(no));
            String label = this.getLabel(attributes);
            request.setAttribute("label", (Object)label);
            request.setAttribute("content", (Object)result);
            request.setAttribute("formats", (Object)formats);
            request.setAttribute("rows", (Object)attributes.getProperty("rows"));
            try {
                result = Utility.getContents("/imcms/" + this.documentRequest.getUser().getLanguageIso639_2() + "/jsp/docadmin/text/edit_text.jsp", request, response);
            }
            catch (ServletException e) {
                throw new UnhandledException((Throwable)e);
            }
            catch (IOException e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        return result;
    }

    private boolean shouldOutputNothingAccordingToMode(Properties attributes, boolean mode) {
        String modeAttribute = attributes.getProperty("mode");
        return StringUtils.isNotBlank((String)modeAttribute) && (mode && "read".startsWith(modeAttribute) || !mode && "write".startsWith(modeAttribute));
    }

    private String getLabel(Properties attributes) {
        return attributes.getProperty("label", "").replaceAll("\\s+", " ");
    }

    private String[] getLabelTags(Properties attributes, int no, String finalresult) {
        String label = this.getLabel(attributes);
        String label_urlparam = "";
        if (!"".equals(label)) {
            label_urlparam = this.removeHtmlTagsAndUrlEncode(label);
        }
        String[] replace_tags = new String[]{"#meta_id#", String.valueOf(this.document.getId()), "#content_id#", "" + no, "#content#", finalresult, "#label_url#", label_urlparam, "#label#", label};
        return replace_tags;
    }

    private String removeHtmlTagsAndUrlEncode(String label) {
        String label_urlparam = Html.removeTags(label);
        label_urlparam = URLEncoder.encode(label_urlparam);
        return label_urlparam;
    }

    private String tagImage(Properties attributes) {
        if (this.shouldOutputNothingAccordingToMode(attributes, this.imageMode)) {
            return "";
        }
        String noStr = attributes.getProperty("no");
        int no = 0;
        String result = null;
        if (null == noStr) {
            no = this.implicitImageNumber++;
            result = (String)this.imageMap.get(new Integer(no));
        } else {
            noStr = noStr.trim();
            no = Integer.parseInt(noStr);
            result = (String)this.imageMap.get(new Integer(no));
            this.implicitImageNumber = no + 1;
        }
        if (result == null) {
            result = "";
        }
        String finalresult = result;
        if (this.imageMode) {
            String[] replace_tags = this.getLabelTags(attributes, no, finalresult);
            String admin_template_file = "".equals(result) ? "textdoc/admin_no_image.frag" : "textdoc/admin_image.frag";
            finalresult = this.service.getAdminTemplate(admin_template_file, this.documentRequest.getUser(), Arrays.asList(replace_tags));
        }
        return finalresult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String tagDatetime(Properties attributes) {
        Date date;
        String format = attributes.getProperty("format") == null ? "yyyy-MM-dd HH:mm" : attributes.getProperty("format");
        String type = attributes.getProperty("type");
        String lang = attributes.getProperty("lang");
        if (type != null) {
            if ("now".startsWith(type = type.toLowerCase())) {
                date = new Date();
            } else if ("created".startsWith(type)) {
                date = this.document.getCreatedDatetime();
            } else if ("modified".startsWith(type)) {
                date = this.document.getModifiedDatetime();
            } else if ("archived".startsWith(type)) {
                date = this.document.getArchivedDatetime();
            } else {
                if (!"activated".startsWith(type)) return "<!-- <?imcms:datetime ... type=\"" + type + "\" is empty, wrong or does not exist! -->";
                date = this.document.getPublicationStartDatetime();
            }
        } else {
            date = new Date();
        }
        SimpleDateFormat formatter = lang == null ? new SimpleDateFormat(format) : new SimpleDateFormat(format, new Locale(lang, ""));
        try {
            if (null != date) return formatter.format(date);
            return "";
        }
        catch (IllegalArgumentException ex) {
            return "<!-- imcms:datetime failed: " + ex.getMessage() + " -->";
        }
    }

    private String tagUser(Properties attributes) {
        UserDomainObject user;
        String who = attributes.getProperty("who");
        if (null != who && "creator".equalsIgnoreCase(who)) {
            user = this.documentRequest.getDocument().getCreator();
        } else if (null != who && "publisher".equalsIgnoreCase(who)) {
            user = this.documentRequest.getDocument().getPublisher();
            if (null == user) {
                return "";
            }
        } else {
            user = this.documentRequest.getUser();
        }
        String result = "";
        String get = attributes.getProperty("get");
        if (get != null && !"".equals(get)) {
            if ("name".equalsIgnoreCase(get)) {
                result = user.getFullName();
            } else if ("firstname".equalsIgnoreCase(get)) {
                result = user.getFirstName();
            } else if ("lastname".equalsIgnoreCase(get)) {
                result = user.getLastName();
            } else if ("company".equalsIgnoreCase(get)) {
                result = user.getCompany();
            } else if ("address".equalsIgnoreCase(get)) {
                result = user.getAddress();
            } else if ("zip".equalsIgnoreCase(get)) {
                result = user.getZip();
            } else if ("city".equalsIgnoreCase(get)) {
                result = user.getCity();
            } else if ("workphone".equalsIgnoreCase(get)) {
                result = user.getWorkPhone();
            } else if ("mobilephone".equalsIgnoreCase(get)) {
                result = user.getMobilePhone();
            } else if ("homephone".equalsIgnoreCase(get)) {
                result = user.getHomePhone();
            } else if ("email".equalsIgnoreCase(get)) {
                result = user.getEmailAddress();
            }
        }
        return result;
    }

    private String tagCategories(Properties attributes) {
        CategoryDomainObject[] categories;
        String categoryTypeName = attributes.getProperty("type");
        String shouldOutputDescription = attributes.getProperty("outputdescription");
        if (null == categoryTypeName) {
            categories = this.document.getCategories();
        } else {
            CategoryTypeDomainObject categoryType = this.service.getDocumentMapper().getCategoryType(categoryTypeName);
            CategoryDomainObject[] categoriesOfType = this.document.getCategoriesOfType(categoryType);
            categories = categoriesOfType;
        }
        Object[] categoryStrings = new String[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            CategoryDomainObject category = categories[i];
            String categoryString = category.getName();
            if (null == categoryTypeName) {
                categoryString = category.getType() + ": " + categoryString;
            }
            if ("only".equalsIgnoreCase(shouldOutputDescription)) {
                categoryString = category.getDescription();
            } else if ("true".equalsIgnoreCase(shouldOutputDescription)) {
                categoryString = categoryString + " - " + category.getDescription();
            }
            categoryStrings[i] = categoryString;
        }
        String separator = attributes.getProperty("separator", ",");
        return StringUtils.join((Object[])categoryStrings, (String)separator);
    }

    private String tagLanguage(Properties attributes) {
        String representation = attributes.getProperty("representation");
        if (null == representation) {
            return LanguageMapper.getCurrentLanguageNameInUsersLanguage(this.documentRequest.getUser(), this.document.getLanguageIso639_2());
        }
        if ("ISO 639-2".equalsIgnoreCase(representation)) {
            return this.document.getLanguageIso639_2();
        }
        return "<!-- <?imcms:language ... representation=\"" + representation + "\" is empty, wrong or does not exist! -->";
    }

    private String singleTag(String tagname, Properties attributes, String entireMatch, PatternMatcher patMat, boolean insideText) {
        String tagResult = entireMatch;
        if ("contextpath".equals(tagname)) {
            tagResult = this.tagContextPath();
        } else if (!insideText) {
            if ("text".equals(tagname)) {
                tagResult = this.tagText(attributes, patMat);
            } else if ("image".equals(tagname)) {
                tagResult = this.tagImage(attributes);
            } else if ("include".equals(tagname)) {
                tagResult = this.tagInclude(attributes, patMat);
            } else if ("metaid".equals(tagname)) {
                tagResult = this.tagMetaId();
            } else if ("datetime".equals(tagname)) {
                tagResult = this.tagDatetime(attributes);
            } else if ("section".equals(tagname)) {
                tagResult = this.tagSection(attributes);
            } else if ("sections".equals(tagname)) {
                tagResult = this.tagSections(attributes);
            } else if ("user".equals(tagname)) {
                tagResult = this.tagUser(attributes);
            } else if ("documentlanguage".equals(tagname)) {
                tagResult = this.tagLanguage(attributes);
            } else if ("documentcategories".equals(tagname)) {
                tagResult = this.tagCategories(attributes);
            }
        }
        return tagResult;
    }

    private String tagContextPath() {
        return this.documentRequest.getHttpServletRequest().getContextPath();
    }

    public String replaceTags(PatternMatcher patMat, String template, boolean insideText) {
        StringBuffer result = new StringBuffer();
        PatternMatcherInput input = new PatternMatcherInput(template);
        int lastMatchEndOffset = 0;
        while (patMat.contains(input, IMCMS_TAG_PATTERN)) {
            result.append(input.substring(lastMatchEndOffset, input.getMatchBeginOffset()));
            MatchResult matres = patMat.getMatch();
            String entireTag = matres.group(0);
            String tagName = matres.group(1);
            String tagattributes = matres.group(2);
            Properties attributes = this.parseAttributes(tagattributes, patMat, this.documentRequest.getHttpServletRequest());
            String tagResult = entireTag;
            tagResult = "menu".equals(tagName) || "velocity".equals(tagName) ? this.findEndTag(tagName, attributes, tagResult, patMat, input) : this.singleTag(tagName, attributes, entireTag, patMat, insideText);
            this.addResultWithPrePost(result, tagResult, attributes);
            lastMatchEndOffset = input.getCurrentOffset();
        }
        result.append(template.substring(lastMatchEndOffset));
        return result.toString();
    }

    private String findEndTag(String tagName, Properties attributes, String entireTag, PatternMatcher patMat, PatternMatcherInput input) {
        String tagResult = entireTag;
        PatternMatcherInput endTagInput = new PatternMatcherInput(input.getBuffer(), input.getMatchEndOffset(), input.getEndOffset() - input.getMatchEndOffset());
        while (patMat.contains(endTagInput, IMCMS_END_TAG_PATTERN)) {
            String endTagName = patMat.getMatch().group(1);
            if (!endTagName.equals(tagName)) continue;
            String elementContent = endTagInput.preMatch();
            input.setCurrentOffset(endTagInput.getMatchEndOffset());
            tagResult = this.blockTag(tagName, attributes, elementContent, patMat);
            break;
        }
        return tagResult;
    }

    private void addResultWithPrePost(StringBuffer result, String tagResult, Properties attributes) {
        if (tagResult.length() > 0) {
            String preAttribute = attributes.getProperty("pre");
            if (preAttribute != null) {
                result.append(preAttribute);
            }
            result.append(tagResult);
            String postAttribute = attributes.getProperty("post");
            if (postAttribute != null) {
                result.append(postAttribute);
            }
        }
    }

    String blockTag(String tagname, Properties attributes, String content, PatternMatcher patternMatcher) {
        String result = content;
        if ("menu".equals(tagname)) {
            result = this.tagMenu(attributes, content, patternMatcher);
        } else if ("velocity".equals(tagname)) {
            result = this.tagVelocity(content);
        }
        return result;
    }

    private String tagMenu(Properties attributes, String content, PatternMatcher patternMatcher) {
        MenuParser menuParser = new MenuParser(this.parserParameters);
        String result = menuParser.tag(attributes, content, patternMatcher, this);
        return result;
    }

    private String tagVelocity(String content) {
        VelocityEngine velocityEngine = this.service.getVelocityEngine(this.parserParameters.getDocumentRequest().getUser());
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("request", (Object)this.parserParameters.getDocumentRequest().getHttpServletRequest());
        velocityContext.put("response", (Object)this.parserParameters.getDocumentRequest().getHttpServletResponse());
        velocityContext.put("viewing", (Object)this.viewing);
        velocityContext.put("document", (Object)this.viewing.getTextDocument());
        velocityContext.put("util", (Object)new VelocityTagUtil());
        StringWriter stringWriter = new StringWriter();
        try {
            velocityEngine.init();
            velocityEngine.evaluate((Context)velocityContext, (Writer)stringWriter, null, content);
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
        String result = stringWriter.toString();
        return result;
    }

    public Properties parseAttributes(String attributes_string, PatternMatcher patternMatcher, HttpServletRequest request) {
        Properties attributes = new Properties();
        PatternMatcherInput attributes_input = new PatternMatcherInput(attributes_string);
        while (patternMatcher.contains(attributes_input, ATTRIBUTES_PATTERN)) {
            MatchResult attribute_matres = patternMatcher.getMatch();
            String escapedValue = attribute_matres.group(3);
            String value = StringEscapeUtils.unescapeHtml((String)escapedValue);
            value = this.tagVelocity(value);
            attributes.setProperty(attribute_matres.group(1), value);
        }
        return attributes;
    }

    static {
        log = Logger.getLogger((String)TagParser.class.getName());
        Perl5Compiler patComp = new Perl5Compiler();
        try {
            HTML_PREBODY_PATTERN = patComp.compile("^.*?<[Bb][Oo][Dd][Yy].*?>", 32784);
            HTML_POSTBODY_PATTERN = patComp.compile("<\\/[Bb][Oo][Dd][Yy]>.*$", 32784);
            IMCMS_TAG_PATTERN = patComp.compile("<\\?imcms:(\\w+)\\b(.*?)\\s*\\?>", 32784);
            IMCMS_END_TAG_PATTERN = patComp.compile("<\\?/imcms:(\\w+)\\s*\\?>", 32784);
            ATTRIBUTES_PATTERN = patComp.compile("\\s+(\\w+)\\s*=\\s*([\"'])(.*?)\\2", 32784);
        }
        catch (MalformedPatternException ignored) {
            log.fatal((Object)"Danger, Will Robinson!", (Throwable)ignored);
        }
    }

    public static class VelocityTagUtil {
        public String escapeHtml(String s) {
            return StringEscapeUtils.escapeHtml((String)s);
        }
    }

    public class MetaIdHeaderHttpServletRequest
    extends HttpServletRequestWrapper {
        private int metaId;

        public MetaIdHeaderHttpServletRequest(HttpServletRequest request, int metaId) {
            super(request);
            this.metaId = metaId;
        }

        public String getHeader(String headerName) {
            if ("x-meta-id".equalsIgnoreCase(headerName)) {
                return "" + this.metaId;
            }
            return super.getHeader(headerName);
        }
    }
}

