/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.textdocument.ImageSource;
import imcode.util.io.FileInputStreamSource;
import imcode.util.io.FileUtility;
import imcode.util.io.InputStreamSource;
import java.io.File;
import java.util.Date;

public class ImagesPathRelativePathImageSource
extends ImageSource {
    private String relativePath;

    public ImagesPathRelativePathImageSource(String relativePath) {
        this.relativePath = relativePath;
    }

    public InputStreamSource getInputStreamSource() {
        return new FileInputStreamSource(this.getFile());
    }

    private File getFile() {
        ImcmsServices service = Imcms.getServices();
        File imageDirectory = service.getConfig().getImagePath();
        File imageFile = new File(imageDirectory, this.relativePath);
        return imageFile;
    }

    public String getUrlPathRelativeToContextPath() {
        File file = new File(this.relativePath);
        return Imcms.getServices().getConfig().getImageUrl() + FileUtility.relativeFileToString(file);
    }

    public String toStorageString() {
        return this.relativePath;
    }

    public int getTypeId() {
        return 0;
    }

    public Date getModifiedDatetime() {
        return new Date(this.getFile().lastModified());
    }
}

