/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.util.LocalizedMessage;

public class DocumentTypeDomainObject {
    public static final int TEXT_ID = 2;
    public static final int URL_ID = 5;
    public static final int BROWSER_ID = 6;
    public static final int HTML_ID = 7;
    public static final int FILE_ID = 8;
    public static final int CONFERENCE_ID = 102;
    public static final int CHAT_ID = 103;
    public static final int BILLBOARD_ID = 104;
    private static final String DOCUMENT_TYPE_NAME_LOCALIZED_MESSAGE_PREFIX = "document_type/name/";
    public static final DocumentTypeDomainObject TEXT = new DocumentTypeDomainObject(2, new LocalizedMessage("document_type/name/text"));
    public static final DocumentTypeDomainObject URL = new DocumentTypeDomainObject(5, new LocalizedMessage("document_type/name/url"));
    public static final DocumentTypeDomainObject BROWSER = new DocumentTypeDomainObject(6, new LocalizedMessage("document_type/name/browser"));
    public static final DocumentTypeDomainObject HTML = new DocumentTypeDomainObject(7, new LocalizedMessage("document_type/name/html"));
    public static final DocumentTypeDomainObject FILE = new DocumentTypeDomainObject(8, new LocalizedMessage("document_type/name/file"));
    public static final DocumentTypeDomainObject CONFERENCE = new DocumentTypeDomainObject(102, new LocalizedMessage("document_type/name/conference"));
    public static final DocumentTypeDomainObject CHAT = new DocumentTypeDomainObject(103, new LocalizedMessage("document_type/name/chat"));
    public static final DocumentTypeDomainObject BILLBOARD = new DocumentTypeDomainObject(104, new LocalizedMessage("document_type/name/billboard"));
    static final DocumentTypeDomainObject[] ALL_DOCUMENT_TYPES = new DocumentTypeDomainObject[]{BILLBOARD, BROWSER, CHAT, CONFERENCE, FILE, HTML, TEXT, URL};
    public static final int PSEUDO_DOCTYPE_ID_FORTUNES = 106;
    private final int id;
    private final LocalizedMessage name;

    public DocumentTypeDomainObject(int id, LocalizedMessage name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public LocalizedMessage getName() {
        return this.name;
    }

    public String toString() {
        return "" + this.id;
    }

    public static int[] getAllDocumentTypeIds() {
        int[] allDocumentTypeIds = new int[ALL_DOCUMENT_TYPES.length];
        for (int i = 0; i < ALL_DOCUMENT_TYPES.length; ++i) {
            DocumentTypeDomainObject documentType = ALL_DOCUMENT_TYPES[i];
            allDocumentTypeIds[i] = documentType.getId();
        }
        return allDocumentTypeIds;
    }
}

