/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import imcode.server.LanguageMapper;
import java.io.File;
import java.security.KeyStore;
import org.apache.commons.lang.StringUtils;

public class Config {
    private File templatePath;
    private File includePath;
    private File fortunePath;
    private File filePath;
    private File imcmsPath;
    private File imagePath;
    private String imageUrl;
    private String smtpServer;
    private int smtpPort;
    private String defaultLanguage;
    private String sessionCookieDomain;
    private String fileAdminRootPaths;
    private int indexingSchedulePeriodInMinutes = 1440;
    private String documentPathPrefix;
    private int documentCacheMaxSize = 100;
    private String keyStorePath;
    private String keyStoreType;

    public void setTemplatePath(File templatePath) {
        this.templatePath = templatePath;
    }

    public void setIncludePath(File includePath) {
        this.includePath = includePath;
    }

    public void setFortunePath(File fortunePath) {
        this.fortunePath = fortunePath;
    }

    public void setFilePath(File filePath) {
        this.filePath = filePath;
    }

    public void setImcmsPath(File imcmsPath) {
        this.imcmsPath = imcmsPath;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        try {
            if (defaultLanguage.length() < 3) {
                defaultLanguage = LanguageMapper.convert639_1to639_2(defaultLanguage);
            }
        }
        catch (LanguageMapper.LanguageNotSupportedException e1) {
            defaultLanguage = null;
        }
        this.defaultLanguage = defaultLanguage;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public File getTemplatePath() {
        return this.templatePath;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public File getImcmsPath() {
        return this.imcmsPath;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public File getFortunePath() {
        return this.fortunePath;
    }

    public File getIncludePath() {
        return this.includePath;
    }

    public String getSessionCookieDomain() {
        return this.sessionCookieDomain;
    }

    public void setSessionCookieDomain(String sessionCookieDomain) {
        this.sessionCookieDomain = sessionCookieDomain;
    }

    public File getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(File imagePath) {
        this.imagePath = imagePath;
    }

    public String getFileAdminRootPaths() {
        return this.fileAdminRootPaths;
    }

    public void setFileAdminRootPaths(String fileAdminRootPaths) {
        this.fileAdminRootPaths = fileAdminRootPaths;
    }

    public int getIndexingSchedulePeriodInMinutes() {
        return this.indexingSchedulePeriodInMinutes;
    }

    public void setIndexingSchedulePeriodInMinutes(int indexingSchedulePeriodInMinutes) {
        this.indexingSchedulePeriodInMinutes = indexingSchedulePeriodInMinutes;
    }

    public String getDocumentPathPrefix() {
        return this.documentPathPrefix;
    }

    public void setDocumentPathPrefix(String documentPathPrefix) {
        this.documentPathPrefix = documentPathPrefix;
    }

    public int getDocumentCacheMaxSize() {
        return this.documentCacheMaxSize;
    }

    public void setDocumentCacheMaxSize(int documentCacheMaxSize) {
        this.documentCacheMaxSize = documentCacheMaxSize;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        if (StringUtils.isBlank((String)keyStoreType)) {
            keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStoreType = keyStoreType;
    }
}

