/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.SystemData;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AdminSystemInfo
extends Administrator {
    private static final Logger log = Logger.getLogger((String)AdminSystemInfo.class.getName());
    private static final String HTML_TEMPLATE = "AdminSystemMessage.htm";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        SystemData sysData = imcref.getSystemData();
        int startDoc = sysData.getStartDocument();
        String msg = sysData.getSystemMessage();
        String webMaster = sysData.getWebMaster();
        String webMasterEmail = sysData.getWebMasterAddress();
        String serverMaster = sysData.getServerMaster();
        String serverMasterEmail = sysData.getServerMasterAddress();
        VariableManager vm = new VariableManager();
        vm.addProperty("STARTDOCUMENT", "" + startDoc);
        vm.addProperty("SYSTEM_MESSAGE", msg);
        vm.addProperty("WEB_MASTER", webMaster);
        vm.addProperty("WEB_MASTER_EMAIL", webMasterEmail);
        vm.addProperty("SERVER_MASTER", serverMaster);
        vm.addProperty("SERVER_MASTER_EMAIL", serverMasterEmail);
        this.sendHtml(req, res, vm, HTML_TEMPLATE);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminSystemInfo. ";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(req, res, header, msg);
            return;
        }
        if (req.getParameter("SetStartDoc") != null) {
            String metaIdString = req.getParameter("STARTDOCUMENT");
            try {
                SystemData sysData = imcref.getSystemData();
                sysData.setStartDocument(Integer.parseInt(metaIdString));
                imcref.setSystemData(sysData);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("SetSystemMsg") != null) {
            String sysMsg = req.getParameter("SYSTEM_MESSAGE") == null ? "" : req.getParameter("SYSTEM_MESSAGE");
            SystemData sysData = imcref.getSystemData();
            sysData.setSystemMessage(sysMsg);
            imcref.setSystemData(sysData);
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("SetServerMasterInfo") != null) {
            String serverMasterEmail;
            String serverMaster = req.getParameter("SERVER_MASTER") == null ? "" : req.getParameter("SERVER_MASTER");
            String string = serverMasterEmail = req.getParameter("SERVER_MASTER_EMAIL") == null ? "" : req.getParameter("SERVER_MASTER_EMAIL");
            if (serverMaster.equalsIgnoreCase("") || !Utility.isValidEmail(serverMasterEmail)) {
                String header = "Error in AdminSystemInfo, servermaster info.";
                Properties langproperties = imcref.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminSystemInfo/validate_form_parameters") + "<br>";
                new AdminError(req, res, header, msg);
                return;
            }
            SystemData sysData = imcref.getSystemData();
            sysData.setServerMaster(serverMaster);
            sysData.setServerMasterAddress(serverMasterEmail);
            imcref.setSystemData(sysData);
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("SetWebMasterInfo") != null) {
            String webMasterEmail;
            String webMaster = req.getParameter("WEB_MASTER") == null ? "" : req.getParameter("WEB_MASTER");
            String string = webMasterEmail = req.getParameter("WEB_MASTER_EMAIL") == null ? "" : req.getParameter("WEB_MASTER_EMAIL");
            if (webMaster.equalsIgnoreCase("") || !Utility.isValidEmail(webMasterEmail)) {
                String header = "Error in AdminSystemInfo, webmaster info.";
                Properties langproperties = imcref.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminSystemInfo/validate_form_parameters") + "<br>";
                new AdminError(req, res, header, msg);
                return;
            }
            SystemData sysData = imcref.getSystemData();
            sysData.setWebMaster(webMaster);
            sysData.setWebMasterAddress(webMasterEmail);
            imcref.setSystemData(sysData);
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("Cancel") != null) {
            res.sendRedirect("AdminManager");
            return;
        }
    }
}

