/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.fortune.DateRange;
import imcode.util.fortune.Quote;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AdminRandomTexts
extends Administrator {
    private static final String HTML_TEMPLATE = "admin_random_texts.html";
    private static final String HTML_TEMPLATE_ADMIN = "admin_random_texts_file.html";
    private static final long ONE_DAY = 86400000L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminRandomTexts. ";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            new AdminError(req, res, header, msg);
            return;
        }
        File fortune_path = imcref.getConfig().getFortunePath();
        File[] files = fortune_path.listFiles();
        StringBuffer options = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getName();
            int index = filename.lastIndexOf(".");
            if (index != -1) {
                filename = filename.substring(0, index);
            }
            if (filename.endsWith(".current") || filename.endsWith(".stat") || filename.endsWith(".poll")) continue;
            options.append("<option value=\"" + filename + "\">" + filename + "</option>");
        }
        Vector<String> values = new Vector<String>();
        values.add("#options#");
        values.add(options.toString());
        ((Writer)out).write(imcref.getTemplateFromDirectory(HTML_TEMPLATE, user, values, "106"));
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession();
        String whichFile = req.getParameter("AdminFile");
        if (req.getParameter("back") != null) {
            res.sendRedirect("AdminManager");
            return;
        }
        if (whichFile == null || "".equals(whichFile)) {
            res.sendRedirect("AdminRandomTexts");
            return;
        }
        session.setAttribute("file", (Object)whichFile);
        if (req.getParameter("edit") != null) {
            StringBuffer buff = new StringBuffer();
            List lines = imcref.getQuoteList(whichFile + ".txt");
            Iterator iter = lines.iterator();
            int counter = 0;
            SimpleDateFormat dateForm = new SimpleDateFormat("yyMMdd");
            while (iter.hasNext()) {
                Quote quote = (Quote)iter.next();
                DateRange dates = quote.getDateRange();
                buff.append("<option value=\"" + counter++ + "\">" + dateForm.format(dates.getStartDate()) + " " + dateForm.format(new Date(dates.getEndDate().getTime() - 86400000L)) + " " + quote.getText() + "</option>");
            }
            String date1 = "";
            String date2 = "";
            String text = "";
            Vector<String> values = new Vector<String>();
            values.add("#date1#");
            values.add(date1);
            values.add("#date2#");
            values.add(date2);
            values.add("#text#");
            values.add(text);
            values.add("#file#");
            values.add(whichFile);
            values.add("#options#");
            values.add(buff.toString());
            UserDomainObject user = Utility.getLoggedOnUser(req);
            ((Writer)out).write(imcref.getTemplateFromDirectory(HTML_TEMPLATE_ADMIN, user, values, "106"));
            session.setAttribute("lines", (Object)lines);
            return;
        }
    }
}

