/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.fortune.DateRange;
import imcode.util.fortune.Poll;
import imcode.util.fortune.Quote;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AdminQuestionsFile
extends Administrator {
    private static final String ADMIN_TEMPLATE = "admin_questions_file.html";
    private static final String DATE_ERROR = "date_err_msg.frag";
    private static final String TEXT_ERROR = "text_err_msg.frag";
    private static final SimpleDateFormat dateForm = new SimpleDateFormat("yyMMdd");
    private static final long ONE_DAY = 86400000L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession();
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        String whichFile = (String)session.getAttribute("file");
        if (req.getParameter("back") != null || null == whichFile || "".equals(whichFile)) {
            res.sendRedirect("AdminQuestions");
            return;
        }
        UserDomainObject user = Utility.getLoggedOnUser(req);
        ArrayList lines = (ArrayList)session.getAttribute("lines");
        String date1 = "";
        String date2 = "";
        String text = "";
        String errMsgDate = imcref.getTemplateFromDirectory(DATE_ERROR, user, null, "106");
        String errMsgTxt = imcref.getTemplateFromDirectory(TEXT_ERROR, user, null, "106");
        if (req.getParameter("save") != null) {
            this.addLineToList(req, lines);
            imcref.setPollList(whichFile + ".poll.txt", lines);
            List currentPollList = imcref.getPollList(whichFile + ".current.txt");
            if (currentPollList.isEmpty()) {
                currentPollList = this.getNewQuestion(imcref, whichFile);
                imcref.setPollList(whichFile + ".current.txt", currentPollList);
            }
            Poll currentPoll = (Poll)currentPollList.get(0);
            List newPollList = this.getNewQuestion(imcref, whichFile);
            Poll newCurrentPoll = (Poll)newPollList.get(0);
            if (!newCurrentPoll.getQuestion().equals(currentPoll.getQuestion())) {
                imcref.setPollList(whichFile + ".current.txt", newPollList);
                if (!"".equals(currentPoll.getQuestion()) && currentPoll.getTotalAnswerCount() > 0) {
                    List statsList = imcref.getPollList(whichFile + ".stat.txt");
                    statsList.add(currentPoll);
                    imcref.setPollList(whichFile + ".stat.txt", statsList);
                }
            }
            res.sendRedirect("AdminQuestions");
            return;
        }
        if (req.getParameter("add") != null) {
            date1 = req.getParameter("date1").trim();
            date2 = req.getParameter("date2").trim();
            text = req.getParameter("text").trim();
            boolean dateIsOk = true;
            if (!this.checkDate(date1)) {
                date1 = errMsgDate;
                dateIsOk = false;
            }
            if (!this.checkDate(date2)) {
                date2 = errMsgDate;
                dateIsOk = false;
            }
            if (dateIsOk) {
                try {
                    DateRange range = new DateRange(dateForm.parse(date1), new Date(dateForm.parse(date2).getTime() + 86400000L));
                    if (!this.checkDates(req, range)) {
                        date1 = errMsgDate;
                        date2 = errMsgDate;
                        dateIsOk = false;
                    }
                }
                catch (ParseException ignored) {
                    // empty catch block
                }
            }
            boolean textIsOk = true;
            if (text.length() < 1) {
                text = errMsgTxt;
                textIsOk = false;
            }
            if (textIsOk && dateIsOk) {
                this.addLineToList(req, lines);
                date1 = "";
                date2 = "";
                text = "";
            }
        } else if (req.getParameter("edit") != null) {
            String row = req.getParameter("AdminFile");
            if (row != null) {
                this.addLineToList(req, lines);
                int theRow = Integer.parseInt(row);
                Poll poll = (Poll)lines.get(theRow);
                DateRange dates = poll.getDateRange();
                date1 = dateForm.format(dates.getStartDate());
                date2 = dateForm.format(new Date(dates.getEndDate().getTime() - 86400000L));
                text = poll.getQuestion();
                lines.remove(poll);
            } else {
                date1 = req.getParameter("date1").trim();
                date2 = req.getParameter("date2").trim();
                text = req.getParameter("text").trim();
            }
        } else if (req.getParameter("remove") != null) {
            String[] rows = req.getParameterValues("AdminFile");
            try {
                int i;
                HashMap rowMap = new HashMap();
                for (i = 0; i < lines.size(); ++i) {
                    rowMap.put(new Integer(i), lines.get(i));
                }
                for (i = 0; i < rows.length; ++i) {
                    if ("".equals(rows[i])) continue;
                    rowMap.remove(Integer.decode(rows[i]));
                }
                Object[] listIndexes = new Integer[rowMap.size()];
                listIndexes = rowMap.keySet().toArray(listIndexes);
                Arrays.sort(listIndexes);
                lines = new ArrayList(rowMap.size());
                for (int i2 = 0; i2 < listIndexes.length; ++i2) {
                    lines.add(rowMap.get(listIndexes[i2]));
                }
            }
            catch (NullPointerException ignored) {
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        session.setAttribute("lines", (Object)lines);
        StringBuffer buff = this.createOptionList(lines);
        Vector<String> values = new Vector<String>();
        values.add("#date1#");
        values.add(date1);
        values.add("#date2#");
        values.add(date2);
        values.add("#text#");
        values.add(text);
        values.add("#file#");
        values.add(whichFile);
        values.add("#options#");
        values.add(buff.toString());
        String parsed = imcref.getTemplateFromDirectory(ADMIN_TEMPLATE, user, values, "106");
        ((Writer)out).write(parsed);
    }

    private StringBuffer createOptionList(List lines) {
        StringBuffer buff = new StringBuffer();
        int counter = 0;
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            Poll poll = (Poll)iter.next();
            DateRange dates = poll.getDateRange();
            buff.append("<option value=\"" + counter++ + "\">" + dateForm.format(dates.getStartDate()) + " " + dateForm.format(new Date(dates.getEndDate().getTime() - 86400000L)) + " " + poll.getQuestion() + "</option>");
        }
        return buff;
    }

    private void addLineToList(HttpServletRequest req, List lines) {
        String date1 = req.getParameter("date1").trim();
        String date2 = req.getParameter("date2").trim();
        String text = req.getParameter("text").trim();
        if (text.length() > 1) {
            try {
                DateRange range = new DateRange(dateForm.parse(date1), new Date(dateForm.parse(date2).getTime() + 86400000L));
                Poll poll = new Poll(text, range);
                lines.add(poll);
            }
            catch (ParseException ignored) {
                // empty catch block
            }
        }
    }

    private boolean checkDate(String dateStr) {
        try {
            dateForm.parse(dateStr);
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    private boolean checkDates(HttpServletRequest req, DateRange range) {
        HttpSession session = req.getSession();
        List questionList = (List)session.getAttribute("lines");
        Iterator qIterator = questionList.iterator();
        while (qIterator.hasNext()) {
            Poll aPollQuestion = (Poll)qIterator.next();
            if (!range.overlap(aPollQuestion.getDateRange())) continue;
            return false;
        }
        return true;
    }

    private List getNewQuestion(ImcmsServices imcref, String whichFile) {
        List questionList = imcref.getQuoteList(whichFile + ".poll.txt");
        Date date = new Date();
        Iterator qIterator = questionList.iterator();
        while (qIterator.hasNext()) {
            Quote aPollQuestion = (Quote)qIterator.next();
            if (!aPollQuestion.getDateRange().contains(date)) continue;
            String questionString = aPollQuestion.getText();
            LinkedList<Poll> newPollList = new LinkedList<Poll>();
            newPollList.add(new Poll(questionString, aPollQuestion.getDateRange()));
            return newPollList;
        }
        LinkedList<Poll> newPollList = new LinkedList<Poll>();
        DateRange dateRange = new DateRange(new Date(0L), new Date(0L));
        newPollList.add(new Poll("", dateRange));
        return newPollList;
    }
}

