/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.misc;

import imcode.server.HTMLConv;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.SystemData;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.fortune.Quote;
import imcode.util.net.SMTP;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.ProtocolException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Category;

public class PostcardServlet
extends HttpServlet {
    private static final String POSTCARD_MAIL_SENT = "bekraftelse.html";
    private static final String POSTCARD_MAIL_SUBJECT = "mail_subject_postcard.html";
    private static final String POSTCARD_MAIL_ERROR = "mail_error.html";
    private static final String POSTCARD_BOTTOM = "preview_bottom.html";
    private static final String POSTCARD_MAIL_BODY = "mail_body_postcard.html";
    private static final String POSTCARD_SET = "preview.html";
    private static final String HTML_TEMPLATE = "vykort.html";
    private static final String QUOTE_FILE = "citat.txt";
    private static final String POSTCARD_FOLDER = "postcards";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ");
    private static Category log = Category.getInstance((String)PostcardServlet.class.getName());

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (req.getParameter("action") != null) {
            this.sendPostcardMail(req, res);
            return;
        }
        HttpSession session = req.getSession(true);
        String qRow = req.getParameter("qr");
        String metaId = req.getParameter("meta_id");
        String[] pCStuff = new String[]{qRow, metaId};
        session.setAttribute("postCardStuff", (Object)pCStuff);
        req.setAttribute("externalClass", (Object)"QuoteLineCollector");
        req.setAttribute("qFile", (Object)QUOTE_FILE);
        req.setAttribute("qLine", (Object)qRow);
        RequestDispatcher rd = req.getRequestDispatcher("GetDoc");
        rd.forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        File templateLib = this.getExternalTemplateFolder(user);
        String qLine = "1";
        String metaId = "";
        HttpSession session = req.getSession(true);
        String[] pCStuff = (String[])session.getAttribute("postCardStuff");
        if (pCStuff != null) {
            qLine = pCStuff[0];
            metaId = pCStuff[1];
        }
        int qInt = 1;
        try {
            qInt = Integer.parseInt(qLine);
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)(dateFormat.format(new Date()) + "qLine wasn't a number"), (Throwable)nfe);
        }
        ImcmsServices imcref = Imcms.getServices();
        SystemData sysData = imcref.getSystemData();
        List quoteList = imcref.getQuoteList(QUOTE_FILE);
        String qTextToSend = "";
        if (quoteList.size() > qInt && qInt >= 0) {
            qTextToSend = HTMLConv.toHTMLSpecial(((Quote)quoteList.get(qInt)).getText());
        }
        String friendName = req.getParameter("mailText0");
        String friendEmail = req.getParameter("mailTo");
        String senderName = req.getParameter("mailText1");
        String senderMessage = req.getParameter("mailText2");
        String imageNr = req.getParameter("vykort");
        String imageUrl = imcref.sqlQueryStr("select imgurl from images where meta_id = ? and name = ?", new String[]{metaId, imageNr});
        imageUrl = imageUrl == null ? " " : req.getContextPath() + "/images/" + imageUrl;
        Vector<String> vect = new Vector<String>();
        vect.add("#imageUrl#");
        vect.add(imageUrl);
        vect.add("#citat#");
        vect.add(qTextToSend);
        vect.add("#cont1#");
        vect.add(friendName);
        vect.add("#cont3#");
        vect.add(senderName);
        vect.add("#cont4#");
        vect.add(HTMLConv.toHTML(HTMLConv.toHTMLSpecial(senderMessage)));
        String html = imcref.getTemplateFromDirectory(HTML_TEMPLATE, user, vect, "105");
        String pcFileName = (String)session.getAttribute("pcFileName");
        if (pcFileName == null) {
            PostcardCounter count;
            GregorianCalendar cal = new GregorianCalendar();
            Date currentTime = cal.getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd");
            String dateString = formatter.format(currentTime);
            File counterFile = new File(templateLib, "postcardCounter.count");
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(counterFile));
                count = (PostcardCounter)in.readObject();
                in.close();
            }
            catch (Exception e) {
                count = new PostcardCounter();
            }
            count.increment();
            int postcardNr = count.getNumber();
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(counterFile));
                out.writeObject(count);
                out.close();
            }
            catch (IOException ioe) {
                this.log("Obs! Save couter failed.");
                this.log(ioe.getMessage());
                log.debug((Object)(dateFormat.format(new Date()) + "Obs! Save couter failed."), (Throwable)ioe);
            }
            pcFileName = dateString + "_" + postcardNr + ".html";
            session.setAttribute("pcFileName", (Object)pcFileName);
        }
        String bottomString = imcref.getTemplateFromDirectory(POSTCARD_BOTTOM, user, new Vector(), "105");
        File imagePathFile = imcref.getConfig().getImagePath();
        File postcardFolder = new File(imagePathFile.getParent(), POSTCARD_FOLDER);
        File bottomFile = new File(postcardFolder, "bottom.html");
        FileWriter writ = new FileWriter(bottomFile);
        BufferedWriter buff = new BufferedWriter(writ);
        buff.write(bottomString, 0, bottomString.length());
        buff.flush();
        buff.close();
        File postcardFile = new File(postcardFolder, pcFileName);
        BufferedWriter fileW = new BufferedWriter(new FileWriter(postcardFile));
        fileW.write(html, 0, html.length());
        fileW.flush();
        fileW.close();
        Vector<String> vm = new Vector<String>();
        vm.add("#postcard#");
        vm.add(req.getContextPath() + "/postcards/" + pcFileName + "?" + Math.random());
        vm.add("#bottom#");
        vm.add(req.getContextPath() + "/postcards/bottom.html");
        String frameSetHtml = imcref.getTemplateFromDirectory(POSTCARD_SET, user, vm, "105");
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        out.println(frameSetHtml);
        String[] mailArr = new String[4];
        mailArr[0] = sysData.getWebMasterAddress();
        mailArr[1] = friendEmail;
        vect.add("#mailSubject#");
        vect.add(senderName);
        mailArr[2] = imcref.getTemplateFromDirectory(POSTCARD_MAIL_SUBJECT, user, vect, "105");
        vect.add("#mailText0#");
        vect.add(friendName);
        vect.add("#mailText1#");
        vect.add(senderName);
        vect.add("#mailText2#");
        String host = req.getHeader("Host");
        vect.add("http://" + host);
        vect.add("#mailText3#");
        vect.add(pcFileName);
        mailArr[3] = imcref.getTemplateFromDirectory(POSTCARD_MAIL_BODY, user, vect, "105");
        session.setAttribute("postcardMail", (Object)mailArr);
    }

    private File getExternalTemplateFolder(UserDomainObject user) {
        ImcmsServices imcref = Imcms.getServices();
        String langPrefix = user != null ? user.getLanguageIso639_2() : imcref.getDefaultLanguage();
        File templateLib = new File(imcref.getTemplatePath(), langPrefix);
        templateLib = new File(templateLib, "105");
        return templateLib;
    }

    private void sendPostcardMail(HttpServletRequest req, HttpServletResponse res) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession(false);
        if (session == null) {
            res.sendRedirect(req.getContextPath() + "/servlet/StartDoc");
        }
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        String[] mailNfo = (String[])session.getAttribute("postcardMail");
        session.removeAttribute("postcardMail");
        session.removeAttribute("pcFileName");
        UserDomainObject user = Utility.getLoggedOnUser(req);
        try {
            SMTP smtp = imcref.getSMTP();
            smtp.sendMail(new SMTP.Mail(mailNfo[0], new String[]{mailNfo[1]}, mailNfo[2], mailNfo[3]));
        }
        catch (ProtocolException ex) {
            out.println(imcref.getTemplateFromDirectory(POSTCARD_MAIL_ERROR, user, new Vector(), "105"));
            this.log("Protocol error while sending mail. " + ex.getMessage());
            return;
        }
        catch (IOException ex) {
            out.println(imcref.getTemplateFromDirectory(POSTCARD_MAIL_ERROR, user, new Vector(), "105"));
            this.log("The mailservlet probably timed out. " + ex.getMessage());
            return;
        }
        out.println(imcref.getTemplateFromDirectory(POSTCARD_MAIL_SENT, user, new Vector(), "105"));
    }

    class PostcardCounter
    implements Serializable {
        private int _count = 0;

        private PostcardCounter() {
        }

        private int getNumber() {
            return this._count;
        }

        private void increment() {
            ++this._count;
        }
    }
}

