/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.Conference;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.ParsedTextFile;
import imcode.external.diverse.VariableManager;
import imcode.server.HTMLConv;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ConfReply
extends Conference {
    private static final String NEW_COMMENT_TEMPLATE = "conf_reply_new_comment.htm";
    private static final String ADMIN_LINK_TEMPLATE = "conf_reply_admin_link.htm";
    private static final String HTML_TEMPLATE = "conf_reply.htm";
    private static final String RECS_HTML = "conf_reply_list.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Properties params = this.getParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        if (req.getParameter("UPDATE") != null) {
            String userId = "" + user.getId();
            HttpSession session = req.getSession(false);
            if (session != null) {
                userId = (String)session.getAttribute("Conference.user_id");
            }
            String metaId = params.getProperty("META_ID");
            String ascSortOrder = req.getParameter("SORT_ORDER") == null ? "0" : req.getParameter("SORT_ORDER");
            Imcms.getServices().sqlUpdateProcedure("A_ConfUsersSetReplyOrder", new String[]{metaId, userId, ascSortOrder});
            this.doGet(req, res);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Properties params = this.getParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        String discId = params.getProperty("DISC_ID");
        String userId = "";
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.setAttribute("Conference.disc_id", (Object)discId);
            userId = (String)session.getAttribute("Conference.user_id");
        }
        ImcmsServices imcref = Imcms.getServices();
        String[][] sqlAnswer = imcref.sqlProcedureMulti("A_GetAllRepliesInDisc", new String[]{discId, userId});
        String discHeader = imcref.sqlProcedureStr("A_GetDiscussionHeader", new String[]{discId});
        if (discHeader == null || discId.equalsIgnoreCase("-1")) {
            discHeader = " ";
        }
        String metaId = params.getProperty("META_ID");
        int intMetaId = Integer.parseInt(metaId);
        String sortOrderValue = imcref.sqlProcedureStr("A_ConfUsersGetReplyOrderSel", new String[]{metaId, userId});
        String ascState = "";
        String descState = "";
        String ascVal = "0";
        if (sortOrderValue.equalsIgnoreCase("1")) {
            ascState = "checked";
        } else {
            descState = "checked";
        }
        Vector<String> tagsV = new Vector<String>();
        tagsV.add("#REPLY_DATE#");
        tagsV.add("#FIRST_NAME#");
        tagsV.add("#LAST_NAME#");
        tagsV.add("#REPLY_HEADER#");
        tagsV.add("#REPLY_TEXT#");
        tagsV.add("#REPLY_LEVEL#");
        String imagePath = super.getExternalImageFolder(req) + "ConfExpert.gif";
        File templateLib = super.getExternalTemplateFolder(req);
        File aSnippetFile = new File(templateLib, RECS_HTML);
        this.updateDiscFlagList(req, discId);
        String allRecs = " ";
        if (sqlAnswer != null) {
            allRecs = this.preParse(sqlAnswer, tagsV, aSnippetFile, imagePath);
        }
        String commentButton = "&nbsp;";
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(intMetaId);
        if (user.canAccess(document) && imcref.checkDocAdminRights(intMetaId, user)) {
            VariableManager vmButtons = new VariableManager();
            vmButtons.addProperty("#SERVLET_URL#", "");
            vmButtons.addProperty("#IMAGE_URL#", this.getExternalImageFolder(req));
            commentButton = this.getTemplate(NEW_COMMENT_TEMPLATE, user, vmButtons.getTagsAndData());
        }
        VariableManager vm = new VariableManager();
        vm.addProperty("NEW_COMMENT", commentButton);
        vm.addProperty("USER_SORT_ORDER", ascVal);
        vm.addProperty("CHECKBOX_STATE_ASC", ascState);
        vm.addProperty("CHECKBOX_STATE_DESC", descState);
        vm.addProperty("REPLIES_RECORDS", allRecs);
        vm.addProperty("CURRENT_DISCUSSION_HEADER", discHeader);
        vm.addProperty("ADMIN_LINK_HTML", ADMIN_LINK_TEMPLATE);
        this.sendHtml(req, res, vm, HTML_TEMPLATE);
    }

    private void updateDiscFlagList(HttpServletRequest req, String discId) {
        HttpSession session = req.getSession(true);
        Properties viewedDiscs = (Properties)session.getAttribute("Conference.viewedDiscList");
        if (viewedDiscs == null) {
            this.log("ViewedDiscs == null");
            viewedDiscs = new Properties();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(new Date());
        if (discId == null || dateString == null) {
            this.log("Error i updateDiscFlagList");
            this.log("discId: " + discId);
            this.log("dateString: " + dateString);
            discId = "" + discId;
            dateString = "" + dateString;
        }
        viewedDiscs.setProperty(discId, dateString);
        session.setAttribute("Conference.viewedDiscList", (Object)viewedDiscs);
    }

    private String preParse(String[][] DBArr, Vector tagsV, File htmlCodeFile, String imagePath) throws IOException {
        String htmlStr = "";
        for (int i = 0; i < DBArr.length; ++i) {
            Vector dataV = new Vector();
            for (int j = 0; j < DBArr[i].length; ++j) {
                String s = HTMLConv.toHTMLSpecial(DBArr[i][j]);
                dataV.add(s);
            }
            dataV = ConfReply.getReplyLevelCode(dataV, imagePath);
            htmlStr = htmlStr + this.parseOneRecord(tagsV, dataV, htmlCodeFile);
        }
        return htmlStr;
    }

    String parseOneRecord(Vector tagsV, Vector dataV, File htmlCodeFile) throws IOException {
        ParsedTextFile parser = new ParsedTextFile(htmlCodeFile, tagsV, dataV);
        String oneRecordsHtmlCode = parser.toString();
        return oneRecordsHtmlCode;
    }

    private static Vector getReplyLevelCode(Vector dataV, String ImagePath) {
        int index = 5;
        String replyLevel = (String)dataV.elementAt(index);
        String imageStart = "<img src=\"";
        String imageEnd = "\">";
        String htmlCode = replyLevel.equals("1") ? imageStart + ImagePath + imageEnd : "";
        dataV.insertElementAt(htmlCode, index);
        return dataV;
    }

    private Properties getParameters(HttpServletRequest req) {
        HttpSession session;
        String confDiscId;
        Properties reqParams = MetaInfo.createPropertiesFromMetaInfoParameters(super.getConferenceSessionParameters(req));
        String string = confDiscId = req.getParameter("disc_id") == null ? "" : req.getParameter("disc_id");
        if (confDiscId.equals("") && (session = req.getSession(false)) != null) {
            confDiscId = (String)session.getAttribute("Conference.disc_id");
        }
        reqParams.setProperty("DISC_ID", confDiscId);
        return reqParams;
    }
}

