/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.ConfError;
import com.imcode.imcms.servlet.conference.Conference;
import imcode.external.diverse.MetaInfo;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ConfManager
extends Conference {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MetaInfo.Parameters params = MetaInfo.getParameters(req);
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        int testMetaId = params.getMetaId();
        if (!this.isUserAuthorized(res, testMetaId, user, req)) {
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            String header = "ConfManager servlet. ";
            ConfError err = new ConfError(req, res, header, 3, user);
            this.log(header + err.getErrorMsg());
            return;
        }
        if (action.equalsIgnoreCase("NEW")) {
            this.log("Lets add a conference");
            HttpSession session = req.getSession(false);
            if (session != null) {
                this.setSessionAttributes(session, params);
            }
            String url = "ConfCreator?action=NEW";
            res.sendRedirect(url);
            return;
        }
        if (action.equalsIgnoreCase("VIEW")) {
            String loginType = user.getLoginType();
            boolean foundUserInConf = this.userIsMemberOfConference(params.getMetaId(), user.getId(), imcref);
            if (!loginType.equalsIgnoreCase("VERIFY") || !foundUserInConf) {
                HttpSession session = req.getSession(false);
                if (session != null) {
                    this.setSessionAttributes(session, params);
                    session.setAttribute("Conference.viewedDiscList", (Object)new Properties());
                    this.log("OK, nu s\u00e4tter vi viewedDiscList");
                }
                String loginPage = "ConfLogin?login_type=login";
                res.sendRedirect(loginPage);
                return;
            }
            this.log("Ok, anv\u00e4ndaren har loggat in, f\u00f6rbered honom f\u00f6r konferensen");
            if (!super.prepareUserForConf(req, res, params, user)) {
                this.log("Error in prepareUserFor Conf");
            }
            return;
        }
        if (action.equalsIgnoreCase("CHANGE")) {
            String url = "ChangeExternalDoc2?" + MetaInfo.passMeta(params) + "&metadata=meta";
            res.sendRedirect(url);
            return;
        }
    }

    public void log(String str) {
        super.log(str);
        System.out.println("ConfManager: " + str);
    }
}

