/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.ConfError;
import com.imcode.imcms.servlet.conference.Conference;
import com.imcode.imcms.servlet.superadmin.AdminError2;
import com.imcode.imcms.servlet.superadmin.AdminUserProps;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Utility;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfLogin
extends Conference {
    private static final String USER_UNADMIN_LINK_TEMPLATE = "conf_user_unadmin_link.htm";
    private String LOGIN_HTML = "conf_login.htm";
    private String CREATE_HTML = "conf_add_user.htm";
    private String LOGIN_ERROR_HTML = "conf_login_error.htm";
    private String ADMIN1_HTML = "conf_admin_user.htm";
    private String ADMIN2_HTML = "conf_admin_user_resp.htm";
    private String ADD_USER_OK_HTML = "conf_login_add_ok.htm";
    private String USER_SELFREG_FRAG = "conf_new_user_selfreg_frag.htm";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        UserDomainObject user;
        MetaInfo.Parameters params = super.getConferenceSessionParameters(req);
        int testMetaId = params.getMetaId();
        if (!this.isUserAuthorized(res, testMetaId, user = Utility.getLoggedOnUser(req), req)) {
            return;
        }
        String loginType = req.getParameter("login_type") == null ? "" : req.getParameter("login_type");
        ImcmsServices imcref = Imcms.getServices();
        if (loginType.equalsIgnoreCase("ADD_USER")) {
            VariableManager vm = new VariableManager();
            Vector userInfoV = new Vector(20);
            vm = this.addUserInfo(vm, userInfoV);
            vm.addProperty("SERVLET_URL", "");
            this.sendHtml(req, res, vm, this.CREATE_HTML);
            return;
        }
        if (loginType.equalsIgnoreCase("ADMIN_USER")) {
            if (!super.userHasAdminRights(imcref, Integer.parseInt("" + params.getMetaId()), user)) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 6, user);
                return;
            }
            String[] usersArr = imcref.sqlProcedure("A_GetAllConfUsersInList", new String[]{"" + params.getMetaId()});
            Vector usersV = super.convert2Vector(usersArr);
            VariableManager vm = new VariableManager();
            String usersOption = Html.createOptionList("", (List)usersV);
            vm.addProperty("USERS_MENU", usersOption);
            vm.addProperty("UNADMIN_LINK_HTML", USER_UNADMIN_LINK_TEMPLATE);
            this.sendHtml(req, res, vm, this.ADMIN1_HTML);
            return;
        }
        VariableManager vm = new VariableManager();
        vm.addProperty("SERVLET_URL", "");
        vm.addProperty("#IMAGE_URL#", this.getExternalImageFolder(req));
        String userSelfRegHtmlfrag = this.getTemplate(this.USER_SELFREG_FRAG, user, null);
        if (this.getAllSelfregRolesId(testMetaId + "", imcref) != null && this.getAllSelfregRolesId(testMetaId + "", imcref).length > 0) {
            vm.addProperty("USER-SELFREG", userSelfRegHtmlfrag);
        } else {
            vm.addProperty("USER-SELFREG", "");
        }
        this.sendHtml(req, res, vm, this.LOGIN_HTML);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        UserDomainObject user;
        MetaInfo.Parameters params = super.getConferenceSessionParameters(req);
        int testMetaId = params.getMetaId();
        if (!this.isUserAuthorized(res, testMetaId, user = Utility.getLoggedOnUser(req), req)) {
            return;
        }
        String loginType = req.getParameter("login_type") == null ? "" : req.getParameter("login_type");
        ImcmsServices imcref = Imcms.getServices();
        ImcmsAuthenticatorAndUserAndRoleMapper userMapperAndRole = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
        if (loginType.equalsIgnoreCase("login")) {
            String password;
            Properties lparams = this.getLoginParams(req);
            String userName = (lparams = super.verifyForSql(lparams)).getProperty("LOGIN_NAME");
            String userId = imcref.sqlProcedureStr("GetUserIdFromName", new String[]{userName, password = lparams.getProperty("PASSWORD")});
            if (userId == null) {
                String header = "ConfLogin servlet.";
                ConfError err = new ConfError(req, res, header, 50, this.LOGIN_ERROR_HTML, user);
                this.log(header + err.getErrorMsg());
                return;
            }
            user = userMapperAndRole.getUser(Integer.parseInt(userId));
            boolean foundUserInConf = this.userIsMemberOfConference(params.getMetaId(), user.getId(), imcref);
            boolean okToLogIn = false;
            if (!foundUserInConf) {
                this.log("Ok, the user is not a member here, lets find out if he could be");
                DocumentMapper documentMapper = imcref.getDocumentMapper();
                DocumentDomainObject document = documentMapper.getDocument(params.getMetaId());
                this.addAllConferenceSelfRegRolesToUser(user, params.getMetaId() + "", imcref);
                user = userMapperAndRole.getUser(Integer.parseInt(user.getId() + ""));
                okToLogIn = user.canEdit(document);
                if (okToLogIn) {
                    this.addUserToOneConference(user, document.getId() + "", imcref);
                }
                this.log("Ok, let the user in and let him be a member: " + okToLogIn);
            }
            if (!foundUserInConf && !okToLogIn) {
                String header = "ConfLogin servlet.";
                ConfError err = new ConfError(req, res, header, 50, this.LOGIN_ERROR_HTML, user);
                this.log(header + err.getErrorMsg() + "\n the user exists, but is not a member in this conference");
                return;
            }
            Utility.makeUserLoggedIn(req, user);
            user.setLoginType("verify");
            this.log("Ok, nu f\u00f6rbereder vi anv\u00e4ndaren p\u00e5 att logga in");
            if (!super.prepareUserForConf(req, res, params, user)) {
                this.log("Error in prepareUserFor Conf");
            }
            return;
        }
        if (loginType.equalsIgnoreCase("ADD_USER")) {
            Properties userParams = this.getNewUserParameters(req);
            if (!this.checkUserParameters(userParams)) {
                String header = "ConfLogin servlet.";
                ConfError err = new ConfError(req, res, header, 51, this.LOGIN_ERROR_HTML, user);
                this.log(header + err.getErrorMsg());
                return;
            }
            if (!AdminUserProps.verifyPassword(userParams.getProperty("password1"), userParams.getProperty("password2"), req, res)) {
                return;
            }
            boolean result = true;
            try {
                Integer.parseInt(userParams.getProperty("phone").replaceAll("[\\- ]", ""));
            }
            catch (NumberFormatException e) {
                new AdminError2(req, res, "", 63);
                result = false;
            }
            catch (NullPointerException e) {
                new AdminError2(req, res, "", 63);
                result = false;
            }
            if (!result) {
                return;
            }
            String userName = (userParams = super.verifyForSql(userParams)).getProperty("login_name");
            String[] userNameExists = imcref.sqlProcedure("FindUserName", new String[]{userName});
            if (userNameExists != null && userNameExists.length > 0) {
                String header = "ConfLogin servlet.";
                new ConfError(req, res, header, 56, this.LOGIN_ERROR_HTML, user);
                return;
            }
            UserDomainObject newUser = new UserDomainObject();
            newUser.setLoginName(userParams.getProperty("login_name"));
            newUser.setPassword(userParams.getProperty("password1"));
            newUser.setFirstName(userParams.getProperty("first_name"));
            newUser.setLastName(userParams.getProperty("last_name"));
            newUser.setTitle(userParams.getProperty("title"));
            newUser.setCompany(userParams.getProperty("company"));
            newUser.setAddress(userParams.getProperty("address"));
            newUser.setCity(userParams.getProperty("city"));
            newUser.setZip(userParams.getProperty("zip"));
            newUser.setCountry(userParams.getProperty("country"));
            newUser.setCountyCouncil(userParams.getProperty("country_council"));
            newUser.setEmailAddress(userParams.getProperty("email"));
            newUser.setActive(true);
            newUser.setWorkPhone(userParams.getProperty("phone"));
            ImcmsAuthenticatorAndUserAndRoleMapper userMapper = imcref.getImcmsAuthenticatorAndUserAndRoleMapper();
            userMapper.addUser(newUser, user);
            String[] usersRoles = imcref.sqlProcedure("GetUserRolesIDs", new String[]{"" + user.getId()});
            if (usersRoles != null) {
                for (int i = 0; i < usersRoles.length; i += 2) {
                    if (usersRoles[i].toString().equals("1")) continue;
                    imcref.sqlUpdateProcedure("AddUserRole", new String[]{newUser.getId() + "", usersRoles[i].toString()});
                }
            } else {
                String header = "ConfLogin servlet.";
                ConfError err = new ConfError(req, res, header, 58, user);
                this.log(header + err.getErrorMsg());
                return;
            }
            this.addAllConferenceSelfRegRolesToUser(newUser, params.getMetaId() + "", imcref);
            int metaId = params.getMetaId();
            String fName = userParams.getProperty("first_name");
            String lName = userParams.getProperty("last_name");
            this.addUserToOneConference(newUser, metaId + "", imcref);
            String header = "ConfLogin servlet.";
            new ConfError(req, res, header, 55, this.ADD_USER_OK_HTML, user);
            return;
        }
        if (req.getParameter("CHANGE_USER") != null) {
            if (!super.userHasAdminRights(imcref, Integer.parseInt("" + params.getMetaId()), user)) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 6, user);
                return;
            }
            String userId = this.getCurrentUserId(req, res, user);
            if (userId == null) {
                return;
            }
            String[] userInfo = imcref.sqlQuery("SELECT user_id,\nlogin_name,\nlogin_password,\nfirst_name,\nlast_name,\ntitle,\ncompany,\naddress,\ncity,\nzip,\ncountry,\ncounty_council,\nemail,\nexternal,\nactive,\ncreate_date,\nlanguage\nFROM users\nWHERE user_id = @aUserId", new String[]{userId});
            String level = imcref.sqlProcedureStr("A_ConfUsersGetUserLevel", new String[]{"" + params.getMetaId(), userId});
            String levelStatus = "";
            if (level.equalsIgnoreCase("1")) {
                levelStatus = "checked";
            }
            level = "EXPERT";
            Vector userV = this.convert2Vector(userInfo);
            VariableManager vm = new VariableManager();
            vm = this.addUserInfo(vm, userV);
            vm.addProperty("USER_LEVEL", level);
            vm.addProperty("USER_LEVEL_STATUS", levelStatus);
            vm.addProperty("CURR_USER_ID", userId);
            this.sendHtml(req, res, vm, this.ADMIN2_HTML);
            return;
        }
        if (req.getParameter("SAVE_USER") != null) {
            if (!super.userHasAdminRights(imcref, Integer.parseInt("" + params.getMetaId()), user)) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 6, user);
                return;
            }
            String userLevel = req.getParameter("user_level");
            if (userLevel == null) {
                userLevel = "NORMAL";
            }
            userLevel = userLevel.equalsIgnoreCase("NORMAL") ? "0" : "1";
            String userId = this.getCurrentUserId(req, res, user);
            if (userId == null) {
                return;
            }
            imcref.sqlUpdateProcedure("A_ConfUsersSetUserLevel", new String[]{"" + params.getMetaId(), userId, userLevel});
            String url = "ConfLogin?login_type=admin_user";
            res.sendRedirect(url);
            return;
        }
        if (loginType.equalsIgnoreCase("GoBack")) {
            String url = "ConfLogin?login_type=admin_user";
            res.sendRedirect(url);
            return;
        }
    }

    private Properties getNewUserParameters(HttpServletRequest req) {
        String active;
        Properties userInfo = new Properties();
        String login_name = req.getParameter("login_name") == null ? "" : req.getParameter("login_name");
        String password1 = req.getParameter("password1") == null ? "" : req.getParameter("password1");
        String password2 = req.getParameter("password2") == null ? "" : req.getParameter("password2");
        String first_name = req.getParameter("first_name") == null ? "" : req.getParameter("first_name");
        String last_name = req.getParameter("last_name") == null ? "" : req.getParameter("last_name");
        String title = req.getParameter("title") == null ? "" : req.getParameter("title");
        String company = req.getParameter("company") == null ? "" : req.getParameter("company");
        String address = req.getParameter("address") == null ? "" : req.getParameter("address");
        String city = req.getParameter("city") == null ? "" : req.getParameter("city");
        String zip = req.getParameter("zip") == null ? "" : req.getParameter("zip");
        String country = req.getParameter("country") == null ? "" : req.getParameter("country");
        String country_council = req.getParameter("country_council") == null ? "" : req.getParameter("country_council");
        String email = req.getParameter("email") == null ? "" : req.getParameter("email");
        String phone = req.getParameter("phone") == null ? "" : req.getParameter("phone");
        String string = active = req.getParameter("active") == null ? "1" : req.getParameter("active");
        if (title.trim().equals("")) {
            title = "--";
        }
        if (company.trim().equals("")) {
            company = "--";
        }
        if (address.trim().equals("")) {
            address = "--";
        }
        if (city.trim().equals("")) {
            city = "--";
        }
        if (zip.trim().equals("")) {
            zip = "--";
        }
        if (country.trim().equals("")) {
            country = "--";
        }
        if (country_council.trim().equals("")) {
            country_council = "--";
        }
        if (email.trim().equals("")) {
            email = "--";
        }
        userInfo.setProperty("login_name", login_name.trim());
        userInfo.setProperty("password1", password1.trim());
        userInfo.setProperty("password2", password2.trim());
        userInfo.setProperty("first_name", first_name.trim());
        userInfo.setProperty("last_name", last_name.trim());
        userInfo.setProperty("title", title.trim());
        userInfo.setProperty("company", company.trim());
        userInfo.setProperty("address", address.trim());
        userInfo.setProperty("city", city.trim());
        userInfo.setProperty("zip", zip.trim());
        userInfo.setProperty("country", country.trim());
        userInfo.setProperty("country_council", country_council.trim());
        userInfo.setProperty("email", email.trim());
        userInfo.setProperty("phone", phone.trim());
        userInfo.setProperty("active", active.trim());
        return userInfo;
    }

    private boolean checkUserParameters(Properties aPropObj) {
        return !aPropObj.values().contains("");
    }

    private Properties getLoginParams(HttpServletRequest req) {
        Properties login = new Properties();
        String login_name = req.getParameter("login_name") == null ? "" : req.getParameter("login_name");
        String password1 = req.getParameter("password") == null ? "" : req.getParameter("password");
        login.setProperty("LOGIN_NAME", login_name.trim());
        login.setProperty("PASSWORD", password1.trim());
        return login;
    }

    public void log(String str) {
        super.log(str);
        System.out.println("ConfLogin: " + str);
    }

    private VariableManager addUserInfo(VariableManager vm, Vector v) {
        vm.addProperty("LOGIN_NAME", v.get(1).toString());
        vm.addProperty("PWD1", v.get(2).toString());
        vm.addProperty("PWD2", v.get(2).toString());
        vm.addProperty("FIRST_NAME", v.get(3).toString());
        vm.addProperty("LAST_NAME", v.get(4).toString());
        vm.addProperty("TITLE", v.get(5).toString());
        vm.addProperty("COMPANY", v.get(6).toString());
        vm.addProperty("ADDRESS", v.get(7).toString());
        vm.addProperty("CITY", v.get(8).toString());
        vm.addProperty("ZIP", v.get(9).toString());
        vm.addProperty("COUNTRY", v.get(10).toString());
        vm.addProperty("COUNTRY_COUNCIL", v.get(11).toString());
        vm.addProperty("EMAIL", v.get(12).toString());
        return vm;
    }

    private String getCurrentUserId(HttpServletRequest req, HttpServletResponse res, UserDomainObject user) throws IOException {
        String userId = req.getParameter("user_id");
        if (userId == null) {
            String header = "ConfLogin servlet.";
            ConfError err = new ConfError(req, res, header, 59, this.LOGIN_ERROR_HTML, user);
            this.log(err.getErrorString());
            return null;
        }
        return userId;
    }
}

