/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.billboard;

import com.imcode.imcms.servlet.billboard.BillBoard;
import com.imcode.imcms.servlet.billboard.BillBoardError;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.VariableManager;
import imcode.server.HTMLConv;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.net.SMTP;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BillBoardAdd
extends BillBoard {
    private static final String HTML_TEMPLATE = "billboard_add.htm";
    private static final String SERVLET_NAME = "BillBoardAdd";
    private static final String sectionId = "sectionId";
    private static final String header = "header";
    private static final String text = "text";
    private static final String email = "email";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int metaId;
        Properties params = this.getParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        String addType = "";
        addType = req.getParameter("ADDTYPE");
        ImcmsServices imcref = Imcms.getServices();
        if (this.userHasRightToEdit(imcref, metaId = Integer.parseInt(params.getProperty("META_ID")), user)) {
            if (req.getParameter("CANCEL") != null || req.getParameter("CANCEL.x") != null) {
                if (req.getParameter("DISCPREV") != null) {
                    String addTypStr = "&ADDTYPE=" + req.getParameter("ADDTYPE");
                    res.sendRedirect("BillBoardDiscView?DISCPREV=ok" + addTypStr);
                } else {
                    res.sendRedirect("BillBoardDiscView");
                }
                return;
            }
            if (req.getParameter("PREVIEW") != null || req.getParameter("PREVIEW.x") != null) {
                String aSectionId = params.getProperty("SECTION_ID");
                HttpSession session = req.getSession(false);
                if (session == null) {
                    res.sendRedirect("StartDoc");
                    return;
                }
                String addHeader = params.getProperty("ADD_HEADER").trim();
                String addText = params.getProperty("ADD_TEXT").trim();
                String addEpost = params.getProperty("ADD_EPOST").trim();
                if (addHeader.equals("") || addText.equals("") || addEpost.equals("")) {
                    this.log("some fields was empty");
                    new BillBoardError(req, res, 51, user);
                    return;
                }
                addText = super.verifySqlText(this.textMailLinkFix(addText));
                addHeader = super.verifySqlText(HTMLConv.toHTMLSpecial(addHeader));
                if (!this.validateEmail(addEpost = super.verifySqlText(HTMLConv.toHTMLSpecial(addEpost)))) {
                    this.log("invalid epostadress");
                    String header = "BillBoardAdd servlet. ";
                    new BillBoardError(req, res, header, 76, user.getLanguageIso639_2(), user);
                    return;
                }
                if (addText.length() > 32000) {
                    String header = "BillBoardAdd servlet. ";
                    new BillBoardError(req, res, header, 75, user.getLanguageIso639_2(), user);
                    return;
                }
                if (session != null) {
                    Hashtable<String, String> billPrevData = new Hashtable<String, String>();
                    billPrevData.put(sectionId, aSectionId);
                    billPrevData.put(header, addHeader);
                    billPrevData.put(text, addText);
                    billPrevData.put(email, addEpost);
                    session.setAttribute("billPrevData", billPrevData);
                } else {
                    res.sendRedirect("StartDoc");
                }
                String addTypeStr = "&ADDTYPE=" + req.getParameter("ADDTYPE");
                res.sendRedirect("BillBoardDiscView?PREVIEWMODE=OK" + addTypeStr);
                return;
            }
            if (addType.equalsIgnoreCase("DISCUSSION") && (req.getParameter("ADD") != null || req.getParameter("ADD.x") != null)) {
                String addEpost;
                String addText;
                String addHeader;
                String aSectionId;
                String userId = "";
                HttpSession session = req.getSession(false);
                if (session == null) {
                    res.sendRedirect("StartDoc");
                    return;
                }
                userId = (String)session.getAttribute("BillBoard.user_id");
                Hashtable billPrevData = (Hashtable)session.getAttribute("billPrevData");
                if (billPrevData != null) {
                    session.removeAttribute("billPrevData");
                    aSectionId = (String)billPrevData.get(sectionId);
                    addHeader = (String)billPrevData.get(header);
                    addText = (String)billPrevData.get(text);
                    addEpost = (String)billPrevData.get(email);
                } else {
                    aSectionId = params.getProperty("SECTION_ID");
                    addHeader = params.getProperty("ADD_HEADER").trim();
                    addText = params.getProperty("ADD_TEXT").trim();
                    addEpost = params.getProperty("ADD_EPOST").trim();
                    if (addHeader.equals("") || addText.equals("") || addEpost.equals("")) {
                        this.log("some fields was empty");
                        new BillBoardError(req, res, 51, user);
                        return;
                    }
                    addText = super.verifySqlText(this.textMailLinkFix(addText));
                    addHeader = super.verifySqlText(HTMLConv.toHTMLSpecial(addHeader));
                    if (!this.validateEmail(addEpost = super.verifySqlText(HTMLConv.toHTMLSpecial(addEpost)))) {
                        this.log("invalid epostadress");
                        String header = "BillBoardAdd servlet. ";
                        new BillBoardError(req, res, header, 76, user.getLanguageIso639_2(), user);
                        return;
                    }
                    if (addText.length() > 32000) {
                        String header = "BillBoardAdd servlet. ";
                        new BillBoardError(req, res, header, 75, user.getLanguageIso639_2(), user);
                        return;
                    }
                }
                String sqlQuest = "B_AddNewBill";
                imcref.sqlUpdateProcedure(sqlQuest, new String[]{aSectionId, userId, addHeader, addText, addEpost, req.getRemoteAddr()});
                if (session != null) {
                    String latestDiscId = imcref.sqlProcedureStr("B_GetLastDiscussionId", new String[]{params.getProperty("META_ID"), aSectionId});
                    session.setAttribute("BillBoard.disc_id", (Object)latestDiscId);
                }
                res.sendRedirect("BillBoardDiscView");
                return;
            }
            if (addType.equalsIgnoreCase("REPLY") && (req.getParameter("ADD") != null || req.getParameter("ADD.x") != null)) {
                String addEpost;
                String addText;
                String addHeader;
                Hashtable billPrevData;
                String discId = params.getProperty("DISC_ID");
                String userId = "";
                HttpSession session = req.getSession(false);
                if (session != null) {
                    userId = (String)session.getAttribute("BillBoard.user_id");
                }
                if ((billPrevData = (Hashtable)session.getAttribute("billPrevData")) != null) {
                    session.removeAttribute("billPrevData");
                    addHeader = (String)billPrevData.get(header);
                    addText = (String)billPrevData.get(text);
                    addEpost = (String)billPrevData.get(email);
                } else {
                    addHeader = params.getProperty("ADD_HEADER").trim();
                    addText = params.getProperty("ADD_TEXT").trim();
                    addEpost = params.getProperty("ADD_EPOST").trim();
                    if (addHeader.equals("") || addText.equals("") || addEpost.equals("")) {
                        new BillBoardError(req, res, 51, user);
                        return;
                    }
                    addHeader = super.verifySqlText(HTMLConv.toHTMLSpecial(addHeader));
                    addText = super.verifySqlText(this.textMailLinkFix(addText));
                    addEpost = super.verifySqlText(HTMLConv.toHTMLSpecial(addEpost));
                    if (addText.length() > 32000) {
                        String header = "BillBoardAdd servlet. ";
                        new BillBoardError(req, res, header, 74, user.getLanguageIso639_2(), user);
                        return;
                    }
                }
                String toEmail = imcref.sqlProcedureStr("B_GetEmail", new String[]{discId});
                if (toEmail == null) {
                    this.log("OBS! No fn email found!");
                    return;
                }
                String sqlQuest = "B_GetSubjectStr";
                String subjectStr = imcref.sqlProcedureStr(sqlQuest, new String[]{discId, params.getProperty("META_ID"), params.getProperty("SECTION_ID")});
                try {
                    this.sendReplieEmail(toEmail, addEpost, subjectStr, addText, addHeader);
                }
                catch (ProtocolException pe) {
                    new BillBoardError(req, res, "BillBoardAdd servlet. ", 76, user.getLanguageIso639_2(), user);
                    this.log(pe.getMessage());
                    return;
                }
                imcref.sqlUpdateProcedure("B_AddReply", new String[]{discId, userId, addHeader, addText, addEpost, req.getRemoteAddr()});
                res.sendRedirect("BillBoardDiscView?MAIL_SENT=OK");
                return;
            }
        } else {
            String header = "BillBoardAdd servlet. ";
            new BillBoardError(req, res, header, 100, user.getLanguageIso639_2(), user);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int metaId;
        Properties params = this.getParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        if (this.userHasRightToEdit(imcref, metaId = Integer.parseInt(params.getProperty("META_ID")), user)) {
            Hashtable billPrevData;
            HttpSession session = req.getSession(false);
            VariableManager vm = new VariableManager();
            vm.addProperty("ADD_TYPE", params.getProperty("ADD_TYPE"));
            String currSection = imcref.sqlProcedureStr("B_GetSectionName", new String[]{params.getProperty("SECTION_ID")});
            vm.addProperty("CURRENT_SECTION_NAME", currSection);
            String htmlTemplate = HTML_TEMPLATE;
            if (params.getProperty("ADD_TYPE").equalsIgnoreCase("REPLY")) {
                htmlTemplate = "billboard_add_reply.htm";
            }
            if ((billPrevData = (Hashtable)session.getAttribute("billPrevData")) == null) {
                vm.addProperty(header, "");
                vm.addProperty(text, "");
                vm.addProperty(email, "");
            } else {
                session.removeAttribute("billPrevData");
                vm.addProperty(header, (String)billPrevData.get(header));
                vm.addProperty(text, (String)billPrevData.get(text));
                vm.addProperty(email, (String)billPrevData.get(email));
            }
            this.sendHtml(req, res, vm, htmlTemplate);
            return;
        }
        String header = "BillBoardAdd servlet. ";
        new BillBoardError(req, res, header, 100, user.getLanguageIso639_2(), user);
    }

    private Properties getParameters(HttpServletRequest req) {
        String addEpost;
        Properties params = MetaInfo.createPropertiesFromMetaInfoParameters(super.getBillBoardSessionParameters(req));
        super.addExtSessionParametersToProperties(req, params);
        String addType = req.getParameter("ADDTYPE") == null ? " " : req.getParameter("ADDTYPE");
        String addHeader = req.getParameter("ADDHEADER") == null ? " " : req.getParameter("ADDHEADER");
        String addText = req.getParameter("ADDTEXT") == null ? " " : req.getParameter("ADDTEXT");
        String string = addEpost = req.getParameter("ADDEPOST") == null ? " " : req.getParameter("ADDEPOST");
        if (addText.equals("")) {
            addText = " ";
        }
        if (addHeader.equals("")) {
            addHeader = " ";
        }
        if (addEpost.equals("")) {
            addEpost = " ";
        }
        if (addType.equals("")) {
            addType = " ";
        }
        params.setProperty("ADD_EPOST", addEpost);
        params.setProperty("ADD_HEADER", addHeader);
        params.setProperty("ADD_TEXT", addText);
        params.setProperty("ADD_TYPE", addType);
        return params;
    }

    private void sendReplieEmail(String toEmail, String fromEmail, String header, String text, String replyHeader) throws IOException {
        SMTP smtp = Imcms.getServices().getSMTP();
        smtp.sendMail(new SMTP.Mail(fromEmail, new String[]{toEmail}, header, replyHeader + "\n" + text));
    }

    private boolean validateEmail(String eMail) {
        int stringLength = eMail.length();
        int indexAt = eMail.indexOf("@");
        return indexAt > 0 && indexAt < stringLength - 1;
    }

    private String textMailLinkFix(String text) {
        boolean done = false;
        StringBuffer sendStr = new StringBuffer();
        String hackStr = text;
        while (!done) {
            boolean linkB = false;
            boolean mailB = false;
            int lStart = hackStr.indexOf("<L>");
            int lEnd = hackStr.indexOf("</L>");
            int mStart = hackStr.indexOf("<M>");
            int mEnd = hackStr.indexOf("</M>");
            if (lStart != -1 && lEnd != -1) {
                linkB = true;
            }
            if (mStart != -1 && mEnd != -1) {
                mailB = true;
            }
            if (linkB && mailB) {
                if (lStart < mStart) {
                    if (lStart > 0) {
                        sendStr.append(HTMLConv.toHTMLSpecial(hackStr.substring(0, lStart)));
                    }
                    sendStr.append(this.doLinkStuff(hackStr.substring(lStart + 3, lEnd)));
                    hackStr = hackStr.substring(lEnd + 4);
                    continue;
                }
                if (mStart > 0) {
                    sendStr.append(HTMLConv.toHTMLSpecial(hackStr.substring(0, mStart)));
                }
                sendStr.append(this.doMailStuff(hackStr.substring(mStart + 3, mEnd)));
                hackStr = hackStr.substring(mEnd + 4);
                continue;
            }
            if (linkB) {
                if (lStart > 0) {
                    sendStr.append(HTMLConv.toHTMLSpecial(hackStr.substring(0, lStart)));
                }
                sendStr.append(this.doLinkStuff(hackStr.substring(lStart + 3, lEnd)));
                hackStr = hackStr.substring(lEnd + 4);
                continue;
            }
            if (mailB) {
                if (mStart > 0) {
                    sendStr.append(HTMLConv.toHTMLSpecial(hackStr.substring(0, mStart)));
                }
                sendStr.append(this.doMailStuff(hackStr.substring(mStart + 3, mEnd)));
                hackStr = hackStr.substring(mEnd + 4);
                continue;
            }
            sendStr.append(HTMLConv.toHTMLSpecial(hackStr));
            done = true;
        }
        return sendStr.toString();
    }

    private String doLinkStuff(String str) {
        String daLink = "";
        int i = str.indexOf("HTTP://");
        if (i < 0) {
            daLink = "HTTP://";
        }
        return "<A HRef=\"" + daLink + str + "\" Target=\"_new\">" + str + "</A>";
    }

    private String doMailStuff(String str) {
        return "<A HRef=\"mailto:" + str + "\" Target=_new> " + str + "</A>";
    }
}

