/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.billboard;

import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.ParsedTextFile;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BillBoard
extends HttpServlet {
    private static final String ADMIN_BUTTON_TEMPLATE = "billboard_admin_button.htm";
    private static final String UNADMIN_BUTTON_TEMPLATE = "billboard_unadmin_button.htm";

    int getMetaId(HttpServletRequest req) {
        HttpSession session;
        String metaId = req.getParameter("meta_id");
        if (metaId == null && (session = req.getSession(false)) != null) {
            metaId = (String)session.getAttribute("BillBoard.meta_id");
        }
        return Integer.parseInt(metaId);
    }

    MetaInfo.Parameters getBillBoardSessionParameters(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        String metaIdStr = (String)session.getAttribute("BillBoard.meta_id") == null ? "" : (String)session.getAttribute("BillBoard.meta_id");
        int metaId = Integer.parseInt(metaIdStr);
        return new MetaInfo.Parameters(metaId);
    }

    void addExtSessionParametersToProperties(HttpServletRequest req, Properties params) {
        String discId;
        HttpSession session = req.getSession(true);
        String sectionId = (String)session.getAttribute("BillBoard.section_id") == null ? "" : (String)session.getAttribute("BillBoard.section_id");
        String string = discId = (String)session.getAttribute("BillBoard.disc_id") == null ? "" : (String)session.getAttribute("BillBoard.disc_id");
        if (params == null) {
            params = new Properties();
        }
        params.setProperty("SECTION_ID", sectionId);
        params.setProperty("DISC_ID", discId);
    }

    File getExternalTemplateRootFolder(HttpServletRequest req) {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        ImcmsServices imcref = Imcms.getServices();
        int metaId = this.getMetaId(req);
        return imcref.getExternalTemplateFolder(metaId, user);
    }

    File getExternalTemplateFolder(HttpServletRequest req) {
        int metaId = this.getMetaId(req);
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        return new File(imcref.getExternalTemplateFolder(metaId, user), this.getTemplateLibName(imcref, metaId));
    }

    private String getTemplateLibName(ImcmsServices imcref, int meta_id) {
        String libName = imcref.sqlProcedureStr("B_GetTemplateLib", new String[]{"" + meta_id});
        if (libName == null) {
            libName = "original";
        }
        libName = libName + "/";
        return libName;
    }

    void sendHtml(HttpServletRequest req, HttpServletResponse res, VariableManager vm, String htmlFile) throws IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        String imagePath = this.getExternalImageFolder(req);
        VariableManager adminButtonVM = new VariableManager();
        adminButtonVM.addProperty("IMAGE_URL", imagePath);
        adminButtonVM.addProperty("SERVLET_URL", "");
        adminButtonVM.addProperty("ADMIN_LINK_HTML", vm.getProperty("ADMIN_LINK_HTML"));
        VariableManager unAdminButtonVM = new VariableManager();
        unAdminButtonVM.addProperty("IMAGE_URL", imagePath);
        unAdminButtonVM.addProperty("SERVLET_URL", "");
        unAdminButtonVM.addProperty("UNADMIN_LINK_HTML", vm.getProperty("UNADMIN_LINK_HTML"));
        vm.addProperty("IMAGE_URL", imagePath);
        vm.addProperty("SERVLET_URL", "");
        String adminBtn = this.getAdminButtonLink(req, user, adminButtonVM);
        vm.addProperty("SECTION_ADMIN_LINK", adminBtn);
        String unAdminBtn = this.getUnAdminButtonLink(req, user, unAdminButtonVM);
        vm.addProperty("SECTION_UNADMIN_LINK", unAdminBtn);
        String html = this.getTemplate(htmlFile, user, vm.getTagsAndData());
        PrintWriter out = res.getWriter();
        Utility.setDefaultHtmlContentType(res);
        out.println(html);
    }

    Vector convert2Vector(String[] arr) {
        Vector<String> rolesV = new Vector<String>();
        for (int i = 0; i < arr.length; ++i) {
            rolesV.add(arr[i]);
        }
        return rolesV;
    }

    boolean prepareUserForBillBoard(HttpServletRequest req, HttpServletResponse res, MetaInfo.Parameters params, String loginUserId) throws IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return false;
        }
        HttpSession session = req.getSession(false);
        if (session != null) {
            this.setBillBoardSessionAttributes(session, params);
            session.setAttribute("BillBoard.viewedDiscList", (Object)new Properties());
            session.setAttribute("BillBoard.user_id", (Object)loginUserId);
            session.setAttribute("BillBoard.disc_index", (Object)"0");
            String aSectionId = Imcms.getServices().sqlProcedureStr("B_GetFirstSection", new String[]{"" + params.getMetaId()});
            session.setAttribute("BillBoard.section_id", (Object)aSectionId);
            session.setAttribute("BillBoard.disc_id", (Object)"-1");
            res.sendRedirect("BillBoardViewer");
            return true;
        }
        return false;
    }

    String getExternalImageFolder(HttpServletRequest req) {
        int metaId = this.getMetaId(req);
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        String extFolder = req.getContextPath() + "/imcms/" + user.getLanguageIso639_2() + "/images/" + imcref.getDocType(metaId) + '/';
        extFolder = extFolder + this.getTemplateLibName(imcref, metaId);
        return extFolder;
    }

    private String getAdminButtonLink(HttpServletRequest req, UserDomainObject user, VariableManager adminButtonVM) {
        ImcmsServices imcref = Imcms.getServices();
        String adminLink = "&nbsp;";
        int metaId = this.getMetaId(req);
        if (this.userHasAdminRights(imcref, metaId, user)) {
            VariableManager adminLinkVM = new VariableManager();
            adminLinkVM.addProperty("SERVLET_URL", adminButtonVM.getProperty("SERVLET_URL"));
            String adminLinkFile = adminButtonVM.getProperty("ADMIN_LINK_HTML");
            String adminBtn = this.getTemplate(ADMIN_BUTTON_TEMPLATE, user, adminButtonVM.getTagsAndData());
            adminLinkVM.addProperty("ADMIN_BUTTON", adminBtn);
            if (!adminLinkFile.equals("")) {
                adminLink = this.getTemplate(adminLinkFile, user, adminLinkVM.getTagsAndData());
            }
        }
        return adminLink;
    }

    private String getUnAdminButtonLink(HttpServletRequest req, UserDomainObject user, VariableManager unAdminButtonVM) {
        ImcmsServices imcref = Imcms.getServices();
        String unAdminLink = "&nbsp;";
        int metaId = this.getMetaId(req);
        if (this.userHasAdminRights(imcref, metaId, user)) {
            VariableManager unAdminLinkVM = new VariableManager();
            unAdminLinkVM.addProperty("SERVLET_URL", unAdminButtonVM.getProperty("SERVLET_URL"));
            String unAdminLinkFile = unAdminButtonVM.getProperty("UNADMIN_LINK_HTML");
            String unAdminBtn = this.getTemplate(UNADMIN_BUTTON_TEMPLATE, user, unAdminButtonVM.getTagsAndData());
            unAdminLinkVM.addProperty("UNADMIN_BUTTON", unAdminBtn);
            if (!unAdminLinkFile.equals("")) {
                unAdminLink = this.getTemplate(unAdminLinkFile, user, unAdminLinkVM.getTagsAndData());
            }
        }
        return unAdminLink;
    }

    String verifySqlText(String str) {
        StringBuffer buf = new StringBuffer(str);
        char apostrof = '\'';
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) != apostrof) continue;
            buf.insert(i, apostrof);
            ++i;
        }
        str = buf.toString();
        return str;
    }

    Properties verifyForSql(Properties aPropObj) {
        Enumeration<Object> enumValues = aPropObj.elements();
        Enumeration<Object> enumKeys = aPropObj.keys();
        while (enumValues.hasMoreElements() && enumKeys.hasMoreElements()) {
            Object oKeys = enumKeys.nextElement();
            Object oValue = enumValues.nextElement();
            String theVal = oValue.toString();
            String theKey = oKeys.toString();
            aPropObj.setProperty(theKey, this.verifySqlText(theVal));
        }
        return aPropObj;
    }

    boolean isUserAuthorized(HttpServletRequest req, HttpServletResponse res, UserDomainObject user) throws IOException {
        boolean authorized;
        HttpSession session = req.getSession(true);
        String stringMetaId = (String)session.getAttribute("BillBoard.meta_id");
        if (stringMetaId == null) {
            authorized = false;
            Utility.redirectToStartDocument(req, res);
        } else {
            int metaId = Integer.parseInt(stringMetaId);
            authorized = this.isUserAuthorized(res, metaId, user, req);
        }
        return authorized;
    }

    boolean isUserAuthorized(HttpServletResponse res, int metaId, UserDomainObject user, HttpServletRequest req) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(metaId);
        boolean authorized = user.canAccess(document);
        if (!authorized) {
            Utility.redirectToStartDocument(req, res);
        }
        return authorized;
    }

    boolean userHasRightToEdit(ImcmsServices imcref, int metaId, UserDomainObject user) {
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(metaId);
        return user.canAccess(document) && imcref.checkDocAdminRights(metaId, user);
    }

    boolean userHasAdminRights(ImcmsServices imcref, int metaId, UserDomainObject user) {
        return imcref.checkDocAdminRights(metaId, user) && imcref.checkDocAdminRights(metaId, user, 65536);
    }

    String parseOneRecord(List tagsV, List dataV, File htmlCodeFile) throws IOException {
        ParsedTextFile parser = new ParsedTextFile(htmlCodeFile, tagsV, dataV);
        String oneRecordsHtmlCode = parser.toString();
        return oneRecordsHtmlCode;
    }

    void setBillBoardSessionAttributes(HttpSession session, MetaInfo.Parameters params) {
        session.setAttribute("BillBoard.meta_id", (Object)("" + params.getMetaId()));
    }

    String getTemplate(String template, UserDomainObject user, List tagsAndData) {
        return Imcms.getServices().getTemplateFromSubDirectoryOfDirectory(template, user, tagsAndData, "104", "original");
    }
}

