/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.EditDocumentInformationPageFlow;
import com.imcode.imcms.flow.OkCancelPage;
import com.imcode.imcms.flow.Page;
import com.imcode.imcms.servlet.DocumentFinder;
import com.imcode.imcms.servlet.superadmin.AdminManager;
import com.imcode.util.ChainableReversibleNullComparator;
import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.SectionDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;

public class SearchDocumentsPage
extends OkCancelPage {
    public static final String REQUEST_PARAMETER__SECTION_ID = "section_id";
    public static final String REQUEST_PARAMETER__DOCUMENTS_PER_PAGE = "num";
    public static final String REQUEST_PARAMETER__QUERY_STRING = "q";
    public static final String REQUEST_PARAMETER__FIRST_DOCUMENT_INDEX = "start";
    public static final String REQUEST_ATTRIBUTE__PAGE = "sp";
    public static final String REQUEST_PARAMETER__SELECTED_DOCUMENT_ID = "select";
    public static final String REQUEST_PARAMETER__TO_EDIT_DOCUMENT_ID = "toedit";
    public static final String REQUEST_PARAMETER__SEARCH_BUTTON = "search";
    public static final String REQUEST_PARAMETER__CANCEL_BUTTON = "cancel";
    public static final String REQUEST_PARAMETER__USER_RESTRICTION = "permission";
    public static final String REQUEST_PARAMETER__DATE_TYPE = "date_type";
    public static final String REQUEST_PARAMETER__START_DATE = "start_date";
    public static final String REQUEST_PARAMETER__END_DATE = "end_date";
    public static final String REQUEST_PARAMETER__SORT_ORDER = "sort_order";
    public static final String REQUEST_PARAMETER__PHASE = "phase";
    private static final int DEFAULT_DOCUMENTS_PER_PAGE = 10;
    private static final Logger log = Logger.getLogger((String)SearchDocumentsPage.class.getName());
    private String queryString;
    private Set sections = new HashSet();
    private String[] phases;
    private String userDocumentsRestriction;
    private String dateTypeRestriction;
    private Date startDate;
    private Date endDate;
    private String sortOrder;
    private DocumentDomainObject[] documentsFound;
    private int firstDocumentIndex;
    private int documentsPerPage = 10;
    private DocumentDomainObject selectedDocument;
    private Query query;
    private boolean searchButtonPressed;
    DocumentFinder documentFinder;
    public static final String USER_DOCUMENTS_RESTRICTION__NONE = "";
    public static final String USER_DOCUMENTS_RESTRICTION__DOCUMENTS_CREATED_BY_USER = "created";
    public static final String USER_DOCUMENTS_RESTRICTION__DOCUMENTS_PUBLISHED_BY_USER = "published";
    public static final String DATE_TYPE__PUBLICATION_START = "publication_start";
    public static final String DATE_TYPE__PUBLICATION_END = "publication_end";
    public static final String DATE_TYPE__CREATED = "created";
    public static final String DATE_TYPE__ARCHIVED = "archived";
    public static final String DATE_TYPE__MODIFIED = "modified";

    public SearchDocumentsPage() {
        super(null, null);
    }

    public void updateFromRequest(HttpServletRequest request) {
        String sortOrderParameter;
        String endDateParameter;
        String dateTypeRestrictionParameter;
        String userDocumentsRestrictionParameter;
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        if (this.documentFinder.isDocumentsSelectable()) {
            try {
                this.selectedDocument = documentMapper.getDocument(Integer.parseInt(request.getParameter(REQUEST_PARAMETER__SELECTED_DOCUMENT_ID)));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.firstDocumentIndex = Math.max(0, NumberUtils.stringToInt((String)request.getParameter(REQUEST_PARAMETER__FIRST_DOCUMENT_INDEX)));
        boolean gotNewFirstDocumentIndex = Utility.parameterIsSet(request, REQUEST_PARAMETER__FIRST_DOCUMENT_INDEX);
        if (!gotNewFirstDocumentIndex) {
            try {
                this.sections.clear();
                int[] sectionIds = Utility.getParameterInts(request, REQUEST_PARAMETER__SECTION_ID);
                for (int i = 0; i < sectionIds.length; ++i) {
                    int sectionId = sectionIds[i];
                    SectionDomainObject section = documentMapper.getSectionById(sectionId);
                    this.sections.add(section);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.phases = Utility.getParameterValues(request, REQUEST_PARAMETER__PHASE);
        }
        if (null != (userDocumentsRestrictionParameter = request.getParameter(REQUEST_PARAMETER__USER_RESTRICTION))) {
            this.userDocumentsRestriction = userDocumentsRestrictionParameter;
        }
        if (null != (dateTypeRestrictionParameter = request.getParameter(REQUEST_PARAMETER__DATE_TYPE))) {
            this.dateTypeRestriction = dateTypeRestrictionParameter;
        }
        SimpleDateFormat dateFormat = this.createDateFormat();
        String startDateParameter = request.getParameter(REQUEST_PARAMETER__START_DATE);
        if (null != startDateParameter) {
            try {
                this.startDate = dateFormat.parse(startDateParameter);
            }
            catch (java.text.ParseException pe) {
                this.startDate = null;
            }
        }
        if (null != (endDateParameter = request.getParameter(REQUEST_PARAMETER__END_DATE))) {
            try {
                this.endDate = dateFormat.parse(endDateParameter);
            }
            catch (java.text.ParseException ignored) {
                this.endDate = null;
            }
        }
        if (null != (sortOrderParameter = request.getParameter(REQUEST_PARAMETER__SORT_ORDER))) {
            this.sortOrder = sortOrderParameter;
            ChainableReversibleNullComparator documentComparator = AdminManager.getComparator(this.sortOrder);
            this.documentFinder.setDocumentComparator(documentComparator);
        }
        try {
            this.documentsPerPage = Integer.parseInt(request.getParameter(REQUEST_PARAMETER__DOCUMENTS_PER_PAGE));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        if (this.documentsPerPage <= 0) {
            this.documentsPerPage = 10;
        }
        this.queryString = StringUtils.defaultString((String)request.getParameter(REQUEST_PARAMETER__QUERY_STRING));
        this.searchButtonPressed = null != request.getParameter(REQUEST_PARAMETER__SEARCH_BUTTON);
        this.query = this.createQuery(this.documentFinder, Utility.getLoggedOnUser(request));
    }

    private SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    private Query createQuery(DocumentFinder documentFinder, UserDomainObject user) {
        BooleanQuery newQuery = new BooleanQuery();
        if (StringUtils.isNotBlank((String)this.queryString)) {
            try {
                Query textQuery = documentFinder.parse(this.queryString);
                newQuery.add(textQuery, true, false);
            }
            catch (ParseException e) {
                log.debug((Object)(e.getMessage() + " in search-string " + this.queryString), (Throwable)e);
            }
        }
        if (!this.sections.isEmpty()) {
            BooleanQuery sectionQueries = new BooleanQuery();
            Iterator iterator = this.sections.iterator();
            while (iterator.hasNext()) {
                SectionDomainObject section = (SectionDomainObject)iterator.next();
                sectionQueries.add((Query)new TermQuery(new Term("section", section.getName().toLowerCase())), false, false);
            }
            newQuery.add((Query)sectionQueries, true, false);
        }
        BooleanQuery phaseQueries = new BooleanQuery();
        for (int i = 0; i < this.phases.length; ++i) {
            String phase = this.phases[i];
            TermQuery phaseQuery = new TermQuery(new Term(REQUEST_PARAMETER__PHASE, USER_DOCUMENTS_RESTRICTION__NONE + phase));
            phaseQueries.add((Query)phaseQuery, false, false);
        }
        if (this.phases.length > 0) {
            newQuery.add((Query)phaseQueries, true, false);
        }
        if ("created".equals(this.userDocumentsRestriction)) {
            TermQuery createdByUserQuery = new TermQuery(new Term("creator_id", USER_DOCUMENTS_RESTRICTION__NONE + user.getId()));
            newQuery.add((Query)createdByUserQuery, true, false);
        }
        if (USER_DOCUMENTS_RESTRICTION__DOCUMENTS_PUBLISHED_BY_USER.equals(this.userDocumentsRestriction)) {
            TermQuery publishedByUserQuery = new TermQuery(new Term("publisher_id", USER_DOCUMENTS_RESTRICTION__NONE + user.getId()));
            newQuery.add((Query)publishedByUserQuery, true, false);
        }
        if (null != this.startDate || null != this.endDate) {
            Date calculatedEndDate;
            Date luceneMinDate = new Date(0L);
            Date luceneMaxDate = new Date(31536000000000L);
            Date calculatedStartDate = null == this.startDate ? luceneMinDate : this.startDate;
            Date date = calculatedEndDate = null == this.endDate ? luceneMaxDate : new Date(this.endDate.getTime() + 86400000L);
            String dateField = DATE_TYPE__PUBLICATION_END.equals(this.dateTypeRestriction) ? "publication_end_datetime" : (DATE_TYPE__ARCHIVED.equals(this.dateTypeRestriction) ? "archived_datetime" : ("created".equals(this.dateTypeRestriction) ? "created_datetime" : (DATE_TYPE__MODIFIED.equals(this.dateTypeRestriction) ? "modified_datetime" : "publication_start_datetime")));
            Term lowerTerm = new Term(dateField, DateField.dateToString((Date)calculatedStartDate));
            Term upperTerm = new Term(dateField, DateField.dateToString((Date)calculatedEndDate));
            RangeQuery publicationStartedQuery = new RangeQuery(lowerTerm, upperTerm, true);
            newQuery.add((Query)publicationStartedQuery, true, false);
        }
        if (0 == newQuery.getClauses().length) {
            return null;
        }
        return newQuery;
    }

    protected boolean wasCanceled(HttpServletRequest request) {
        return this.documentFinder.isCancelable() && super.wasCanceled(request);
    }

    protected void dispatchCancel(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.documentFinder.cancel(request, response);
    }

    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentDomainObject documentSelectedForEditing = null;
        try {
            DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
            documentSelectedForEditing = documentMapper.getDocument(Integer.parseInt(request.getParameter(REQUEST_PARAMETER__TO_EDIT_DOCUMENT_ID)));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (null != documentSelectedForEditing) {
            this.goToEditDocumentInformation(request, response, documentSelectedForEditing);
        } else if (null != this.getSelectedDocument()) {
            this.documentFinder.selectDocument(this.getSelectedDocument(), request, response);
        } else {
            this.documentFinder.forwardWithPage(request, response, this);
        }
    }

    private void goToEditDocumentInformation(HttpServletRequest request, HttpServletResponse response, DocumentDomainObject documentSelectedForEditing) throws IOException, ServletException {
        DispatchCommand returnCommand = new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                SearchDocumentsPage.this.documentFinder.forwardWithPage(request, response, SearchDocumentsPage.this);
            }
        };
        EditDocumentInformationPageFlow editDocumentInformationPageFlow = new EditDocumentInformationPageFlow(documentSelectedForEditing, returnCommand, new DocumentMapper.SaveEditedDocumentCommand());
        editDocumentInformationPageFlow.setAdminButtonsHidden(true);
        editDocumentInformationPageFlow.dispatch(request, response);
    }

    public String getParameterStringWithParameter(HttpServletRequest request, String parameterName, String parameterValue) {
        MultiMap parameters = this.getParameterMap(request);
        parameters.put((Object)parameterName, (Object)parameterValue);
        return Utility.createQueryStringFromParameterMultiMap(parameters);
    }

    private MultiMap getParameterMap(HttpServletRequest request) {
        MultiHashMap parameters = new MultiHashMap();
        String pageSessionNameFromRequest = Page.getPageSessionNameFromRequest(request);
        if (null != pageSessionNameFromRequest) {
            parameters.put((Object)"page", (Object)pageSessionNameFromRequest);
        }
        return parameters;
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        this.putInSessionAndForwardToPath("/imcms/" + user.getLanguageIso639_2() + "/jsp/search_documents.jsp", request, response);
    }

    public Set getSections() {
        return Collections.unmodifiableSet(this.sections);
    }

    public DocumentDomainObject[] getDocumentsFound() {
        return this.documentsFound;
    }

    public void setDocumentsFound(DocumentDomainObject[] documentsFound) {
        this.documentsFound = documentsFound;
    }

    public int getFirstDocumentIndex() {
        return this.firstDocumentIndex;
    }

    public int getDocumentsPerPage() {
        return this.documentsPerPage;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public DocumentDomainObject getSelectedDocument() {
        return this.selectedDocument;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isSearchButtonPressed() {
        return this.searchButtonPressed;
    }

    public DocumentFinder getDocumentFinder() {
        return this.documentFinder;
    }

    public void setDocumentFinder(DocumentFinder documentFinder) {
        this.documentFinder = documentFinder;
    }

    public String[] getPhases() {
        return this.phases;
    }

    public String getFormattedStartDate() {
        return this.formatDate(this.startDate);
    }

    public String getFormattedEndDate() {
        return this.formatDate(this.endDate);
    }

    private String formatDate(Date date) {
        SimpleDateFormat dateFormat = this.createDateFormat();
        if (null != date) {
            return dateFormat.format(date);
        }
        return USER_DOCUMENTS_RESTRICTION__NONE;
    }

    public String getDateTypeRestriction() {
        return this.dateTypeRestriction;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public String getUserDocumentsRestriction() {
        return this.userDocumentsRestriction;
    }
}

