/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import imcode.external.GetDocControllerInterface;
import imcode.server.DocumentRequest;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.Revisits;
import imcode.server.SystemData;
import imcode.server.document.BillboardDocumentDomainObject;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.ChatDocumentDomainObject;
import imcode.server.document.ConferenceDocumentDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.FormerExternalDocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.parser.ParserParameters;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class GetDoc
extends HttpServlet {
    private static final Logger trackLog = Logger.getLogger((String)"com.imcode.imcms.log.access");
    private static final Logger log = Logger.getLogger((String)GetDoc.class.getName());
    private static final String NO_ACTIVE_DOCUMENT_URL = "no_active_document.html";
    private static final String NO_PAGE_URL = "no_page.html";
    private static final String HTTP_HEADER_REFERRER = "Referer";
    public static final String REQUEST_PARAMETER__FILE_ID = "file_id";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int meta_id;
        ImcmsServices imcref = Imcms.getServices();
        try {
            meta_id = Integer.parseInt(req.getParameter("meta_id"));
        }
        catch (NumberFormatException ex) {
            meta_id = imcref.getSystemData().getStartDocument();
        }
        GetDoc.output(meta_id, req, res);
    }

    static void output(int meta_id, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String tempstring = GetDoc.getDoc(meta_id, req, res);
        if (tempstring != null) {
            byte[] tempbytes = tempstring.getBytes("windows-1252");
            res.setContentLength(tempbytes.length);
            res.getOutputStream().write(tempbytes);
        }
    }

    public static String getDoc(int meta_id, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        DocumentMapper documentMapper;
        DocumentDomainObject document;
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession(true);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        Stack<Integer> history = (Stack<Integer>)user.get("history");
        if (history == null) {
            history = new Stack<Integer>();
            user.put("history", history);
        }
        Integer meta_int = new Integer(meta_id);
        if (history.empty() || !history.peek().equals(meta_int)) {
            history.push(meta_int);
        }
        if (null == (document = (documentMapper = imcref.getDocumentMapper()).getDocument(meta_id))) {
            return GetDoc.getDocumentDoesNotExistPage(res, user);
        }
        String referrer = req.getHeader(HTTP_HEADER_REFERRER);
        DocumentDomainObject referringDocument = null;
        Perl5Util perlrx = new Perl5Util();
        if (null != referrer && perlrx.match("/meta_id=(\\d+)/", referrer)) {
            int referring_meta_id = Integer.parseInt(perlrx.group(1));
            referringDocument = documentMapper.getDocument(referring_meta_id);
        }
        DocumentRequest documentRequest = new DocumentRequest(imcref, user, document, referringDocument, req, res);
        documentRequest.setEmphasize(req.getParameterValues("emp"));
        Cookie[] cookies = req.getCookies();
        Hashtable<String, String> cookieHash = new Hashtable<String, String>();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            Cookie currentCookie = cookies[i];
            cookieHash.put(currentCookie.getName(), currentCookie.getValue());
        }
        Revisits revisits = new Revisits();
        if (cookieHash.get("imVisits") == null) {
            Date now = new Date();
            long lNow = now.getTime();
            String sNow = "" + lNow;
            Cookie resCookie = new Cookie("imVisits", session.getId() + sNow);
            resCookie.setMaxAge(31500000);
            resCookie.setPath("/");
            res.addCookie(resCookie);
            revisits.setRevisitsId(session.getId());
            revisits.setRevisitsDate(sNow);
        } else {
            revisits.setRevisitsId(cookieHash.get("imVisits").toString());
        }
        documentRequest.setRevisits(revisits);
        if (!user.canAccess(document)) {
            Utility.forwardToLogin(req, res);
            return null;
        }
        if (!document.isPublished() && !user.canEdit(document)) {
            res.setStatus(403);
            return imcref.getAdminTemplate(NO_ACTIVE_DOCUMENT_URL, user, null);
        }
        if (document instanceof FormerExternalDocumentDomainObject) {
            Utility.setDefaultHtmlContentType(res);
            GetDoc.redirectToExternalDocumentTypeWithAction(document, req, res, "view");
            trackLog.info((Object)documentRequest);
            return null;
        }
        if (document instanceof UrlDocumentDomainObject) {
            String url_ref = ((UrlDocumentDomainObject)document).getUrl();
            res.sendRedirect(url_ref);
            trackLog.info((Object)documentRequest);
            return null;
        }
        if (document instanceof BrowserDocumentDomainObject) {
            String tmp;
            String br_id = req.getHeader("User-Agent");
            if (br_id == null) {
                br_id = "";
            }
            if ((tmp = imcref.sqlQueryStr("select top 1 to_meta_id\nfrom browser_docs\njoin browsers on browsers.browser_id = browser_docs.browser_id\nwhere meta_id = ? and ? like user_agent order by value desc", new String[]{"" + meta_id, br_id})) != null && !"".equals(tmp)) {
                meta_id = Integer.parseInt(tmp);
            } else {
                Map browserDocumentIdMap = ((BrowserDocumentDomainObject)document).getBrowserDocumentIdMap();
                meta_id = (Integer)browserDocumentIdMap.get(BrowserDocumentDomainObject.Browser.DEFAULT);
            }
            res.sendRedirect("GetDoc?meta_id=" + meta_id);
            trackLog.info((Object)documentRequest);
            return null;
        }
        if (document instanceof HtmlDocumentDomainObject) {
            Utility.setDefaultHtmlContentType(res);
            String html_str_temp = imcref.isFramesetDoc(meta_id);
            if (html_str_temp == null) {
                throw new RuntimeException("Null-frameset encountered.");
            }
            String htmlStr = html_str_temp;
            trackLog.info((Object)documentRequest);
            return htmlStr;
        }
        if (document instanceof FileDocumentDomainObject) {
            BufferedInputStream fr;
            String fileId = req.getParameter(REQUEST_PARAMETER__FILE_ID);
            FileDocumentDomainObject fileDocument = (FileDocumentDomainObject)document;
            FileDocumentDomainObject.FileDocumentFile file = fileDocument.getFileOrDefault(fileId);
            String filename = file.getFilename();
            String mimetype = file.getMimeType();
            try {
                fr = new BufferedInputStream(file.getInputStreamSource().getInputStream());
            }
            catch (IOException ex) {
                return GetDoc.getDocumentDoesNotExistPage(res, user);
            }
            int len = ((InputStream)fr).available();
            ServletOutputStream out = res.getOutputStream();
            res.setContentLength(len);
            res.setContentType(mimetype);
            String content_disposition = (null != req.getParameter("download") ? "attachment" : "inline") + "; filename=\"" + filename + "\"";
            res.setHeader("Content-Disposition", content_disposition);
            try {
                int bytes_read;
                byte[] buffer = new byte[32768];
                while (-1 != (bytes_read = ((InputStream)fr).read(buffer))) {
                    out.write(buffer, 0, bytes_read);
                }
            }
            catch (SocketException ex) {
                log.debug((Object)"Exception occured", (Throwable)ex);
            }
            ((InputStream)fr).close();
            out.flush();
            out.close();
            trackLog.info((Object)documentRequest);
            return null;
        }
        Utility.setDefaultHtmlContentType(res);
        String externalparam = null;
        if (req.getParameter("externalClass") != null || req.getAttribute("externalClass") != null) {
            String className = req.getParameter("externalClass") != null ? req.getParameter("externalClass") : (String)req.getAttribute("externalClass");
            try {
                Class<?> cl = Class.forName(className);
                GetDocControllerInterface obj = (GetDocControllerInterface)cl.newInstance();
                externalparam = obj.createString(req);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                externalparam = "<!-- Exception: " + sw.toString() + " -->";
            }
        }
        user.setTemplateGroup(null);
        ParserParameters paramsToParser = new ParserParameters(documentRequest);
        paramsToParser.setTemplate(req.getParameter("template"));
        paramsToParser.setParameter(req.getParameter("param"));
        paramsToParser.setExternalParameter(externalparam);
        trackLog.info((Object)documentRequest);
        String result = imcref.parsePage(paramsToParser);
        return result;
    }

    public static String getDocumentDoesNotExistPage(HttpServletResponse res, UserDomainObject user) {
        ImcmsServices imcref = Imcms.getServices();
        ArrayList<String> vec = new ArrayList<String>();
        SystemData sysData = imcref.getSystemData();
        String eMailServerMaster = sysData.getServerMasterAddress();
        vec.add("#EMAIL_SERVER_MASTER#");
        vec.add(eMailServerMaster);
        res.setStatus(404);
        return imcref.getAdminTemplate(NO_PAGE_URL, user, vec);
    }

    public static void redirectToExternalDocumentTypeWithAction(DocumentDomainObject document, HttpServletRequest request, HttpServletResponse res, String action) throws IOException {
        String externalDocumentTypeServlet = "";
        if (document instanceof ConferenceDocumentDomainObject) {
            externalDocumentTypeServlet = "ConfManager";
        } else if (document instanceof ChatDocumentDomainObject) {
            externalDocumentTypeServlet = "ChatManager";
        } else if (document instanceof BillboardDocumentDomainObject) {
            externalDocumentTypeServlet = "BillBoardManager";
        }
        String paramStr = "?meta_id=" + document.getId() + "&";
        paramStr = paramStr + "cookie_id=1A&action=" + action;
        res.sendRedirect(request.getContextPath() + "/servlet/" + externalDocumentTypeServlet + paramStr);
    }
}

