/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentAlreadyInMenuException;
import com.imcode.imcms.api.MockContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import imcode.server.Config;
import imcode.server.MockImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentReference;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.Date;
import junit.framework.TestCase;

public class TestTextDocument
extends TestCase {
    TextDocument.Menu menu;
    private UserDomainObject internalUser;
    private TextDocumentDomainObject textDocumentDO;
    private TextDocumentDomainObject otherTextDocumentDO;
    private RoleDomainObject readRole;
    private RoleDomainObject editRole;
    private TextDocument textDocument;
    private MockContentManagementSystem contentManagementSystem;
    private TextDocument otherTextDocument;

    protected void setUp() throws Exception {
        super.setUp();
        this.internalUser = new UserDomainObject();
        this.readRole = new RoleDomainObject(3, "Read", 0);
        this.editRole = new RoleDomainObject(4, "Edit", 0);
        this.textDocumentDO = new TextDocumentDomainObject();
        this.textDocumentDO.setId(1001);
        this.textDocumentDO.setPermissionSetIdForRole(this.readRole, 3);
        this.textDocumentDO.setPermissionSetIdForRole(this.editRole, 0);
        this.otherTextDocumentDO = new TextDocumentDomainObject();
        this.otherTextDocumentDO.setId(1002);
        this.otherTextDocumentDO.setLinkableByOtherUsers(true);
        int menuIndex = 1;
        MockDocumentReference documentReference = new MockDocumentReference(this.otherTextDocumentDO);
        MenuDomainObject menuDO = this.textDocumentDO.getMenu(menuIndex);
        menuDO.addMenuItem(new MenuItemDomainObject(documentReference));
        this.contentManagementSystem = new MockContentManagementSystem();
        MockImcmsServices imcmsServices = new MockImcmsServices();
        imcmsServices.setDocumentMapper(new DocumentMapper(null, null, null, null, null, null, new Config()));
        this.contentManagementSystem.setInternal(imcmsServices);
        this.contentManagementSystem.setCurrentUser(new User(this.internalUser));
        this.textDocument = new TextDocument(this.textDocumentDO, (ContentManagementSystem)this.contentManagementSystem);
        this.otherTextDocument = new TextDocument(this.otherTextDocumentDO, (ContentManagementSystem)this.contentManagementSystem);
        this.menu = new TextDocument.Menu(this.textDocument, menuIndex);
    }

    public void testMenuGetDocumentsAndMenuItemsWithNothing() {
        this.assertGettersDoNotReturnDocuments();
    }

    public void testMenuGetDocumentsAndMenuItems() {
        this.internalUser.addRole(this.editRole);
        this.otherTextDocumentDO.setPermissionSetIdForRole(this.editRole, 0);
        this.assertGettersReturnDocuments();
    }

    public void testMenuGetVisible() throws Exception {
        this.internalUser.addRole(this.readRole);
        this.otherTextDocumentDO.setPermissionSetIdForRole(this.readRole, 3);
        this.otherTextDocumentDO.setStatus(2);
        this.otherTextDocumentDO.setPublicationStartDatetime(new Date(0L));
        this.assertGetVisibleReturnDocuments();
    }

    public void testMenuGetVisibleWithArchived() throws Exception {
        this.internalUser.addRole(this.readRole);
        this.otherTextDocumentDO.setPermissionSetIdForRole(this.readRole, 3);
        this.otherTextDocumentDO.setStatus(2);
        this.otherTextDocumentDO.setPublicationStartDatetime(new Date(0L));
        this.otherTextDocumentDO.setArchivedDatetime(new Date(0L));
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithNothing() throws Exception {
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithRole() throws Exception {
        this.internalUser.addRole(this.readRole);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithRoleAndPermission() throws Exception {
        this.internalUser.addRole(this.readRole);
        this.otherTextDocumentDO.setPermissionSetIdForRole(this.readRole, 3);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithApprovedStatus() throws Exception {
        this.otherTextDocumentDO.setStatus(2);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithPublicationStart() throws Exception {
        this.otherTextDocumentDO.setPublicationStartDatetime(new Date(0L));
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithPublished() throws Exception {
        this.otherTextDocumentDO.setStatus(2);
        this.otherTextDocumentDO.setPublicationStartDatetime(new Date(0L));
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithVisibleInMenusForUnauthorizedUsers() throws Exception {
        this.otherTextDocumentDO.setVisibleInMenusForUnauthorizedUsers(true);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithPublishedAndVisibleInMenusForUnauthorizedUsers() throws Exception {
        this.otherTextDocumentDO.setStatus(2);
        this.otherTextDocumentDO.setPublicationStartDatetime(new Date(0L));
        this.otherTextDocumentDO.setVisibleInMenusForUnauthorizedUsers(true);
        this.assertGetVisibleReturnDocuments();
    }

    private void assertGettersDoNotReturnDocuments() {
        TestTextDocument.assertFalse((this.menu.getDocuments().length > 0 ? 1 : 0) != 0);
        TestTextDocument.assertFalse((this.menu.getMenuItems().length > 0 ? 1 : 0) != 0);
    }

    private void assertGettersReturnDocuments() {
        TestTextDocument.assertTrue((this.menu.getDocuments().length > 0 ? 1 : 0) != 0);
        TestTextDocument.assertTrue((this.menu.getMenuItems().length > 0 ? 1 : 0) != 0);
    }

    private void assertGetVisibleReturnDocuments() {
        TestTextDocument.assertTrue((this.menu.getVisibleDocuments().length > 0 ? 1 : 0) != 0);
        TestTextDocument.assertTrue((this.menu.getVisibleMenuItems().length > 0 ? 1 : 0) != 0);
    }

    private void assertGetVisibleDoNotReturnDocuments() {
        TestTextDocument.assertFalse((this.menu.getVisibleDocuments().length > 0 ? 1 : 0) != 0);
        TestTextDocument.assertFalse((this.menu.getVisibleMenuItems().length > 0 ? 1 : 0) != 0);
    }

    public void testAddDocument() throws DocumentAlreadyInMenuException, NoPermissionException {
        try {
            this.menu.addDocument(this.otherTextDocument);
            TestTextDocument.fail();
        }
        catch (NoPermissionException npe) {
            // empty catch block
        }
        this.internalUser.addRole(this.readRole);
        this.otherTextDocumentDO.setPermissionSetIdForRole(this.readRole, 3);
        try {
            this.menu.addDocument(this.otherTextDocument);
            TestTextDocument.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
        this.internalUser.addRole(this.editRole);
        this.menu.addDocument(this.otherTextDocument);
    }

    public void testRemoveDocument() throws NoPermissionException {
        try {
            this.menu.removeDocument(this.otherTextDocument);
            TestTextDocument.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
        this.internalUser.addRole(this.editRole);
        this.menu.removeDocument(this.otherTextDocument);
    }

    private static class MockDocumentReference
    extends DocumentReference {
        private final DocumentDomainObject document;

        MockDocumentReference(DocumentDomainObject document) {
            super(document.getId(), null);
            this.document = document;
        }

        public DocumentDomainObject getDocument() {
            return this.document;
        }
    }
}

