/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.fortune;

import imcode.util.fortune.DateRange;
import java.util.Date;
import junit.framework.TestCase;

public class TestDateRange
extends TestCase {
    private Date date10;
    private Date date20;
    private Date date30;
    private Date date40;
    private DateRange range10to10;
    private DateRange range10to20;
    private DateRange range10to30;
    private DateRange range10to40;
    private DateRange range20to20;
    private DateRange range20to30;

    public TestDateRange(String name) {
        super(name);
    }

    protected void setUp() {
        this.date10 = new Date(10L);
        this.date20 = new Date(20L);
        this.date30 = new Date(30L);
        this.date40 = new Date(40L);
        this.range10to10 = new DateRange(this.date10, this.date10);
        this.range10to20 = new DateRange(this.date10, this.date20);
        this.range10to30 = new DateRange(this.date10, this.date30);
        this.range10to40 = new DateRange(this.date10, this.date40);
        this.range20to20 = new DateRange(this.date20, this.date20);
        this.range20to30 = new DateRange(this.date20, this.date30);
    }

    public void testEquals() {
        TestDateRange.assertEquals((Object)this.range10to10, (Object)this.range10to10);
        TestDateRange.assertEquals((Object)this.range20to30, (Object)this.range20to30);
    }

    public void testGets() {
        TestDateRange.assertEquals((Object)this.range10to10.getStartDate(), (Object)this.date10);
        TestDateRange.assertEquals((Object)this.range10to10.getEndDate(), (Object)this.date10);
    }

    public void testContains() {
        TestDateRange.assertTrue((!this.range10to10.contains(this.date10) ? 1 : 0) != 0);
        TestDateRange.assertTrue((boolean)this.range10to20.contains(this.date10));
        TestDateRange.assertTrue((!this.range10to20.contains(this.date20) ? 1 : 0) != 0);
        TestDateRange.assertTrue((boolean)this.range10to30.contains(this.date20));
        TestDateRange.assertTrue((!this.range10to30.contains(this.date30) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to30.contains(this.date40) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range20to30.contains(this.date10) ? 1 : 0) != 0);
    }

    public void testZeroWidthOverlap() {
        TestDateRange.assertTrue((!this.range10to10.overlap(this.range10to10) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to10.overlap(this.range10to20) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to10.overlap(this.range10to30) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to10.overlap(this.range10to40) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to10.overlap(this.range20to20) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to10.overlap(this.range20to30) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to20.overlap(this.range10to10) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to20.overlap(this.range20to20) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range10to30.overlap(this.range10to10) ? 1 : 0) != 0);
        TestDateRange.assertTrue((boolean)this.range10to30.overlap(this.range20to20));
        TestDateRange.assertTrue((!this.range10to40.overlap(this.range10to10) ? 1 : 0) != 0);
        TestDateRange.assertTrue((boolean)this.range10to40.overlap(this.range20to20));
        TestDateRange.assertTrue((!this.range20to20.overlap(this.range10to10) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range20to20.overlap(this.range10to20) ? 1 : 0) != 0);
        TestDateRange.assertTrue((boolean)this.range20to20.overlap(this.range10to30));
        TestDateRange.assertTrue((boolean)this.range20to20.overlap(this.range10to40));
        TestDateRange.assertTrue((!this.range20to20.overlap(this.range20to20) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range20to20.overlap(this.range20to30) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range20to30.overlap(this.range20to20) ? 1 : 0) != 0);
        TestDateRange.assertTrue((!this.range20to30.overlap(this.range10to10) ? 1 : 0) != 0);
    }

    public void testOverlap() {
        TestDateRange.assertTrue((boolean)this.range10to20.overlap(this.range10to20));
        TestDateRange.assertTrue((boolean)this.range10to20.overlap(this.range10to30));
        TestDateRange.assertTrue((boolean)this.range10to20.overlap(this.range10to40));
        TestDateRange.assertTrue((!this.range10to20.overlap(this.range20to30) ? 1 : 0) != 0);
        TestDateRange.assertTrue((boolean)this.range10to30.overlap(this.range10to20));
        TestDateRange.assertTrue((boolean)this.range10to30.overlap(this.range10to30));
        TestDateRange.assertTrue((boolean)this.range10to30.overlap(this.range10to40));
        TestDateRange.assertTrue((boolean)this.range10to30.overlap(this.range20to30));
        TestDateRange.assertTrue((boolean)this.range10to40.overlap(this.range10to20));
        TestDateRange.assertTrue((boolean)this.range10to40.overlap(this.range10to30));
        TestDateRange.assertTrue((boolean)this.range10to40.overlap(this.range10to40));
        TestDateRange.assertTrue((boolean)this.range10to40.overlap(this.range20to30));
        TestDateRange.assertTrue((!this.range20to30.overlap(this.range10to20) ? 1 : 0) != 0);
        TestDateRange.assertTrue((boolean)this.range20to30.overlap(this.range10to30));
        TestDateRange.assertTrue((boolean)this.range20to30.overlap(this.range10to40));
        TestDateRange.assertTrue((boolean)this.range20to30.overlap(this.range20to30));
    }
}

