/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.fortune;

import imcode.util.fortune.Poll;
import imcode.util.fortune.Quote;
import imcode.util.fortune.QuoteReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

public class PollReader {
    private QuoteReader quoteReader;

    public PollReader(Reader reader) {
        this.quoteReader = new QuoteReader(reader);
    }

    public Poll readPoll() throws IOException {
        try {
            return this.parsePollFromQuote(this.quoteReader.readQuote());
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    private Poll parsePollFromQuote(Quote aQuote) {
        StringTokenizer tokenizer = new StringTokenizer(aQuote.getText(), "#");
        String question = "";
        if (tokenizer.hasMoreTokens()) {
            question = tokenizer.nextToken();
        }
        Poll thePoll = new Poll(question, aQuote.getDateRange());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int tokenIndex = token.indexOf(": ");
            if (token.length() <= 3 || tokenIndex == -1) continue;
            try {
                String answer = token.substring(0, tokenIndex);
                String answerCountString = token.substring(tokenIndex + 2);
                int answerCount = Integer.parseInt(answerCountString);
                thePoll.setAnswerCount(answer, answerCount);
            }
            catch (NumberFormatException ignored) {}
        }
        return thePoll;
    }
}

