/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.CollectingHttpServletResponse;
import imcode.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class Utility {
    private static final Logger log = Logger.getLogger((String)Utility.class.getName());
    private static final String NO_PERMISSION_URL = "no_permission.jsp";

    private Utility() {
    }

    public static String ipLongToString(long ip) {
        return (ip >>> 24 & 0xFFL) + "." + (ip >>> 16 & 0xFFL) + "." + (ip >>> 8 & 0xFFL) + "." + (ip & 0xFFL);
    }

    public static long ipStringToLong(String ip) {
        long ipInt = 0L;
        StringTokenizer ipTok = new StringTokenizer(ip, ".");
        int exp = 3;
        while (ipTok.hasMoreTokens()) {
            int ipNum = Integer.parseInt(ipTok.nextToken());
            ipInt = (long)((double)ipInt + (double)ipNum * Math.pow(256.0, exp));
            --exp;
        }
        return ipInt;
    }

    public static void setNoCache(HttpServletResponse res) {
        res.setHeader("Cache-Control", "no-cache; must-revalidate;");
        res.setHeader("Pragma", "no-cache;");
        res.setDateHeader("Expires", 0L);
    }

    public static UserDomainObject getLoggedOnUser(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        UserDomainObject user = (UserDomainObject)session.getAttribute("logon.isDone");
        return user;
    }

    public static int compareDatesWithNullFirst(Date date1, Date date2) {
        if (null == date1 && null == date2) {
            return 0;
        }
        if (null == date1) {
            return -1;
        }
        if (null == date2) {
            return 1;
        }
        return date1.compareTo(date2);
    }

    public static void setDefaultHtmlContentType(HttpServletResponse res) {
        res.setContentType("text/html; charset=windows-1252");
    }

    public static void redirectToStartDocument(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.sendRedirect(req.getContextPath() + "/servlet/StartDoc");
    }

    public static boolean isValidEmail(String email) {
        return Pattern.compile("\\w+@\\w+").matcher(email).find();
    }

    public static void removeNullValuesFromMap(Map map) {
        Collection values = map.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            if (null != iterator.next()) continue;
            iterator.remove();
        }
    }

    public static String createQueryStringFromParameterMultiMap(MultiMap requestParameters) {
        Set requestParameterStrings = SetUtils.orderedSet(new HashSet());
        Iterator iterator = requestParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String parameterName = (String)entry.getKey();
            Collection parameterValues = (Collection)entry.getValue();
            Iterator valuesIterator = parameterValues.iterator();
            while (valuesIterator.hasNext()) {
                String parameterValue = (String)valuesIterator.next();
                requestParameterStrings.add(URLEncoder.encode(parameterName) + "=" + URLEncoder.encode(parameterValue));
            }
        }
        return StringUtils.join(requestParameterStrings.iterator(), (String)"&");
    }

    public static Collection collectImageDirectories() {
        ImcmsServices service = Imcms.getServices();
        File imagePath = service.getConfig().getImagePath();
        return FileUtility.collectRelativeSubdirectoriesStartingWith(imagePath);
    }

    public static Object firstElementOfSetByOrderOf(Set set, Comparator comparator) {
        TreeSet sortedSet = new TreeSet(comparator);
        sortedSet.addAll(set);
        return sortedSet.iterator().next();
    }

    public static boolean parameterIsSet(HttpServletRequest request, String parameter) {
        return null != request.getParameter(parameter);
    }

    public static int[] getParameterInts(HttpServletRequest request, String parameterName) {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (null == parameterValues) {
            return new int[0];
        }
        int[] parameterInts = new int[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            parameterInts[i] = Integer.parseInt(parameterValues[i]);
        }
        return parameterInts;
    }

    public static String getContents(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CollectingHttpServletResponse collectingHttpServletResponse = new CollectingHttpServletResponse(response);
        request.getRequestDispatcher(path).include((ServletRequest)request, (ServletResponse)collectingHttpServletResponse);
        return ((Object)((Object)collectingHttpServletResponse)).toString();
    }

    public static String formatDate(Date oneWeekAgo) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String formattedDate = dateFormat.format(oneWeekAgo);
        return formattedDate;
    }

    public static String formatUser(UserDomainObject user) {
        return StringEscapeUtils.escapeHtml((String)(user.getLastName() + ", " + user.getFirstName() + " (" + user.getLoginName() + ")"));
    }

    public static String getAbsolutePathToDocument(HttpServletRequest request, DocumentDomainObject document) {
        String documentPathPrefix = Imcms.getServices().getConfig().getDocumentPathPrefix();
        if (StringUtils.isBlank((String)documentPathPrefix)) {
            documentPathPrefix = "/servlet/GetDoc?meta_id=";
        }
        return request.getContextPath() + documentPathPrefix + document.getId();
    }

    public static String formatHtmlDatetime(Date datetime) {
        if (null == datetime) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'&nbsp;'HH:mm");
        return dateFormat.format(datetime);
    }

    public static void forwardToLogin(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        StringBuffer loginTarget = request.getRequestURL();
        String queryString = request.getQueryString();
        if (null != queryString) {
            loginTarget.append("?").append(queryString);
        }
        String noPermissionPage = "/imcms/" + user.getLanguageIso639_2() + "/login/" + NO_PERMISSION_URL + "?" + "next_url" + "=" + URLEncoder.encode(loginTarget.toString());
        response.setStatus(403);
        request.getRequestDispatcher(noPermissionPage).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static String[] getParameterValues(HttpServletRequest request, String parameterName) {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (null == parameterValues) {
            parameterValues = new String[]{};
        }
        return parameterValues;
    }

    public static Date truncateDateToMinutePrecision(Date fieldValue) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fieldValue);
        calendar.set(14, 0);
        calendar.set(13, 0);
        Date truncatedDate = calendar.getTime();
        return truncatedDate;
    }

    public static String getRequestURLWithoutPath(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        int requestUrlStartOfHost = requestUrl.indexOf("://") + 3;
        int requestUrlStartOfPath = requestUrl.indexOf(47, requestUrlStartOfHost);
        String requestUrlWithoutPath = StringUtils.left((String)requestUrl, (int)requestUrlStartOfPath);
        return requestUrlWithoutPath;
    }

    public static boolean throwableContainsMessageContaining(Throwable t, String s) {
        for (Throwable throwable = t; null != throwable; throwable = throwable.getCause()) {
            String message = throwable.getMessage();
            log.debug((Object)(throwable + ": " + message));
            if (null == message || -1 == message.indexOf(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean classIsSignedByCertificatesInKeyStore(Class clazz, KeyStore keyStore) {
        Object[] signers = clazz.getSigners();
        if (null == signers) {
            return false;
        }
        for (int i = 0; i < signers.length; ++i) {
            Object signer = signers[i];
            if (!(signer instanceof Certificate)) {
                return false;
            }
            Certificate certificate = (Certificate)signer;
            try {
                if (null != keyStore.getCertificateAlias(certificate)) continue;
                return false;
            }
            catch (KeyStoreException e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        return true;
    }
}

