/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.util.Map;

public class Parser {
    public static String parseDoc(String doc, String[] tags, String[] data) {
        if (doc == null) {
            return doc;
        }
        StringBuffer sb = new StringBuffer(doc);
        for (int i = 0; i < tags.length; ++i) {
            int length = tags[i].length();
            if (length <= 0) continue;
            int start = 0;
            while ((start = sb.toString().indexOf(tags[i], start)) != -1) {
                sb.replace(start, start + length, data[i] == null ? "" : data[i]);
                start += data[i].length();
            }
        }
        return sb.toString();
    }

    public static String parseDoc(String doc, String[] tagsAndData) {
        if (doc == null) {
            return doc;
        }
        StringBuffer sb = new StringBuffer(doc);
        Parser.parseDoc(sb, tagsAndData);
        return sb.toString();
    }

    public static void parseDoc(StringBuffer sb, String[] tagsAndData) {
        if (sb == null) {
            return;
        }
        for (int i = 0; i < tagsAndData.length; i += 2) {
            int length = tagsAndData[i].length();
            if (length <= 0) continue;
            String replacement = null == tagsAndData[i + 1] ? "" : tagsAndData[i + 1];
            int start = 0;
            while ((start = sb.toString().indexOf(tagsAndData[i], start)) != -1) {
                sb.replace(start, start + length, replacement);
                start += replacement.length();
            }
        }
    }

    public static StringBuffer parseTags(StringBuffer str, char tagdelim, String nontag, Map data, boolean removetaglikes, int recurse) {
        if (str == null || data == null) {
            return null;
        }
        if (nontag == null) {
            nontag = "";
        }
        int length = str.length();
        boolean intag = false;
        int tagindex = 0;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == tagdelim) {
                if (!intag) {
                    intag = true;
                    tagindex = i;
                    continue;
                }
                intag = false;
                Object replacement = data.get(str.substring(tagindex + 1, i));
                if (replacement == null) {
                    if (!removetaglikes) continue;
                    replacement = "";
                } else if (recurse > 0) {
                    replacement = Parser.parseTags(new StringBuffer(replacement.toString()), tagdelim, nontag, data, removetaglikes, recurse - 1).toString();
                }
                String replace = replacement.toString();
                str.replace(tagindex, i + 1, replace);
                i = tagindex + replace.length() - 1;
                length = str.length();
                continue;
            }
            if (nontag.indexOf(c) == -1) continue;
            intag = false;
        }
        return str;
    }
}

