/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.server.Imcms;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.oro.text.perl.Perl5Util;

public class Html {
    private static final Object[][] STATUS_TEMPLATE_PAIRS = new Object[][]{{DocumentDomainObject.LifeCyclePhase.NEW, "status/new.frag"}, {DocumentDomainObject.LifeCyclePhase.DISAPPROVED, "status/disapproved.frag"}, {DocumentDomainObject.LifeCyclePhase.PUBLISHED, "status/published.frag"}, {DocumentDomainObject.LifeCyclePhase.UNPUBLISHED, "status/unpublished.frag"}, {DocumentDomainObject.LifeCyclePhase.ARCHIVED, "status/archived.frag"}, {DocumentDomainObject.LifeCyclePhase.APPROVED, "status/approved.frag"}};

    private Html() {
    }

    public static String createOptionList(List allValues, List selectedValues) {
        StringBuffer htmlStr = new StringBuffer();
        HashSet selectedValuesSet = new HashSet(selectedValues);
        for (int i = 0; i < allValues.size(); i += 2) {
            String value = allValues.get(i).toString();
            String name = allValues.get(i + 1).toString();
            boolean valueSelected = selectedValuesSet.contains(value);
            htmlStr.append(Html.option(value, name, valueSelected));
        }
        return htmlStr.toString();
    }

    public static String createOptionList(Collection allValues, Object selectedValue, Transformer objectToStringPairTransformer) {
        return Html.createOptionList(allValues, Arrays.asList(selectedValue), objectToStringPairTransformer);
    }

    public static String createOptionList(Collection allValues, Collection selectedValues, Transformer objectToStringPairTransformer) {
        StringBuffer htmlStr = new StringBuffer();
        HashSet selectedValuesSet = null != selectedValues ? new HashSet(selectedValues) : new HashSet();
        Iterator iterator = allValues.iterator();
        while (iterator.hasNext()) {
            Object valueObject = iterator.next();
            String[] valueAndNameStringPair = (String[])objectToStringPairTransformer.transform(valueObject);
            String value = valueAndNameStringPair[0];
            String name = valueAndNameStringPair[1];
            boolean valueSelected = selectedValuesSet.contains(valueObject);
            htmlStr.append(Html.option(value, name, valueSelected));
        }
        return htmlStr.toString();
    }

    public static String createOptionList(String selected, List data) {
        return Html.createOptionList(data, Arrays.asList(selected));
    }

    public static String createOptionListOfCategoriesOfTypeForDocument(DocumentMapper documentMapper, CategoryTypeDomainObject categoryType, DocumentDomainObject document) {
        Object[] categories = documentMapper.getAllCategoriesOfType(categoryType);
        Arrays.sort(categories);
        CategoryDomainObject[] documentSelectedCategories = document.getCategoriesOfType(categoryType);
        Transformer categoryToStringPairTransformer = new Transformer(){

            public Object transform(Object o) {
                CategoryDomainObject category = (CategoryDomainObject)o;
                return new String[]{"" + category.getId(), category.getName()};
            }
        };
        String categoryOptionList = Html.createOptionList(Arrays.asList(categories), Arrays.asList(documentSelectedCategories), categoryToStringPairTransformer);
        if (1 == categoryType.getMaxChoices()) {
            categoryOptionList = "<option></option>" + categoryOptionList;
        }
        return categoryOptionList;
    }

    public static String getLinkedStatusIconTemplate(DocumentDomainObject document, UserDomainObject user, HttpServletRequest request) {
        String statusIconTemplate = Html.getStatusIconTemplate(document, user);
        if (user.canEditDocumentInformationFor(document)) {
            statusIconTemplate = "<a href=\"" + request.getContextPath() + "/servlet/AdminDoc?meta_id=" + document.getId() + "&" + "flags" + "=1\" target=\"_blank\">" + statusIconTemplate + "</a>";
        }
        return statusIconTemplate;
    }

    public static String getStatusIconTemplate(DocumentDomainObject document, UserDomainObject user) {
        DocumentDomainObject.LifeCyclePhase lifeCyclePhase = document.getLifeCyclePhase();
        String statusIconTemplateName = null;
        for (int i = 0; i < STATUS_TEMPLATE_PAIRS.length; ++i) {
            Object[] statusTemplatePair = STATUS_TEMPLATE_PAIRS[i];
            if (!lifeCyclePhase.equals(statusTemplatePair[0])) continue;
            statusIconTemplateName = (String)statusTemplatePair[1];
            break;
        }
        return Imcms.getServices().getAdminTemplate(statusIconTemplateName, user, null);
    }

    public static String option(String elementValue, String content, boolean selected) {
        StringBuffer option = new StringBuffer();
        option.append("<option value=\"" + StringEscapeUtils.escapeHtml((String)elementValue) + "\"");
        if (selected) {
            option.append(" selected");
        }
        option.append(">" + StringEscapeUtils.escapeHtml((String)content) + "</option>");
        return option.toString();
    }

    public static String hidden(String name, String value) {
        return "<input type=\"hidden\" name=\"" + StringEscapeUtils.escapeHtml((String)name) + "\" value=\"" + StringEscapeUtils.escapeHtml((String)value) + "\">";
    }

    public static String radio(String name, String value, boolean selected) {
        return "<input type=\"radio\" name=\"" + StringEscapeUtils.escapeHtml((String)name) + "\" value=\"" + StringEscapeUtils.escapeHtml((String)value) + "\"" + (selected ? " checked" : "") + ">";
    }

    public static String getAdminButtons(UserDomainObject user, DocumentDomainObject document, HttpServletRequest request, HttpServletResponse response) {
        if (!(user.canEdit(document) || user.isUserAdmin() || user.canAccessAdminPages())) {
            return "";
        }
        try {
            request.setAttribute("document", (Object)document);
            request.setAttribute("user", (Object)user);
            return Utility.getContents("/imcms/" + user.getLanguageIso639_2() + "/jsp/admin/adminbuttons.jsp", request, response);
        }
        catch (ServletException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public static String removeTags(String html) {
        Perl5Util perl5util = new Perl5Util();
        String label_urlparam = perl5util.substitute("s!<.+?>!!g", html);
        return label_urlparam;
    }
}

