/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.parser.MenuParser;
import imcode.server.parser.MockParserParameters;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.Date;
import junit.framework.TestCase;

public class TestMenuParser
extends TestCase {
    private MenuParser menuParser;
    private MockParserParameters parserParameters;
    private UserDomainObject user;
    private TextDocumentDomainObject textDocument;
    private RoleDomainObject editRole;
    private static final int MENU_INDEX = 1;

    protected void setUp() throws Exception {
        this.user = new UserDomainObject();
        this.textDocument = new TextDocumentDomainObject();
        this.editRole = new RoleDomainObject("Editrole");
        this.textDocument.setPermissionSetIdForRole(this.editRole, 0);
        this.parserParameters = new MockParserParameters(null);
        this.menuParser = new MenuParser(this.parserParameters);
    }

    public void testUserCantSeeUnpublishedDocumentInMenuWithoutPermissions() throws Exception {
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testUserCantSeePublishedDocumentInMenuWithoutPermissions() {
        this.textDocument.setPublicationStartDatetime(new Date(0L));
        this.textDocument.setStatus(2);
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testUserCantSeeUnpublishedDocumentInMenuWithPermissions() {
        this.textDocument.setPermissionSetIdForRole(RoleDomainObject.USERS, 3);
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testUserCanSeePublishedDocumentInMenuWithPermissions() {
        this.textDocument.setPermissionSetIdForRole(RoleDomainObject.USERS, 3);
        this.textDocument.setPublicationStartDatetime(new Date(0L));
        this.assertCanNotSeeDocumentInMenu();
        this.textDocument.setStatus(2);
        this.assertCanSeeDocumentInMenu();
    }

    public void testAdminCantSeeUnpublishedDocumentWhenInMenuModeButNotEditingMenu() {
        this.user.addRole(this.editRole);
        this.parserParameters.setMenuMode(true);
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testAdminCantSeeUnpublishedDocumentWhenNotInMenuModeButEditingMenu() {
        this.user.addRole(this.editRole);
        this.parserParameters.setEditingMenuIndex(new Integer(1));
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testAdminCanSeeUnpublishedDocumentWhenEditing() {
        this.user.addRole(this.editRole);
        this.parserParameters.setEditingMenuIndex(new Integer(1));
        this.parserParameters.setMenuMode(true);
        this.assertCanSeeDocumentInMenu();
    }

    public void testUserCantSeeUnpublishedDocumentInMenuWhenEditing() throws Exception {
        this.parserParameters.setEditingMenuIndex(new Integer(1));
        this.parserParameters.setMenuMode(true);
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testUserCanSeePublishedDocumentsVisibleForUnauthorizedUsers() {
        this.textDocument.setVisibleInMenusForUnauthorizedUsers(true);
        this.assertCanNotSeeDocumentInMenu();
        this.textDocument.setPublicationStartDatetime(new Date(0L));
        this.textDocument.setStatus(2);
        this.assertCanSeeDocumentInMenu();
    }

    private void assertCanNotSeeDocumentInMenu() {
        TestMenuParser.assertFalse((boolean)this.menuParser.userCanSeeDocumentInMenu(this.user, this.textDocument, 1));
    }

    private void assertCanSeeDocumentInMenu() {
        TestMenuParser.assertTrue((boolean)this.menuParser.userCanSeeDocumentInMenu(this.user, this.textDocument, 1));
    }
}

