/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import imcode.server.DocumentRequest;
import imcode.server.document.DocumentPermission;
import imcode.server.document.TextDocumentPermissionSetDomainObject;

public class ParserParameters
implements Cloneable {
    private String template;
    private String param;
    private String externalParam;
    private Integer editingMenuIndex;
    private DocumentRequest documentRequest;
    private int flags;
    private boolean adminButtonsVisible = true;

    public ParserParameters(DocumentRequest documentRequest) {
        this.documentRequest = documentRequest;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setParameter(String param) {
        this.param = param;
    }

    public void setExternalParameter(String externalparam) {
        this.externalParam = externalparam;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getParameter() {
        return this.param == null ? "" : this.param;
    }

    public String getExternalParameter() {
        return this.externalParam == null ? "" : this.externalParam;
    }

    public Integer getEditingMenuIndex() {
        return this.editingMenuIndex;
    }

    public void setEditingMenuIndex(Integer editingMenuIndex) {
        this.editingMenuIndex = editingMenuIndex;
    }

    public DocumentRequest getDocumentRequest() {
        return this.documentRequest;
    }

    public void setDocumentRequest(DocumentRequest documentRequest) {
        this.documentRequest = documentRequest;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Object clone() throws CloneNotSupportedException {
        ParserParameters clone = (ParserParameters)super.clone();
        clone.documentRequest = (DocumentRequest)this.documentRequest.clone();
        return clone;
    }

    public void setAdminButtonsVisible(boolean adminButtonsVisible) {
        this.adminButtonsVisible = adminButtonsVisible;
    }

    public boolean isAdminButtonsVisible() {
        return this.adminButtonsVisible;
    }

    private TextDocumentPermissionSetDomainObject getPermissionSet() {
        return (TextDocumentPermissionSetDomainObject)this.documentRequest.getUser().getPermissionSetFor(this.documentRequest.getDocument());
    }

    public boolean isTextMode() {
        return this.isMode(65536, TextDocumentPermissionSetDomainObject.EDIT_TEXTS);
    }

    public boolean isMenuMode() {
        return this.isMode(262144, TextDocumentPermissionSetDomainObject.EDIT_MENUS);
    }

    public boolean isImageMode() {
        return this.isMode(131072, TextDocumentPermissionSetDomainObject.EDIT_IMAGES);
    }

    public boolean isIncludesMode() {
        return this.isMode(0x100000, TextDocumentPermissionSetDomainObject.EDIT_INCLUDES);
    }

    public boolean isTemplateMode() {
        return this.isMode(524288, TextDocumentPermissionSetDomainObject.EDIT_TEMPLATE);
    }

    private boolean isMode(int flag, DocumentPermission permission) {
        return (this.flags & flag) != 0 && this.getPermissionSet().hasPermission(permission);
    }

    public boolean isAnyMode() {
        return this.isTextMode() || this.isImageMode() || this.isMenuMode() || this.isIncludesMode() || this.isTemplateMode();
    }
}

