/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import imcode.server.DocumentRequest;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.parser.Element;
import imcode.server.parser.MapSubstitution;
import imcode.server.parser.Node;
import imcode.server.parser.NodeList;
import imcode.server.parser.ParserParameters;
import imcode.server.parser.SimpleElement;
import imcode.server.parser.TagParser;
import imcode.server.parser.Text;
import imcode.server.parser.TextDocumentParser;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.IdNamePair;
import imcode.util.Utility;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

class MenuParser {
    private Substitution NULLSUBSTITUTION = new StringSubstitution("");
    private int[] implicitMenus = new int[]{1};
    private ParserParameters parserParameters;
    private static final int EXISTING_DOCTYPE_ID = 0;

    MenuParser(ParserParameters parserParameters) {
        this.parserParameters = parserParameters;
    }

    private MenuDomainObject getMenuByIndex(int index) {
        MenuDomainObject menu = ((TextDocumentDomainObject)this.parserParameters.getDocumentRequest().getDocument()).getMenu(index);
        if (null == menu) {
            menu = new MenuDomainObject();
        }
        return menu;
    }

    private String getMenuModePrefix(int menuIndex, List parseTags) {
        ImcmsServices services = this.parserParameters.getDocumentRequest().getServices();
        UserDomainObject user = this.parserParameters.getDocumentRequest().getUser();
        Integer editingMenuIndex = this.parserParameters.getEditingMenuIndex();
        String result = services.getAdminTemplate("textdoc/menulabel.frag", user, parseTags);
        if (null != editingMenuIndex && editingMenuIndex == menuIndex) {
            result = result + services.getAdminTemplate("textdoc/add_doc.html", user, parseTags) + services.getAdminTemplate("textdoc/sort_order.html", user, parseTags);
        }
        return result;
    }

    private List createParseTags(int menuIndex, Properties menuattributes) {
        MenuDomainObject menu = this.getMenuByIndex(menuIndex);
        DocumentRequest documentRequest = this.parserParameters.getDocumentRequest();
        MenuItemDomainObject[] menuItems = menu.getMenuItemsUserCanSee(documentRequest.getUser());
        ImcmsAuthenticatorAndUserAndRoleMapper userMapper = documentRequest.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
        UserDomainObject defaultUser = userMapper.getDefaultUser();
        MenuItemDomainObject[] defaultUserMenuItems = menu.getPublishedMenuItemsUserCanSee(defaultUser);
        List<String> parseTags = Arrays.asList("#menuindex#", "" + menuIndex, "#menuitemcount#", "" + menuItems.length, "#defaultusermenuitemcount#", "" + defaultUserMenuItems.length, "#label#", menuattributes.getProperty("label"), "#flags#", "" + this.parserParameters.getFlags(), "#sortOrder" + (null != menu ? menu.getSortOrder() : 1) + "#", " selected", "#doc_types#", this.createDocumentTypesOptionList(), "#meta_id#", "" + documentRequest.getDocument().getId(), "#defaulttemplate#", URLEncoder.encode(StringUtils.defaultString((String)menuattributes.getProperty("defaulttemplate"))));
        return parseTags;
    }

    private String getMenuModeSuffix(int menuIndex, List parseTags) {
        Integer editingMenuIndex = this.parserParameters.getEditingMenuIndex();
        ImcmsServices services = this.parserParameters.getDocumentRequest().getServices();
        if (null != editingMenuIndex && editingMenuIndex == menuIndex) {
            return services.getAdminTemplate("textdoc/archive_del_button.html", this.parserParameters.getDocumentRequest().getUser(), null);
        }
        return services.getAdminTemplate("textdoc/admin_menu.frag", this.parserParameters.getDocumentRequest().getUser(), parseTags);
    }

    private String createDocumentTypesOptionList() {
        DocumentDomainObject document = this.parserParameters.getDocumentRequest().getDocument();
        UserDomainObject user = this.parserParameters.getDocumentRequest().getUser();
        IdNamePair[] docTypes = this.parserParameters.getDocumentRequest().getServices().getDocumentMapper().getCreatableDocumentTypeIdsAndNamesInUsersLanguage(document, user);
        HashMap<Integer, IdNamePair> docTypesMap = new HashMap<Integer, IdNamePair>();
        for (int i = 0; i < docTypes.length; ++i) {
            IdNamePair docType = docTypes[i];
            docTypesMap.put(new Integer(docType.getId()), docType);
        }
        String existing_doc_name = this.parserParameters.getDocumentRequest().getServices().getAdminTemplate("textdoc/existing_doc_name.html", this.parserParameters.getDocumentRequest().getUser(), null);
        docTypesMap.put(new Integer(0), new IdNamePair(0, existing_doc_name));
        int[] docTypeIdsOrder = new int[]{2, 0, 5, 8, 6, 7, 103, 104, 102};
        StringBuffer documentTypesHtmlOptionList = new StringBuffer();
        for (int i = 0; i < docTypeIdsOrder.length; ++i) {
            int docTypeId = docTypeIdsOrder[i];
            IdNamePair temp = (IdNamePair)docTypesMap.get(new Integer(docTypeId));
            if (null == temp) continue;
            int documentTypeId = temp.getId();
            String documentTypeName = temp.getName();
            documentTypesHtmlOptionList.append("<option value=\"" + documentTypeId + "\">" + documentTypeName + "</option>");
        }
        return documentTypesHtmlOptionList.toString();
    }

    private String parseMenuNode(int menuIndex, String menutemplate, Properties menuattributes, PatternMatcher patMat, TagParser tagParser) {
        String modeAttribute = menuattributes.getProperty("mode");
        boolean modeIsRead = "read".equalsIgnoreCase(modeAttribute);
        boolean modeIsWrite = "write".equalsIgnoreCase(modeAttribute);
        boolean menuMode = this.parserParameters.isMenuMode();
        if (menuMode && modeIsRead || !menuMode && modeIsWrite) {
            return "";
        }
        MenuDomainObject currentMenu = this.getMenuByIndex(menuIndex);
        StringBuffer result = new StringBuffer();
        NodeList menuNodes = new NodeList(menutemplate, this.parserParameters.getDocumentRequest().getHttpServletRequest(), tagParser);
        this.nodeMenu(new SimpleElement("menu", menuattributes, menuNodes), result, currentMenu, patMat, menuIndex, tagParser);
        if (menuMode) {
            List parseTags = this.createParseTags(menuIndex, menuattributes);
            result.append(this.getMenuModeSuffix(menuIndex, parseTags));
            result.insert(0, this.getMenuModePrefix(menuIndex, parseTags));
        }
        return result.toString();
    }

    private void nodeMenu(Element menuNode, StringBuffer result, MenuDomainObject currentMenu, PatternMatcher patMat, int menuIndex, TagParser tagParser) {
        if (currentMenu == null || 0 == currentMenu.getMenuItems().length) {
            return;
        }
        Properties menuAttributes = menuNode.getAttributes();
        if (menuNode.getChildElement("menuloop") == null) {
            this.nodeMenuLoop(new SimpleElement("menuloop", null, menuNode.getChildren()), result, currentMenu, menuAttributes, patMat, menuIndex, tagParser);
        } else {
            Iterator menuNodeChildrenIterator = menuNode.getChildren().iterator();
            while (menuNodeChildrenIterator.hasNext()) {
                Node menuNodeChild = (Node)menuNodeChildrenIterator.next();
                switch (menuNodeChild.getNodeType()) {
                    case 0: {
                        result.append(tagParser.replaceTags(patMat, ((Text)menuNodeChild).getContent()));
                        break;
                    }
                    case 1: {
                        if ("menuloop".equals(((Element)menuNodeChild).getName())) {
                            this.nodeMenuLoop((Element)menuNodeChild, result, currentMenu, menuAttributes, patMat, menuIndex, tagParser);
                            break;
                        }
                        result.append(tagParser.replaceTags(patMat, menuNodeChild.toString()));
                    }
                }
            }
        }
    }

    private void nodeMenuLoop(Element menuLoopNode, StringBuffer result, MenuDomainObject menu, Properties menuAttributes, PatternMatcher patMat, int menuIndex, TagParser tagParser) {
        if (null == menu) {
            return;
        }
        ArrayList<SimpleElement> menuLoopNodeChildren = menuLoopNode.getChildren();
        if (null == menuLoopNode.getChildElement("menuitem")) {
            SimpleElement menuItemNode = new SimpleElement("menuitem", null, menuLoopNodeChildren);
            menuLoopNodeChildren = new ArrayList<SimpleElement>(1);
            menuLoopNodeChildren.add(menuItemNode);
        }
        this.loopOverMenuItemsAndMenuItemTemplateElementsAndAddToResult(menu, menuLoopNodeChildren, result, menuAttributes, patMat, menuIndex, tagParser);
    }

    private boolean editingMenu(int menuIndex) {
        Integer editingMenuIndex = this.parserParameters.getEditingMenuIndex();
        boolean editingThisMenu = null != editingMenuIndex && editingMenuIndex == menuIndex && this.parserParameters.isMenuMode();
        return editingThisMenu;
    }

    private void loopOverMenuItemsAndMenuItemTemplateElementsAndAddToResult(MenuDomainObject menu, List menuLoopNodeChildren, StringBuffer result, Properties menuAttributes, PatternMatcher patMat, final int menuIndex, TagParser tagParser) {
        FilterIterator menuItemsIterator = new FilterIterator(Arrays.asList(menu.getMenuItems()).iterator(), new Predicate(){

            public boolean evaluate(Object o) {
                DocumentDomainObject document = ((MenuItemDomainObject)o).getDocument();
                UserDomainObject user = MenuParser.this.parserParameters.getDocumentRequest().getUser();
                return MenuParser.this.userCanSeeDocumentInMenu(user, document, menuIndex);
            }
        });
        int menuItemIndexStart = 0;
        try {
            menuItemIndexStart = Integer.parseInt(menuAttributes.getProperty("indexstart"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int menuItemIndexStep = 1;
        try {
            menuItemIndexStep = Integer.parseInt(menuAttributes.getProperty("indexstep"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int menuItemIndex = menuItemIndexStart;
        while (menuItemsIterator.hasNext()) {
            Iterator menuLoopChildrenIterator = menuLoopNodeChildren.iterator();
            while (menuLoopChildrenIterator.hasNext()) {
                Node menuLoopChild = (Node)menuLoopChildrenIterator.next();
                switch (menuLoopChild.getNodeType()) {
                    case 0: {
                        result.append(tagParser.replaceTags(patMat, ((Text)menuLoopChild).getContent()));
                        break;
                    }
                    case 1: {
                        if ("menuitem".equals(((Element)menuLoopChild).getName())) {
                            MenuItemDomainObject menuItem = menuItemsIterator.hasNext() ? (MenuItemDomainObject)menuItemsIterator.next() : null;
                            this.nodeMenuItem((Element)menuLoopChild, result, menuItem, menuAttributes, patMat, menuItemIndex, menu, menuIndex, tagParser);
                            menuItemIndex += menuItemIndexStep;
                            break;
                        }
                        result.append(tagParser.replaceTags(patMat, menuLoopChild.toString()));
                    }
                }
            }
        }
    }

    boolean userCanSeeDocumentInMenu(UserDomainObject user, DocumentDomainObject document, int menuIndex) {
        return user.canSeeDocumentInMenus(document) || this.editingMenu(menuIndex) && user.canSeeDocumentWhenEditingMenus(document);
    }

    private void nodeMenuItem(Element menuItemNode, StringBuffer result, MenuItemDomainObject menuItem, Properties menuAttributes, PatternMatcher patMat, int menuItemIndex, MenuDomainObject menu, int menuIndex, TagParser tagParser) {
        Substitution menuItemSubstitution;
        if (menuItem != null) {
            Properties menuItemAttributes = new Properties(menuAttributes);
            menuItemAttributes.putAll((Map<?, ?>)menuItemNode.getAttributes());
            menuItemSubstitution = this.getMenuItemSubstitution(menu, menuItem, menuItemAttributes, menuItemIndex, menuIndex);
        } else {
            menuItemSubstitution = this.NULLSUBSTITUTION;
        }
        Iterator menuItemChildrenIterator = menuItemNode.getChildren().iterator();
        while (menuItemChildrenIterator.hasNext()) {
            Node menuItemChild = (Node)menuItemChildrenIterator.next();
            switch (menuItemChild.getNodeType()) {
                case 1: {
                    Element menuItemChildElement = (Element)menuItemChild;
                    if ("menuitemhide".equals(menuItemChildElement.getName()) && menuItem == null) break;
                    this.parseMenuItem(result, menuItemChildElement.getTextContent(), menuItemSubstitution, patMat, tagParser);
                    break;
                }
                case 0: {
                    this.parseMenuItem(result, ((Text)menuItemChild).getContent(), menuItemSubstitution, patMat, tagParser);
                }
            }
        }
    }

    private void parseMenuItem(StringBuffer result, String template, Substitution substitution, PatternMatcher patMat, TagParser tagParser) {
        String tagsReplaced = tagParser.replaceTags(patMat, template);
        result.append(Util.substitute((PatternMatcher)patMat, (Pattern)TextDocumentParser.HASHTAG_PATTERN, (Substitution)substitution, (String)tagsReplaced, (int)-1));
    }

    public String tag(Properties menuattributes, String menutemplate, PatternMatcher patMat, TagParser tagParser) {
        int menuIndex;
        try {
            menuIndex = Integer.parseInt(menuattributes.getProperty("no"));
        }
        catch (NumberFormatException ex) {
            int n = this.implicitMenus[0];
            this.implicitMenus[0] = n + 1;
            menuIndex = n;
        }
        return this.parseMenuNode(menuIndex, menutemplate, menuattributes, patMat, tagParser);
    }

    private Substitution getMenuItemSubstitution(MenuDomainObject menu, MenuItemDomainObject menuItem, Properties parameters, int menuItemIndex, int menuIndex) {
        DocumentDomainObject document = menuItem.getDocument();
        String imageUrl = document.getMenuImage();
        String imageTag = imageUrl != null && imageUrl.length() > 0 ? "<img src=\"" + StringEscapeUtils.escapeHtml((String)imageUrl) + "\" border=\"0\">" : "";
        String headline = document.getHeadline();
        if (StringUtils.isBlank((String)headline)) {
            headline = "&nbsp;";
        } else {
            if (!document.isPublished()) {
                headline = "<em><i>" + headline;
                headline = headline + "</i></em>";
            }
            if (document.isArchived()) {
                headline = "<strike>" + headline;
                headline = headline + "</strike>";
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String createdDate = dateFormat.format(document.getCreatedDatetime());
        String modifiedDate = dateFormat.format(document.getModifiedDatetime());
        Properties tags = new Properties();
        tags.setProperty("#childMetaId#", "" + document.getId());
        tags.setProperty("#childMetaHeadline#", headline);
        tags.setProperty("#childMetaText#", document.getMenuText());
        tags.setProperty("#childMetaImage#", imageTag);
        tags.setProperty("#childCreatedDate#", createdDate);
        tags.setProperty("#childModifiedDate#", modifiedDate);
        tags.setProperty("#menuitemindex#", "" + menuItemIndex);
        tags.setProperty("#menuitemtreesortkey#", menuItem.getTreeSortKey().toString());
        tags.setProperty("#menuitemmetaid#", "" + document.getId());
        tags.setProperty("#menuitemheadline#", headline);
        tags.setProperty("#menuitemtext#", document.getMenuText());
        tags.setProperty("#menuitemimage#", imageTag);
        tags.setProperty("#menuitemimageurl#", StringEscapeUtils.escapeHtml((String)imageUrl));
        tags.setProperty("#menuitemtarget#", document.getTarget());
        tags.setProperty("#menuitemdatecreated#", createdDate);
        tags.setProperty("#menuitemdatemodified#", modifiedDate);
        DocumentRequest documentRequest = this.parserParameters.getDocumentRequest();
        String template = parameters.getProperty("template");
        String href = Utility.getAbsolutePathToDocument(documentRequest.getHttpServletRequest(), document);
        if (null != template) {
            href = href + (-1 != href.indexOf(63) ? (char)'&' : '?');
            href = href + "template=" + URLEncoder.encode(template);
        }
        ArrayList<String> menuItemAHref = new ArrayList<String>(4);
        menuItemAHref.add("#href#");
        menuItemAHref.add(href);
        menuItemAHref.add("#target#");
        menuItemAHref.add(document.getTarget());
        UserDomainObject user = documentRequest.getUser();
        ImcmsServices serverObject = documentRequest.getServices();
        String a_href = serverObject.getAdminTemplate("textdoc/menuitem_a_href.frag", user, menuItemAHref);
        tags.setProperty("#menuitemlinkonly#", a_href);
        tags.setProperty("#/menuitemlinkonly#", "</a>");
        boolean editingThisMenu = this.editingMenu(menuIndex);
        if (editingThisMenu) {
            int sortOrder = menu.getSortOrder();
            if (2 == sortOrder || 4 == sortOrder) {
                String sortKeyTemplate;
                String sortKey;
                if (2 == sortOrder) {
                    sortKey = "" + menuItem.getSortKey();
                    sortKeyTemplate = "textdoc/admin_menuitem_manual_sortkey.frag";
                } else {
                    String key = menuItem.getTreeSortKey().toString();
                    sortKey = key == null ? "" : key;
                    sortKeyTemplate = "textdoc/admin_menuitem_treesortkey.frag";
                }
                ArrayList<String> menuItemSortKeyTags = new ArrayList<String>(4);
                menuItemSortKeyTags.add("#meta_id#");
                menuItemSortKeyTags.add("" + document.getId());
                menuItemSortKeyTags.add("#sortkey#");
                menuItemSortKeyTags.add(sortKey);
                a_href = serverObject.getAdminTemplate(sortKeyTemplate, user, menuItemSortKeyTags) + a_href;
            }
            ArrayList<String> menuItemCheckboxTags = new ArrayList<String>(2);
            menuItemCheckboxTags.add("#meta_id#");
            menuItemCheckboxTags.add("" + document.getId());
            a_href = serverObject.getAdminTemplate("textdoc/admin_menuitem_checkbox.frag", user, menuItemCheckboxTags) + a_href;
            a_href = Html.getLinkedStatusIconTemplate(menuItem.getDocument(), user, documentRequest.getHttpServletRequest()) + a_href;
        }
        tags.setProperty("#menuitemlink#", a_href);
        tags.setProperty("#/menuitemlink#", editingThisMenu && user.canEdit(menuItem.getDocument()) ? "</a>" + serverObject.getAdminTemplate("textdoc/admin_menuitem.frag", user, Arrays.asList("#meta_id#", "" + document.getId())) : "</a>");
        return new MapSubstitution(tags, true);
    }
}

