/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import imcode.util.Parser;
import java.io.Serializable;

public class TextDomainObject
implements Serializable {
    String text;
    int type;
    public static final int TEXT_TYPE_PLAIN = 0;
    public static final int TEXT_TYPE_HTML = 1;

    public TextDomainObject(String text, int type) {
        this.setText(text);
        this.setType(type);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        switch (type) {
            case 0: 
            case 1: {
                this.type = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal text-type.");
            }
        }
    }

    public String toString() {
        return this.getText();
    }

    public String toHtmlString() {
        String result = this.getText();
        if (this.getType() == 0) {
            String[] vp = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\"", "&quot;", "\r\n", "\n", "\r", "\n", "\n", "<BR>\n"};
            result = Parser.parseDoc(result, vp);
        }
        return result;
    }
}

