/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import imcode.server.Config;
import imcode.server.db.MockDatabase;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentReference;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.List;
import junit.framework.TestCase;

public class TestMenuDomainObject
extends TestCase {
    private MenuDomainObject menu;
    private UserDomainObject user;

    protected void setUp() throws Exception {
        super.setUp();
        this.user = new UserDomainObject();
        this.user.addRole(RoleDomainObject.SUPERADMIN);
        this.menu = new MenuDomainObject();
        MockDatabase database = new MockDatabase();
        DocumentMapper documentMapper = new DocumentMapper(null, database, null, null, null, null, new Config()){

            public DocumentDomainObject getDocument(int metaId) {
                if (1002 == metaId) {
                    TextDocumentDomainObject textDocument = new TextDocumentDomainObject();
                    return textDocument;
                }
                return super.getDocument(metaId);
            }
        };
        this.menu.addMenuItem(new MenuItemDomainObject(new DocumentReference(1001, documentMapper)));
        this.menu.addMenuItem(new MenuItemDomainObject(new DocumentReference(1002, documentMapper)));
    }

    public void testGetMenuItems() {
        MenuItemDomainObject[] menuItems = this.menu.getMenuItems();
        TestMenuDomainObject.assertEquals((int)1, (int)menuItems.length);
    }

    public void testGetMenuItemsVisibleToUser() {
        List menuItemsVisibleToUser = this.menu.getMenuItemsVisibleToUser(this.user);
        TestMenuDomainObject.assertEquals((int)1, (int)menuItemsVisibleToUser.size());
    }
}

