/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.MockImcmsServices;
import imcode.server.db.MockDatabase;
import imcode.server.document.DocumentPermissionSetMapper;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import junit.framework.TestCase;

public class TestDocumentPermissionSetMapper
extends TestCase {
    private DocumentPermissionSetMapper documentPermissionSetMapper;
    private TextDocumentPermissionSetDomainObject textDocumentPermissionSet;
    private MockDatabase database;
    private TextDocumentDomainObject textDocument;

    public void setUp() throws Exception {
        super.setUp();
        this.database = new MockDatabase();
        this.documentPermissionSetMapper = new DocumentPermissionSetMapper(this.database, new MockImcmsServices());
        this.textDocument = new TextDocumentDomainObject();
        this.textDocumentPermissionSet = new TextDocumentPermissionSetDomainObject(1);
    }

    public void testSetTextDocumentPermissionSetFromBits() throws Exception {
        this.database.addExpectedSqlCall(new MockDatabase.EqualsSqlCallPredicate("GetTemplateGroupsWithPermissions"), new String[0][0]);
        this.database.addExpectedSqlCall(new MockDatabase.StartsWithSqlCallPredicate("SELECT permission_data FROM "), new String[0]);
        this.documentPermissionSetMapper.setTextDocumentPermissionSetFromBits(this.textDocument, this.textDocumentPermissionSet, 65536, false);
        TestDocumentPermissionSetMapper.assertTrue((boolean)this.textDocumentPermissionSet.getEditTexts());
    }

    public void testSaveRestrictedTextDocumentPermissionSet() {
        this.documentPermissionSetMapper.saveRestrictedDocumentPermissionSet(this.textDocument, this.textDocumentPermissionSet, false);
        this.database.assertCalled(new MockDatabase.EqualsWithParameterSqlCallPredicate("SetDocPermissionSet", "0"));
        this.textDocumentPermissionSet.setEditTexts(true);
        this.documentPermissionSetMapper.saveRestrictedDocumentPermissionSet(this.textDocument, this.textDocumentPermissionSet, false);
        this.database.assertCalled(new MockDatabase.EqualsWithParameterSqlCallPredicate("SetDocPermissionSet", "65536"));
    }
}

