/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.util.InputStreamSource;
import imcode.util.Utility;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.UnhandledException;

public class FileDocumentDomainObject
extends DocumentDomainObject {
    private Map files = this.createFilesMap();
    private String defaultFileId;
    public static final String MIME_TYPE__APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_TYPE__UNKNOWN_DEFAULT = "application/octet-stream";

    public DocumentTypeDomainObject getDocumentType() {
        return DocumentTypeDomainObject.FILE;
    }

    public void accept(DocumentVisitor documentVisitor) {
        documentVisitor.visitFileDocument(this);
    }

    public void addFile(String fileId, FileDocumentFile file) {
        if (null == fileId) {
            throw new NullArgumentException("fileId");
        }
        if (!this.files.containsKey(this.defaultFileId)) {
            this.defaultFileId = fileId;
        }
        FileDocumentFile fileClone = this.cloneFile(file);
        fileClone.setId(fileId);
        this.files.put(fileId, fileClone);
    }

    private FileDocumentFile cloneFile(FileDocumentFile file) {
        FileDocumentFile fileClone;
        if (null == file) {
            return null;
        }
        try {
            fileClone = (FileDocumentFile)file.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnhandledException((Throwable)e);
        }
        return fileClone;
    }

    public Map getFiles() {
        Map map = this.createFilesMap();
        map.putAll(this.files);
        return map;
    }

    private Map createFilesMap() {
        return MapUtils.orderedMap(new HashMap());
    }

    public FileDocumentFile getFile(String fileId) {
        return this.cloneFile((FileDocumentFile)this.files.get(fileId));
    }

    public FileDocumentFile removeFile(String fileId) {
        FileDocumentFile fileDocumentFile = (FileDocumentFile)this.files.remove(fileId);
        this.selectDefaultFileName(fileId);
        return fileDocumentFile;
    }

    private void selectDefaultFileName(String fileId) {
        if (this.files.isEmpty()) {
            this.defaultFileId = null;
        } else if (this.defaultFileId.equals(fileId)) {
            this.defaultFileId = (String)Utility.firstElementOfSetByOrderOf(this.files.keySet(), String.CASE_INSENSITIVE_ORDER);
        }
    }

    public void setDefaultFileId(String defaultFileId) {
        if (!this.files.containsKey(defaultFileId)) {
            throw new IllegalArgumentException("Cannot set defaultFileId to non-existant key " + defaultFileId);
        }
        this.defaultFileId = defaultFileId;
    }

    public String getDefaultFileId() {
        return this.defaultFileId;
    }

    public FileDocumentFile getFileOrDefault(String fileId) {
        if (null == fileId) {
            return this.getDefaultFile();
        }
        FileDocumentFile fileDocumentFile = this.getFile(fileId);
        if (null == fileDocumentFile) {
            fileDocumentFile = this.getDefaultFile();
        }
        return fileDocumentFile;
    }

    public FileDocumentFile getDefaultFile() {
        return this.getFile(this.defaultFileId);
    }

    public void changeFileId(String oldFileId, String newFileId) {
        if (null == oldFileId) {
            throw new NullArgumentException("oldFileId");
        }
        if (null == newFileId) {
            throw new NullArgumentException("newFileId");
        }
        if (!this.files.containsKey(oldFileId)) {
            throw new IllegalStateException("There is no file with the id " + oldFileId);
        }
        if (oldFileId.equals(newFileId)) {
            return;
        }
        if (this.files.containsKey(newFileId)) {
            throw new IllegalStateException("There already is a file with the id " + newFileId);
        }
        this.addFile(newFileId, (FileDocumentFile)this.files.remove(oldFileId));
        if (this.defaultFileId.equals(oldFileId)) {
            this.defaultFileId = newFileId;
        }
    }

    public static class FileDocumentFile
    implements Cloneable,
    Serializable {
        private String id;
        private String filename;
        private String mimeType;
        private InputStreamSource inputStreamSource;
        private boolean createdAsImage;

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String v) {
            this.filename = v;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setInputStreamSource(InputStreamSource inputStreamSource) {
            this.inputStreamSource = inputStreamSource;
        }

        public InputStreamSource getInputStreamSource() {
            return this.inputStreamSource;
        }

        public void setCreatedAsImage(boolean createdAsImage) {
            this.createdAsImage = createdAsImage;
        }

        public boolean isCreatedAsImage() {
            return this.createdAsImage;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

