/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.db.Database;
import imcode.server.db.DatabaseCommand;
import imcode.server.db.DatabaseConnection;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentStoringVisitor;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import org.apache.log4j.Logger;

public class DocumentSavingVisitor
extends DocumentStoringVisitor {
    private static final Logger log = Logger.getLogger((String)DocumentSavingVisitor.class.getName());
    private DocumentDomainObject oldDocument;

    public DocumentSavingVisitor(UserDomainObject user, DocumentDomainObject documentInDatabase, Database database) {
        super(user, database);
        this.oldDocument = documentInDatabase;
    }

    public void visitHtmlDocument(HtmlDocumentDomainObject htmlDocument) {
        String sqlStr = "UPDATE frameset_docs SET frame_set = ? WHERE meta_id = ?";
        this.database.sqlUpdateQuery(sqlStr, new String[]{htmlDocument.getHtml(), "" + htmlDocument.getId()});
    }

    public void visitUrlDocument(UrlDocumentDomainObject urlDocument) {
        String sqlStr = "UPDATE url_docs SET url_ref = ? WHERE meta_id = ?";
        this.database.sqlUpdateQuery(sqlStr, new String[]{urlDocument.getUrl(), "" + urlDocument.getId()});
    }

    public void visitTextDocument(final TextDocumentDomainObject textDocument) {
        boolean menusChanged;
        String sqlStr = "UPDATE text_docs SET template_id = ?, group_id = ?,\ndefault_template = ?, default_template_1 = ?, default_template_2 = ? WHERE meta_id = ?";
        TemplateDomainObject defaultTemplate = textDocument.getDefaultTemplate();
        TemplateDomainObject defaultTemplateForRestricted1 = ((TextDocumentPermissionSetDomainObject)textDocument.getPermissionSetForRestrictedOneForNewDocuments()).getDefaultTemplate();
        TemplateDomainObject defaultTemplateForRestricted2 = ((TextDocumentPermissionSetDomainObject)textDocument.getPermissionSetForRestrictedTwoForNewDocuments()).getDefaultTemplate();
        this.database.sqlUpdateQuery(sqlStr, new String[]{"" + textDocument.getTemplate().getId(), "" + textDocument.getTemplateGroupId(), null != defaultTemplate ? "" + defaultTemplate.getId() : null, null != defaultTemplateForRestricted1 ? "" + defaultTemplateForRestricted1.getId() : "-1", null != defaultTemplateForRestricted2 ? "" + defaultTemplateForRestricted2.getId() : "-1", "" + textDocument.getId()});
        this.updateTextDocumentTexts(textDocument);
        this.updateTextDocumentImages(textDocument);
        this.updateTextDocumentIncludes(textDocument);
        boolean bl = menusChanged = !((Object)textDocument.getMenus()).equals(((TextDocumentDomainObject)this.oldDocument).getMenus());
        if (menusChanged) {
            this.database.executeTransaction(new DatabaseCommand(){

                public void executeOn(DatabaseConnection connection) {
                    DocumentSavingVisitor.this.updateTextDocumentMenus(connection, textDocument);
                }
            });
        }
    }
}

