/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.ImcmsServices;
import imcode.server.db.Database;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class DocumentPermissionSetMapper {
    static final String SPROC_GET_TEMPLATE_GROUPS_WITH_PERMISSIONS = "GetTemplateGroupsWithPermissions";
    static final String SPROC_GET_TEMPLATE_GROUPS_WITH_NEW_PERMISSIONS = "GetTemplateGroupsWithNewPermissions";
    static final String SPROC_SET_DOC_PERMISSION_SET = "SetDocPermissionSet";
    private static final String SPROC_SET_NEW_DOC_PERMISSION_SET = "SetNewDocPermissionSet";
    static final String SQL_SELECT_PERMISSON_DATA__PREFIX = "SELECT permission_data FROM ";
    private static final int EDIT_DOCINFO_PERMISSION_ID = 1;
    private static final int EDIT_PERMISSIONS_PERMISSION_ID = 4;
    static final int EDIT_DOCUMENT_PERMISSION_ID = 65536;
    static final int EDIT_TEXT_DOCUMENT_TEXTS_PERMISSION_ID = 65536;
    private static final int EDIT_TEXT_DOCUMENT_IMAGES_PERMISSION_ID = 131072;
    private static final int EDIT_TEXT_DOCUMENT_MENUS_PERMISSION_ID = 262144;
    private static final int EDIT_TEXT_DOCUMENT_TEMPLATE_PERMISSION_ID = 524288;
    private static final int EDIT_TEXT_DOCUMENT_INCLUDES_PERMISSION_ID = 0x100000;
    private Database database;
    private ImcmsServices services;

    public DocumentPermissionSetMapper(Database service, ImcmsServices services) {
        this.database = service;
        this.services = services;
    }

    public DocumentPermissionSetDomainObject getRestrictedPermissionSet(DocumentDomainObject document, int permissionTypeId, boolean forNewDocuments) {
        DocumentPermissionSetDomainObject documentPermissionSet = document instanceof TextDocumentDomainObject ? new TextDocumentPermissionSetDomainObject(permissionTypeId) : new DocumentPermissionSetDomainObject(permissionTypeId);
        this.setDocumentPermissionSetBitsFromDb(document, documentPermissionSet, forNewDocuments);
        return documentPermissionSet;
    }

    private void setDocumentPermissionSetBitsFromDb(DocumentDomainObject document, DocumentPermissionSetDomainObject documentPermissionSet, boolean forNewDocuments) {
        String table = this.getPermissionsTable(forNewDocuments);
        String sqlStr = "SELECT permission_id FROM " + table + " WHERE meta_id = ? AND set_id = ?";
        String permissionBitsString = this.database.sqlQueryStr(sqlStr, new String[]{String.valueOf(document.getId()), String.valueOf(documentPermissionSet.getTypeId())});
        int permissionBits = 0;
        if (null != permissionBitsString) {
            permissionBits = Integer.parseInt(permissionBitsString);
        }
        documentPermissionSet.setFromBits(document, this, permissionBits, forNewDocuments);
    }

    private String getPermissionsTable(boolean forNewDocuments) {
        String table = "doc_permission_sets";
        if (forNewDocuments) {
            table = "new_" + table;
        }
        return table;
    }

    public DocumentPermissionSetDomainObject getPermissionSetRestrictedOne(DocumentDomainObject document) {
        return this.getRestrictedPermissionSet(document, 1, false);
    }

    public DocumentPermissionSetDomainObject getPermissionSetRestrictedTwo(DocumentDomainObject document) {
        return this.getRestrictedPermissionSet(document, 2, false);
    }

    public DocumentPermissionSetDomainObject getPermissionSetRestrictedOneForNewDocuments(DocumentDomainObject document) {
        return this.getRestrictedPermissionSet(document, 1, true);
    }

    public DocumentPermissionSetDomainObject getPermissionSetRestrictedTwoForNewDocuments(DocumentDomainObject document) {
        return this.getRestrictedPermissionSet(document, 2, true);
    }

    public void saveRestrictedDocumentPermissionSets(DocumentDomainObject document, UserDomainObject user, DocumentDomainObject oldDocument) {
        if (null == oldDocument || user.canDefineRestrictedOneFor(oldDocument)) {
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSetForRestrictedOne(), false);
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSetForRestrictedOneForNewDocuments(), true);
        }
        if (null == oldDocument || user.canDefineRestrictedTwoFor(oldDocument)) {
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSetForRestrictedTwo(), false);
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSetForRestrictedTwoForNewDocuments(), true);
        }
    }

    public void saveRestrictedDocumentPermissionSet(DocumentDomainObject document, DocumentPermissionSetDomainObject documentPermissionSet, boolean forNewDocuments) {
        ArrayList<PermissionPair> permissionPairs = new ArrayList<PermissionPair>(Arrays.asList(new PermissionPair(1, documentPermissionSet.getEditDocumentInformation()), new PermissionPair(4, documentPermissionSet.getEditPermissions())));
        if (document instanceof TextDocumentDomainObject) {
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)documentPermissionSet;
            permissionPairs.add(new PermissionPair(65536, textDocumentPermissionSet.getEditTexts()));
            permissionPairs.add(new PermissionPair(131072, textDocumentPermissionSet.getEditImages()));
            permissionPairs.add(new PermissionPair(262144, textDocumentPermissionSet.getEditMenus()));
            permissionPairs.add(new PermissionPair(524288, textDocumentPermissionSet.getEditTemplates()));
            permissionPairs.add(new PermissionPair(0x100000, textDocumentPermissionSet.getEditIncludes()));
        } else {
            permissionPairs.add(new PermissionPair(65536, documentPermissionSet.getEdit()));
        }
        int permissionBits = 0;
        Iterator iterator = permissionPairs.iterator();
        while (iterator.hasNext()) {
            PermissionPair permissionPair = (PermissionPair)iterator.next();
            if (!permissionPair.hasPermission) continue;
            permissionBits |= permissionPair.bit;
        }
        this.sqlDeleteFromExtendedPermissionsTable(document, documentPermissionSet, forNewDocuments);
        String sproc = forNewDocuments ? SPROC_SET_NEW_DOC_PERMISSION_SET : SPROC_SET_DOC_PERMISSION_SET;
        this.database.sqlUpdateProcedure(sproc, new String[]{"" + document.getId(), "" + documentPermissionSet.getTypeId(), "" + permissionBits});
        if (document instanceof TextDocumentDomainObject) {
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)documentPermissionSet;
            this.sqlSaveAllowedTemplateGroups(document, textDocumentPermissionSet, forNewDocuments);
            this.sqlSaveAllowedDocumentTypes(document, textDocumentPermissionSet, forNewDocuments);
        }
    }

    private void sqlSaveAllowedTemplateGroups(DocumentDomainObject document, TextDocumentPermissionSetDomainObject textDocumentPermissionSet, boolean forNewDocuments) {
        String table = this.getExtendedPermissionsTable(forNewDocuments);
        TemplateGroupDomainObject[] allowedTemplateGroups = textDocumentPermissionSet.getAllowedTemplateGroups(this.services);
        if (null == allowedTemplateGroups) {
            return;
        }
        String sqlInsertAllowedTemplateGroupId = "INSERT INTO " + table + " VALUES(?,?," + 524288 + ",?)";
        for (int i = 0; i < allowedTemplateGroups.length; ++i) {
            TemplateGroupDomainObject allowedTemplateGroup = allowedTemplateGroups[i];
            this.database.sqlUpdateQuery(sqlInsertAllowedTemplateGroupId, new String[]{"" + document.getId(), "" + textDocumentPermissionSet.getTypeId(), "" + allowedTemplateGroup.getId()});
        }
    }

    private void sqlDeleteFromExtendedPermissionsTable(DocumentDomainObject document, DocumentPermissionSetDomainObject documentPermissionSet, boolean forNewDocuments) {
        String table = this.getExtendedPermissionsTable(forNewDocuments);
        String sqlDelete = "DELETE FROM " + table + " WHERE meta_id = ? AND set_id = ?";
        this.database.sqlUpdateQuery(sqlDelete, new String[]{"" + document.getId(), "" + documentPermissionSet.getTypeId()});
    }

    private void sqlSaveAllowedDocumentTypes(DocumentDomainObject document, TextDocumentPermissionSetDomainObject textDocumentPermissionSet, boolean forNewDocuments) {
        String table = this.getExtendedPermissionsTable(forNewDocuments);
        int[] allowedDocumentTypeIds = textDocumentPermissionSet.getAllowedDocumentTypeIds();
        if (null == allowedDocumentTypeIds) {
            return;
        }
        String sqlInsertCreatableDocumentTypeId = "INSERT INTO " + table + " VALUES(?,?," + 8 + ",?)";
        for (int i = 0; i < allowedDocumentTypeIds.length; ++i) {
            int creatableDocumentTypeId = allowedDocumentTypeIds[i];
            this.database.sqlUpdateQuery(sqlInsertCreatableDocumentTypeId, new String[]{"" + document.getId(), "" + textDocumentPermissionSet.getTypeId(), "" + creatableDocumentTypeId});
        }
    }

    private String getExtendedPermissionsTable(boolean forNewDocuments) {
        String table = "doc_permission_sets_ex";
        if (forNewDocuments) {
            table = "new_" + table;
        }
        return table;
    }

    void setDocumentPermissionSetFromBits(DocumentPermissionSetDomainObject documentPermissionSet, int permissionBits) {
        documentPermissionSet.setEditDocumentInformation(0 != (permissionBits & 1));
        documentPermissionSet.setEditPermissions(0 != (permissionBits & 4));
        documentPermissionSet.setEdit(0 != (permissionBits & 0x10000));
    }

    void setTextDocumentPermissionSetFromBits(DocumentDomainObject document, TextDocumentPermissionSetDomainObject textDocumentPermissionSet, int permissionBits, boolean forNewDocuments) {
        this.setDocumentPermissionSetFromBits(textDocumentPermissionSet, permissionBits);
        textDocumentPermissionSet.setEditTexts(0 != (permissionBits & 0x10000));
        textDocumentPermissionSet.setEditImages(0 != (permissionBits & 0x20000));
        textDocumentPermissionSet.setEditMenus(0 != (permissionBits & 0x40000));
        textDocumentPermissionSet.setEditIncludes(0 != (permissionBits & 0x100000));
        textDocumentPermissionSet.setEditTemplates(0 != (permissionBits & 0x80000));
        TemplateGroupDomainObject[] allowedTemplateGroups = this.sqlGetTemplateGroupsWithPermissions(document.getId(), textDocumentPermissionSet, forNewDocuments);
        textDocumentPermissionSet.setAllowedTemplateGroups(allowedTemplateGroups);
        int[] documentTypeIds = this.sqlGetDocTypesWithPermissions(document.getId(), textDocumentPermissionSet, forNewDocuments);
        textDocumentPermissionSet.setAllowedDocumentTypeIds(documentTypeIds);
    }

    private int[] sqlGetDocTypesWithPermissions(int metaId, DocumentPermissionSetDomainObject documentPermissionSet, boolean forNewDocuments) {
        String table = this.getExtendedPermissionsTable(forNewDocuments);
        String sqlStr = SQL_SELECT_PERMISSON_DATA__PREFIX + table + " WHERE meta_id = ? AND set_id = ? AND permission_id = " + 8;
        String[] documentTypeIdStrings = this.database.sqlQuery(sqlStr, new String[]{"" + metaId, "" + documentPermissionSet.getTypeId()});
        int[] documentTypeIds = new int[documentTypeIdStrings.length];
        for (int i = 0; i < documentTypeIdStrings.length; ++i) {
            documentTypeIds[i] = Integer.parseInt(documentTypeIdStrings[i]);
        }
        return documentTypeIds;
    }

    private TemplateGroupDomainObject[] sqlGetTemplateGroupsWithPermissions(int metaId, DocumentPermissionSetDomainObject documentPermissionSet, boolean forNewDocuments) {
        String[] params = new String[]{String.valueOf(metaId), String.valueOf(documentPermissionSet.getTypeId())};
        String sproc = forNewDocuments ? SPROC_GET_TEMPLATE_GROUPS_WITH_NEW_PERMISSIONS : SPROC_GET_TEMPLATE_GROUPS_WITH_PERMISSIONS;
        String[][] sprocResult = this.database.sqlProcedureMulti(sproc, params);
        ArrayList<TemplateGroupDomainObject> templateGroups = new ArrayList<TemplateGroupDomainObject>();
        for (int i = 0; i < sprocResult.length; ++i) {
            boolean hasPermission;
            int groupId = Integer.parseInt(sprocResult[i][0]);
            String groupName = sprocResult[i][1];
            boolean bl = hasPermission = -1 != Integer.parseInt(sprocResult[i][2]);
            if (!hasPermission) continue;
            TemplateGroupDomainObject templateGroup = new TemplateGroupDomainObject(groupId, groupName);
            templateGroups.add(templateGroup);
        }
        return templateGroups.toArray(new TemplateGroupDomainObject[templateGroups.size()]);
    }

    private static class PermissionPair {
        int bit;
        boolean hasPermission;

        private PermissionPair(int permissionBit, boolean hasPermission) {
            this.hasPermission = hasPermission;
            this.bit = permissionBit;
        }
    }
}

