/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import com.imcode.imcms.api.util.ChainableReversibleNullComparator;
import imcode.server.document.DocumentDomainObject;

public abstract class DocumentComparator
extends ChainableReversibleNullComparator {
    private final String name;
    public static final DocumentComparator ID = new DocumentComparator("ID"){

        protected int compareDocuments(DocumentDomainObject d1, DocumentDomainObject d2) {
            return d1.getId() - d2.getId();
        }
    };
    public static final DocumentComparator HEADLINE = new DocumentComparator("HEADLINE"){

        protected int compareDocuments(DocumentDomainObject d1, DocumentDomainObject d2) {
            return d1.getHeadline().compareToIgnoreCase(d2.getHeadline());
        }
    };
    public static final DocumentComparator MODIFIED_DATETIME = new DocumentComparator("MODIFIED_DATETIME"){

        protected int compareDocuments(DocumentDomainObject d1, DocumentDomainObject d2) {
            return d1.getModifiedDatetime().compareTo(d2.getModifiedDatetime());
        }
    };
    public static final DocumentComparator ARCHIVED_DATETIME = new DocumentComparator("ARCHIVED_DATETIME"){

        protected int compareDocuments(DocumentDomainObject d1, DocumentDomainObject d2) {
            return d1.getArchivedDatetime().compareTo(d2.getArchivedDatetime());
        }
    };
    public static final DocumentComparator PUBLICATION_START_DATETIME = new DocumentComparator("PUBLICATION_START_DATETIME"){

        protected int compareDocuments(DocumentDomainObject d1, DocumentDomainObject d2) {
            return d1.getPublicationStartDatetime().compareTo(d2.getPublicationStartDatetime());
        }
    };
    public static final DocumentComparator PUBLICATION_END_DATETIME = new DocumentComparator("PUBLICATION_END_DATETIME"){

        protected int compareDocuments(DocumentDomainObject d1, DocumentDomainObject d2) {
            return d1.getPublicationEndDatetime().compareTo(d2.getPublicationEndDatetime());
        }
    };
    public static final DocumentComparator CREATED_DATETIME = new DocumentComparator("CREATED_DATETIME"){

        protected int compareDocuments(DocumentDomainObject d1, DocumentDomainObject d2) {
            return d1.getCreatedDatetime().compareTo(d2.getCreatedDatetime());
        }
    };
    public static final DocumentComparator STATUS = new DocumentComparator("STATUS"){

        protected int compareDocuments(DocumentDomainObject d1, DocumentDomainObject d2) {
            return d1.getStatus() - d2.getStatus();
        }
    };

    protected DocumentComparator(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int compare(Object o1, Object o2) {
        DocumentDomainObject d1 = (DocumentDomainObject)o1;
        DocumentDomainObject d2 = (DocumentDomainObject)o2;
        try {
            return this.compareDocuments(d1, d2);
        }
        catch (NullPointerException npe) {
            throw new NullPointerException("Tried sorting on null fields! You need to call .nullsFirst() or .nullsLast() on your Comparator.");
        }
    }

    protected abstract int compareDocuments(DocumentDomainObject var1, DocumentDomainObject var2);
}

