/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.db;

import imcode.server.db.ConnectionPool;
import imcode.server.db.DBConnect;
import imcode.server.db.Database;
import imcode.server.db.DatabaseCommand;
import imcode.server.db.DatabaseConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.UnhandledException;

public class ConnectionPoolDatabase
implements Database {
    ConnectionPool connectionPool;

    public ConnectionPoolDatabase(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void executeTransaction(DatabaseCommand databaseCommand) {
        try {
            Connection connection = this.connectionPool.getConnection();
            try {
                connection.setAutoCommit(false);
                databaseCommand.executeOn(new DatabaseConnection(connection));
                connection.commit();
            }
            catch (Throwable t) {
                connection.rollback();
                throw new UnhandledException(t);
            }
            finally {
                connection.setAutoCommit(true);
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public String[] sqlQuery(String sqlQuery, String[] parameters) {
        DBConnect dbc = new DBConnect(this.connectionPool);
        dbc.setSQLString(sqlQuery, parameters);
        List data = dbc.executeQuery();
        return ConnectionPoolDatabase.createStringArrayFromSqlResults(data);
    }

    public String sqlQueryStr(String sqlStr, String[] params) {
        DBConnect dbc = new DBConnect(this.connectionPool);
        dbc.setSQLString(sqlStr, params);
        List data = dbc.executeQuery();
        return ConnectionPoolDatabase.createStringFromSqlResults(data);
    }

    public int sqlUpdateQuery(String sqlStr, String[] params) {
        DBConnect dbc = new DBConnect(this.connectionPool);
        dbc.setSQLString(sqlStr, params);
        int res = dbc.executeUpdateQuery();
        return res;
    }

    public String[] sqlProcedure(String procedure, String[] params) {
        String procedure1 = procedure;
        procedure1 = ConnectionPoolDatabase.trimAndCheckNoWhitespace(procedure1);
        DBConnect dbc = new DBConnect(this.connectionPool);
        List data = dbc.executeProcedure(procedure1, params);
        return ConnectionPoolDatabase.createStringArrayFromSqlResults(data);
    }

    public int sqlUpdateProcedure(String procedure, String[] params) {
        DBConnect dbc = new DBConnect(this.connectionPool);
        int res = dbc.executeUpdateProcedure(procedure, params);
        return res;
    }

    public String sqlProcedureStr(String procedure, String[] params) {
        DBConnect dbc = new DBConnect(this.connectionPool);
        List data = dbc.executeProcedure(procedure, params);
        return ConnectionPoolDatabase.createStringFromSqlResults(data);
    }

    public Map sqlProcedureHash(String procedure, String[] params) {
        procedure = ConnectionPoolDatabase.trimAndCheckNoWhitespace(procedure);
        DBConnect dbc = new DBConnect(this.connectionPool);
        List data = dbc.executeProcedure(procedure, params);
        String[] meta = dbc.getColumnLabels();
        return ConnectionPoolDatabase.createHashtableOfStringArrayFromSqlResults(data, meta);
    }

    public String[][] sqlProcedureMulti(String procedure, String[] params) {
        procedure = ConnectionPoolDatabase.trimAndCheckNoWhitespace(procedure);
        DBConnect dbc = new DBConnect(this.connectionPool);
        List data = dbc.executeProcedure(procedure, params);
        int columns = dbc.getColumnCount();
        return ConnectionPoolDatabase.create2DStringArrayFromSqlResults(data, columns);
    }

    public String[][] sqlQueryMulti(String sqlQuery, String[] params) {
        DBConnect dbc = new DBConnect(this.connectionPool);
        dbc.setSQLString(sqlQuery, params);
        List data = dbc.executeQuery();
        int columns = dbc.getColumnCount();
        return ConnectionPoolDatabase.create2DStringArrayFromSqlResults(data, columns);
    }

    private static String trimAndCheckNoWhitespace(String procedure) {
        if ((procedure = procedure.trim()).matches("\\s")) {
            throw new IllegalArgumentException("Procedurename contains whitespace. Procedure-parameters are not allowed in this method.");
        }
        return procedure;
    }

    private static String createStringFromSqlResults(List data) {
        if (data != null && !data.isEmpty()) {
            return null != data.get(0) ? data.get(0).toString() : null;
        }
        return null;
    }

    private static String[][] create2DStringArrayFromSqlResults(List data, int columns) {
        if (columns == 0) {
            return new String[0][0];
        }
        int rows = data.size() / columns;
        String[][] result = new String[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                result[i][j] = null != data.get(i * columns + j) ? data.get(i * columns + j).toString() : null;
            }
        }
        return result;
    }

    private static String[] createStringArrayFromSqlResults(List data) {
        String[] result = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            result[i] = null != data.get(i) ? data.get(i).toString() : null;
        }
        return result;
    }

    private static Map createHashtableOfStringArrayFromSqlResults(List data, String[] meta) {
        HashMap<String, String[]> result = new HashMap<String, String[]>(meta.length);
        if (data.size() > 0) {
            for (int i = 0; i < meta.length; ++i) {
                String[] temp_str = new String[data.size() / meta.length];
                int counter = 0;
                for (int j = i; j < data.size(); j += meta.length) {
                    temp_str[counter++] = null != data.get(j) ? data.get(j).toString() : null;
                }
                result.put(meta[i], temp_str);
            }
            return result;
        }
        return new HashMap(1);
    }
}

