/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.db;

import imcode.server.db.ConnectionPoolForNonPoolingDriver;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class ConnectionPool {
    private static Logger log = Logger.getLogger((Class)ConnectionPool.class);

    public abstract Connection getConnection() throws SQLException;

    public static ConnectionPool createConnectionPool(String jdbcDriver, String jdbcUrl, String user, String password, int maxConnectionCount) {
        ConnectionPoolForNonPoolingDriver connectionPool;
        try {
            connectionPool = new ConnectionPoolForNonPoolingDriver(jdbcDriver, jdbcUrl, user, password, maxConnectionCount);
        }
        catch (Exception ex) {
            log.fatal((Object)("Failed to create connection pool. Url: " + jdbcUrl + " Driver: " + jdbcDriver), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return connectionPool;
    }

    public abstract void destroy();
}

