/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import imcode.server.DefaultImcmsServices;
import imcode.server.ImcmsServices;
import imcode.server.db.ConnectionPool;
import imcode.server.db.ConnectionPoolDatabase;
import imcode.util.Prefs;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class Imcms {
    private static final String SERVER_PROPERTIES_FILENAME = "server.properties";
    private static final Logger log = Logger.getLogger((String)Imcms.class.getName());
    private static ImcmsServices services;
    private static ConnectionPool apiConnectionPool;
    private static ConnectionPool connectionPool;

    private Imcms() {
    }

    public static synchronized ImcmsServices getServices() {
        if (null == services) {
            services = Imcms.createServices();
        }
        return services;
    }

    private static synchronized ImcmsServices createServices() {
        Properties serverprops = Imcms.getServerProperties();
        connectionPool = Imcms.createConnectionPool(serverprops);
        ConnectionPoolDatabase database = new ConnectionPoolDatabase(connectionPool);
        DefaultImcmsServices services = new DefaultImcmsServices(database, serverprops);
        return services;
    }

    public static synchronized ConnectionPool getApiConnectionPool() {
        if (null == apiConnectionPool) {
            Properties serverprops = Imcms.getServerProperties();
            apiConnectionPool = Imcms.createConnectionPool(serverprops);
        }
        return apiConnectionPool;
    }

    private static Properties getServerProperties() {
        try {
            return Prefs.getProperties(SERVER_PROPERTIES_FILENAME);
        }
        catch (IOException e) {
            log.fatal((Object)"Failed to initialize imCMS", (Throwable)e);
            throw new UnhandledException((Throwable)e);
        }
    }

    private static ConnectionPool createConnectionPool(Properties props) {
        String jdbcDriver = props.getProperty("JdbcDriver");
        String jdbcUrl = props.getProperty("JdbcUrl");
        String user = props.getProperty("User");
        String password = props.getProperty("Password");
        int maxConnectionCount = Integer.parseInt(props.getProperty("MaxConnectionCount"));
        log.debug((Object)("JdbcDriver = " + jdbcDriver));
        log.debug((Object)("JdbcUrl = " + jdbcUrl));
        log.debug((Object)("User = " + user));
        log.debug((Object)("MaxConnectionCount = " + maxConnectionCount));
        return ConnectionPool.createConnectionPool(jdbcDriver, jdbcUrl, user, password, maxConnectionCount);
    }

    public static synchronized void restart() {
        Prefs.flush();
        apiConnectionPool.destroy();
        connectionPool.destroy();
        services = Imcms.createServices();
    }
}

