/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import imcode.server.Config;
import imcode.server.ImcmsServices;
import imcode.server.LanguageMapper;
import imcode.server.SystemData;
import imcode.server.UserFlag;
import imcode.server.WebAppGlobalConstants;
import imcode.server.db.Database;
import imcode.server.db.DatabaseCommand;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentPermissionSetMapper;
import imcode.server.document.TemplateMapper;
import imcode.server.document.index.AutorebuildingDirectoryIndex;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.parser.ParserParameters;
import imcode.server.parser.TextDocumentParser;
import imcode.server.user.Authenticator;
import imcode.server.user.ExternalizedImcmsAuthenticatorAndUserRegistry;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.LdapUserAndRoleRegistry;
import imcode.server.user.UserAndRoleRegistry;
import imcode.server.user.UserDomainObject;
import imcode.util.Clock;
import imcode.util.FileCache;
import imcode.util.FileUtility;
import imcode.util.Parser;
import imcode.util.Prefs;
import imcode.util.fortune.Poll;
import imcode.util.fortune.PollReader;
import imcode.util.fortune.PollWriter;
import imcode.util.fortune.Quote;
import imcode.util.fortune.QuoteReader;
import imcode.util.fortune.QuoteWriter;
import imcode.util.net.SMTP;
import imcode.util.poll.PollHandlingSystem;
import imcode.util.poll.PollHandlingSystemImpl;
import imcode.util.shop.ShoppingOrderSystem;
import imcode.util.shop.ShoppingOrderSystemImpl;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public final class DefaultImcmsServices
implements ImcmsServices {
    private final Database database;
    private TextDocumentParser textDocParser;
    private Config config;
    private static final int DEFAULT_STARTDOCUMENT = 1001;
    private SystemData sysData;
    private Date sessionCounterDate;
    private int sessionCounter = 0;
    private FileCache fileCache = new FileCache();
    private static final Logger mainLog = Logger.getLogger((String)"com.imcode.imcms.log.main");
    private static final Logger log = Logger.getLogger((String)DefaultImcmsServices.class.getName());
    private static final String EXTERNAL_AUTHENTICATOR_LDAP = "LDAP";
    private static final String EXTERNAL_USER_AND_ROLE_MAPPER_LDAP = "LDAP";
    private ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserMapperAndRole;
    private ExternalizedImcmsAuthenticatorAndUserRegistry externalizedImcmsAuthAndMapper = null;
    private DocumentMapper documentMapper;
    private TemplateMapper templateMapper;
    private Map languagePropertiesMap = new HashMap();
    private KeyStore keyStore;
    private Map velocityEngines = new TreeMap();
    private static final FileFilter DEMOTEMPLATEFILTER;

    public DefaultImcmsServices(Database database, Properties props) {
        this.database = database;
        this.initConfig(props);
        this.initKeyStore();
        this.initSysData();
        this.initSessionCounter();
        this.initAuthenticatorsAndUserAndRoleMappers(props);
        this.initDocumentMapper();
        this.initTemplateMapper();
        this.initTextDocParser();
    }

    private void initKeyStore() {
        String keyStoreType = this.config.getKeyStoreType();
        if (StringUtils.isBlank((String)keyStoreType)) {
            keyStoreType = KeyStore.getDefaultType();
        }
        try {
            this.keyStore = KeyStore.getInstance(keyStoreType);
            this.keyStore.load(null, null);
        }
        catch (GeneralSecurityException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
        String keyStorePath = this.config.getKeyStorePath();
        if (StringUtils.isNotBlank((String)keyStorePath)) {
            File keyStoreFile = FileUtility.getFileFromWebappRelativePath(keyStorePath);
            try {
                this.keyStore.load(new FileInputStream(keyStoreFile), null);
            }
            catch (Exception e) {
                log.error((Object)("Failed to load keystore from path " + keyStoreFile), (Throwable)e);
            }
        }
    }

    private void initTextDocParser() {
        this.textDocParser = new TextDocumentParser(this);
    }

    private void initSysData() {
        this.sysData = this.getSystemDataFromDb();
    }

    private void initConfig(Properties props) {
        this.config = DefaultImcmsServices.createConfigFromProperties(props);
    }

    private static Config createConfigFromProperties(Properties props) {
        Config config = new Config();
        ConvertUtils.register((Converter)new WebappRelativeFileConverter(), (Class)File.class);
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)config);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            if (null == propertyDescriptor.getWriteMethod()) continue;
            String uncapitalizedPropertyName = propertyDescriptor.getName();
            String capitalizedPropertyName = StringUtils.capitalize((String)uncapitalizedPropertyName);
            String propertyValue = props.getProperty(capitalizedPropertyName);
            if (null != propertyValue) {
                try {
                    BeanUtils.setProperty((Object)config, (String)uncapitalizedPropertyName, (Object)propertyValue);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to set property " + capitalizedPropertyName), e.getCause());
                    continue;
                }
            }
            try {
                String setPropertyValue = BeanUtils.getProperty((Object)config, (String)uncapitalizedPropertyName);
                if (null != setPropertyValue) {
                    log.info((Object)(capitalizedPropertyName + " = " + setPropertyValue));
                    continue;
                }
                log.warn((Object)(capitalizedPropertyName + " not set."));
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return config;
    }

    private void initSessionCounter() {
        try {
            this.sessionCounter = this.getSessionCounterFromDb();
            this.sessionCounterDate = this.getSessionCounterDateFromDb();
        }
        catch (NumberFormatException ex) {
            log.fatal((Object)"Failed to get SessionCounter from db.", (Throwable)ex);
            throw ex;
        }
        log.info((Object)("SessionCounter: " + this.sessionCounter));
        log.info((Object)("SessionCounterDate: " + this.sessionCounterDate));
    }

    private Date getSessionCounterDateFromDb() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return dateFormat.parse(this.sqlProcedureStr("GetCurrentSessionCounterDate", new String[0]));
        }
        catch (ParseException ex) {
            log.fatal((Object)"Failed to get SessionCounterDate from db.", (Throwable)ex);
            throw new UnhandledException((Throwable)ex);
        }
    }

    private int getSessionCounterFromDb() {
        return Integer.parseInt(this.sqlProcedureStr("GetCurrentSessionCounter", new String[0]));
    }

    private void initDocumentMapper() {
        File indexDirectory = new File(this.getRealContextPath(), "WEB-INF/index");
        AutorebuildingDirectoryIndex documentIndex = new AutorebuildingDirectoryIndex(indexDirectory, this.getConfig().getIndexingSchedulePeriodInMinutes());
        this.documentMapper = new DocumentMapper(this, this.getDatabase(), this.getImcmsAuthenticatorAndUserAndRoleMapper(), new DocumentPermissionSetMapper(this.getDatabase(), this), documentIndex, this.getClock(), this.getConfig());
    }

    private void initTemplateMapper() {
        this.templateMapper = new TemplateMapper(this);
    }

    private void initAuthenticatorsAndUserAndRoleMappers(Properties props) {
        String externalAuthenticatorName = props.getProperty("ExternalAuthenticator");
        String externalUserAndRoleMapperName = props.getProperty("ExternalUserAndRoleMapper");
        Authenticator externalAuthenticator = null;
        UserAndRoleRegistry externalUserAndRoleRegistry = null;
        boolean externalAuthenticatorIsSet = StringUtils.isNotBlank((String)externalAuthenticatorName);
        boolean externalUserAndRoleRegistryIsSet = StringUtils.isNotBlank((String)externalUserAndRoleMapperName);
        if (externalAuthenticatorIsSet && externalUserAndRoleRegistryIsSet) {
            log.info((Object)("ExternalAuthenticator: " + externalAuthenticatorName));
            log.info((Object)("ExternalUserAndRoleMapper: " + externalUserAndRoleMapperName));
            externalAuthenticator = this.initExternalAuthenticator(externalAuthenticatorName, props);
            externalUserAndRoleRegistry = this.initExternalUserAndRoleMapper(externalUserAndRoleMapperName, props);
            if (null == externalAuthenticator || null == externalUserAndRoleRegistry) {
                log.error((Object)"Failed to initialize both authenticator and user-and-role-documentMapper, using default implementations.");
                externalAuthenticator = null;
                externalUserAndRoleRegistry = null;
            }
        } else if (!externalAuthenticatorIsSet && !externalUserAndRoleRegistryIsSet) {
            log.info((Object)"ExternalAuthenticator not set.");
            log.info((Object)"ExternalUserAndRoleMapper not set.");
        } else {
            log.error((Object)"External authenticator and external usermapper should both be either set or not set. Using default implementation.");
            log.error((Object)"External authenticator and external usermapper should both be either set or not set. Using default implementation.");
        }
        this.imcmsAuthenticatorAndUserMapperAndRole = new ImcmsAuthenticatorAndUserAndRoleMapper(this, this);
        this.externalizedImcmsAuthAndMapper = new ExternalizedImcmsAuthenticatorAndUserRegistry(this.imcmsAuthenticatorAndUserMapperAndRole, externalAuthenticator, externalUserAndRoleRegistry, this.getDefaultLanguage());
        this.externalizedImcmsAuthAndMapper.synchRolesWithExternal();
    }

    public synchronized int getSessionCounter() {
        return this.sessionCounter;
    }

    public String getSessionCounterDateAsString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(this.sessionCounterDate);
    }

    public UserDomainObject verifyUser(String login, String password) {
        NDC.push((String)"verifyUser");
        UserDomainObject result = null;
        boolean userAuthenticates = this.externalizedImcmsAuthAndMapper.authenticate(login, password);
        UserDomainObject user = this.externalizedImcmsAuthAndMapper.getUser(login);
        if (userAuthenticates) {
            result = user;
            mainLog.info((Object)("->User '" + login + "' successfully logged in."));
        } else if (null == user) {
            mainLog.info((Object)("->User '" + login + "' failed to log in: User not found."));
        } else if (!user.isActive()) {
            mainLog.info((Object)("->User '" + login + "' failed to log in: User deactivated."));
        } else {
            mainLog.info((Object)("->User '" + login + "' failed to log in: Wrong password."));
        }
        NDC.pop();
        return result;
    }

    public synchronized void incrementSessionCounter() {
        this.sqlUpdateProcedure("IncSessionCounter", new String[0]);
        this.sessionCounter = this.getSessionCounterFromDb();
    }

    private UserAndRoleRegistry initExternalUserAndRoleMapper(String externalUserAndRoleMapperName, Properties userAndRoleMapperPropertiesSubset) {
        UserAndRoleRegistry externalUserAndRoleRegistry = null;
        if (null == externalUserAndRoleMapperName) {
            externalUserAndRoleRegistry = null;
        } else if ("LDAP".equalsIgnoreCase(externalUserAndRoleMapperName)) {
            try {
                externalUserAndRoleRegistry = new LdapUserAndRoleRegistry(userAndRoleMapperPropertiesSubset);
            }
            catch (LdapUserAndRoleRegistry.LdapInitException e) {
                log.error((Object)"LdapUserAndRoleRegistry could not be created, using default user and role documentMapper.", (Throwable)e);
            }
        } else {
            externalUserAndRoleRegistry = (UserAndRoleRegistry)DefaultImcmsServices.createInstanceOfClass(externalUserAndRoleMapperName);
        }
        return externalUserAndRoleRegistry;
    }

    private Authenticator initExternalAuthenticator(String externalAuthenticatorName, Properties authenticatorPropertiesSubset) {
        Authenticator externalAuthenticator = null;
        try {
            if (null == externalAuthenticatorName) {
                externalAuthenticator = null;
            } else if ("LDAP".equalsIgnoreCase(externalAuthenticatorName)) {
                try {
                    externalAuthenticator = new LdapUserAndRoleRegistry(authenticatorPropertiesSubset);
                }
                catch (LdapUserAndRoleRegistry.LdapInitException e) {
                    log.error((Object)"LdapUserAndRoleRegistry could not be created, using default user and role documentMapper.", (Throwable)e);
                }
            } else {
                externalAuthenticator = (Authenticator)DefaultImcmsServices.createInstanceOfClass(externalAuthenticatorName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize external authenticator.", (Throwable)e);
        }
        return externalAuthenticator;
    }

    private static Object createInstanceOfClass(String className) {
        Object instance = null;
        try {
            instance = Class.forName(className).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not create instance of class '" + className + "'."), (Throwable)e);
        }
        return instance;
    }

    public String parsePage(ParserParameters paramsToParse) throws IOException {
        return this.textDocParser.parsePage(paramsToParse);
    }

    public TextDomainObject getText(int meta_id, int no) {
        return this.documentMapper.getText(meta_id, no);
    }

    public void updateMainLog(String event) {
        mainLog.info((Object)event);
    }

    public String isFramesetDoc(int meta_id) {
        String htmlStr = null;
        if (7 == this.getDocType(meta_id)) {
            String sqlStr = "select frame_set from frameset_docs where meta_id = ?";
            htmlStr = this.sqlQueryStr(sqlStr, new String[]{"" + meta_id});
        }
        return htmlStr;
    }

    public String[] sqlQuery(String sqlQuery, String[] parameters) {
        return this.database.sqlQuery(sqlQuery, parameters);
    }

    public String sqlQueryStr(String sqlStr, String[] params) {
        return this.database.sqlQueryStr(sqlStr, params);
    }

    public int sqlUpdateQuery(String sqlStr, String[] params) {
        return this.database.sqlUpdateQuery(sqlStr, params);
    }

    public String[] sqlProcedure(String procedure, String[] params) {
        return this.database.sqlProcedure(procedure, params);
    }

    public int sqlUpdateProcedure(String procedure, String[] params) {
        return this.database.sqlUpdateProcedure(procedure, params);
    }

    public String sqlProcedureStr(String procedure, String[] params) {
        return this.database.sqlProcedureStr(procedure, params);
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    public TemplateMapper getTemplateMapper() {
        return this.templateMapper;
    }

    public SMTP getSMTP() {
        return new SMTP(this.config.getSmtpServer(), this.config.getSmtpPort());
    }

    public ImcmsAuthenticatorAndUserAndRoleMapper getImcmsAuthenticatorAndUserAndRoleMapper() {
        return this.imcmsAuthenticatorAndUserMapperAndRole;
    }

    public String getAdminTemplate(String adminTemplateName, UserDomainObject user, List tagsWithReplacements) {
        return this.getTemplateFromDirectory(adminTemplateName, user, tagsWithReplacements, "admin");
    }

    public String getTemplateFromDirectory(String adminTemplateName, UserDomainObject user, List variables, String directory) {
        if (null == user) {
            throw new NullArgumentException("user");
        }
        String langPrefix = user.getLanguageIso639_2();
        return this.getTemplate(langPrefix + "/" + directory + "/" + adminTemplateName, user, variables);
    }

    public String getTemplateFromSubDirectoryOfDirectory(String adminTemplateName, UserDomainObject user, List variables, String directory, String subDirectory) {
        if (null == user) {
            throw new NullArgumentException("user");
        }
        String langPrefix = this.getUserLangPrefixOrDefaultLanguage(user);
        return this.getTemplate(langPrefix + "/" + directory + "/" + subDirectory + "/" + adminTemplateName, user, variables);
    }

    private String getTemplate(String path, UserDomainObject user, List variables) {
        try {
            VelocityEngine velocity = this.getVelocityEngine(user);
            VelocityContext context = this.getVelocityContext(user);
            if (null != variables) {
                ArrayList<String> parseDocVariables = new ArrayList<String>(variables.size());
                Iterator iterator = variables.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = iterator.next();
                    context.put(key, value);
                    boolean isVelocityVariable = StringUtils.isAlpha((String)key) || !(value instanceof String);
                    if (isVelocityVariable) continue;
                    parseDocVariables.add(key);
                    parseDocVariables.add((String)value);
                }
                variables = parseDocVariables;
            }
            StringWriter stringWriter = new StringWriter();
            velocity.mergeTemplate(path, "windows-1252", (Context)context, (Writer)stringWriter);
            String result = stringWriter.toString();
            if (null != variables) {
                result = Parser.parseDoc(result, variables.toArray(new String[variables.size()]));
            }
            return result;
        }
        catch (Exception e) {
            throw new UnhandledException("getTemplate(\"" + path + "\") : " + e.getMessage(), (Throwable)e);
        }
    }

    private synchronized VelocityEngine createVelocityEngine(String languageIso639_2) throws Exception {
        VelocityEngine velocity = new VelocityEngine();
        velocity.setProperty("file.resource.loader.path", (Object)this.config.getTemplatePath().getCanonicalPath());
        velocity.setProperty("velocimacro.library", (Object)(languageIso639_2 + "/gui.vm"));
        velocity.setProperty("velocimacro.library.autoreload", (Object)"true");
        velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        velocity.setProperty("runtime.log.logsystem.log4j.category", (Object)"org.apache.velocity");
        velocity.init();
        return velocity;
    }

    public VelocityEngine getVelocityEngine(UserDomainObject user) {
        try {
            String languageIso639_2 = user.getLanguageIso639_2();
            VelocityEngine velocityEngine = (VelocityEngine)this.velocityEngines.get(languageIso639_2);
            if (velocityEngine == null) {
                velocityEngine = this.createVelocityEngine(languageIso639_2);
                this.velocityEngines.put(languageIso639_2, velocityEngine);
            }
            return velocityEngine;
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public VelocityContext getVelocityContext(UserDomainObject user) {
        VelocityContext context = new VelocityContext();
        context.put("contextPath", (Object)user.getCurrentContextPath());
        context.put("language", (Object)user.getLanguageIso639_2());
        return context;
    }

    public Config getConfig() {
        return this.config;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Clock getClock() {
        return this;
    }

    public File getRealContextPath() {
        return WebAppGlobalConstants.getInstance().getAbsoluteWebAppPath();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public File getExternalTemplateFolder(int meta_id, UserDomainObject user) {
        int docType = this.getDocType(meta_id);
        String langPrefix = this.getUserLangPrefixOrDefaultLanguage(user);
        return new File(this.config.getTemplatePath(), langPrefix + "/" + docType + "/");
    }

    public File getTemplatePath() {
        return this.config.getTemplatePath();
    }

    public File getImcmsPath() {
        return this.config.getImcmsPath();
    }

    public String getDefaultLanguage() {
        return this.getConfig().getDefaultLanguage();
    }

    public String getLanguagePrefixByLangId(int lang_id) {
        String lang_prefix = this.sqlProcedureStr("GetLangPrefixFromId", new String[]{"" + lang_id});
        return lang_prefix;
    }

    public String getUserLangPrefixOrDefaultLanguage(UserDomainObject user) {
        String lang_prefix = this.getDefaultLanguage();
        if (user != null) {
            return user.getLanguageIso639_2();
        }
        return lang_prefix;
    }

    public synchronized void setSessionCounter(int value) {
        this.setSessionCounterInDb(value);
        this.sessionCounter = this.getSessionCounterFromDb();
    }

    private void setSessionCounterInDb(int value) {
        this.sqlUpdateProcedure("SetSessionCounterValue", new String[]{"" + value});
    }

    public void setSessionCounterDate(Date date) {
        this.setSessionCounterDateInDb(date);
        this.sessionCounterDate = this.getSessionCounterDateFromDb();
    }

    private void setSessionCounterDateInDb(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.sqlUpdateProcedure("SetSessionCounterDate", new String[]{dateFormat.format(date)});
    }

    public Date getSessionCounterDate() {
        return this.sessionCounterDate;
    }

    public Map sqlProcedureHash(String procedure, String[] params) {
        return this.database.sqlProcedureHash(procedure, params);
    }

    public String[][] sqlProcedureMulti(String procedure, String[] params) {
        return this.database.sqlProcedureMulti(procedure, params);
    }

    public String[][] sqlQueryMulti(String sqlQuery, String[] params) {
        return this.database.sqlQueryMulti(sqlQuery, params);
    }

    public void executeTransaction(DatabaseCommand databaseCommand) {
        this.database.executeTransaction(databaseCommand);
    }

    public int getDocType(int meta_id) {
        DocumentDomainObject document = this.documentMapper.getDocument(meta_id);
        if (null != document) {
            return document.getDocumentTypeId();
        }
        return 0;
    }

    public boolean checkDocAdminRights(int meta_id, UserDomainObject user) {
        return user.canEdit(this.documentMapper.getDocument(meta_id));
    }

    public boolean checkDocAdminRightsAny(int meta_id, UserDomainObject user, int permission) {
        try {
            boolean userHasFullPermission;
            String[] perms = this.sqlProcedure("GetUserPermissionSet", new String[]{String.valueOf(meta_id), String.valueOf(user.getId())});
            int set_id = Integer.parseInt(perms[0]);
            int set = Integer.parseInt(perms[1]);
            boolean bl = userHasFullPermission = set_id == 0;
            return perms.length > 0 && userHasFullPermission || set_id < 3 && (set & permission) > 0;
        }
        catch (RuntimeException ex) {
            log.error((Object)"Exception in checkDocAdminRightsAny(int,User,int)", (Throwable)ex);
            throw ex;
        }
    }

    public boolean checkDocAdminRights(int meta_id, UserDomainObject user, int permission) {
        try {
            String[] perms = this.sqlProcedure("GetUserPermissionSet", new String[]{String.valueOf(meta_id), String.valueOf(user.getId())});
            if (perms.length == 0) {
                return false;
            }
            int set_id = Integer.parseInt(perms[0]);
            int set = Integer.parseInt(perms[1]);
            return set_id == 0 || set_id < 3 && (set & permission) == permission;
        }
        catch (RuntimeException ex) {
            log.error((Object)"Exception in checkDocAdminRights(int,User,int)", (Throwable)ex);
            throw ex;
        }
    }

    public int saveTemplate(String name, String file_name, byte[] template, boolean overwrite, String lang_prefix) {
        String sqlStr = "select template_id from templates where simple_name = ?";
        String templateId = this.sqlQueryStr(sqlStr, new String[]{name});
        if (null == templateId) {
            sqlStr = "select max(template_id) + 1 from templates\n";
            templateId = this.sqlQueryStr(sqlStr, new String[0]);
            sqlStr = "insert into templates values (?,?,?,?,0,0,0)";
            this.sqlUpdateQuery(sqlStr, new String[]{templateId, file_name, name, lang_prefix});
        } else {
            if (!overwrite) {
                return -1;
            }
            sqlStr = "update templates set template_name = ? where template_id = ?";
            this.sqlUpdateQuery(sqlStr, new String[]{file_name, templateId});
        }
        File f = new File(this.config.getTemplatePath(), "text/" + templateId + ".html");
        try {
            FileOutputStream fw = new FileOutputStream(f);
            fw.write(template);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            return -2;
        }
        return 0;
    }

    public Object[] getDemoTemplate(int template_id) throws IOException {
        StringBuffer str = new StringBuffer();
        BufferedReader fr = null;
        String suffix = null;
        String[] suffixList = new String[]{"jpg", "jpeg", "gif", "png", "html", "htm"};
        for (int i = 0; i < suffixList.length; ++i) {
            File fileObj = new File(this.config.getTemplatePath(), "/text/demo/" + template_id + "." + suffixList[i]);
            long date = 0L;
            long fileDate = fileObj.lastModified();
            if (!fileObj.exists() || fileDate <= date) continue;
            try {
                fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileObj), "8859_1"));
                suffix = suffixList[i];
                continue;
            }
            catch (IOException e) {
                return null;
            }
        }
        char[] buffer = new char[4096];
        try {
            int read;
            while ((read = fr.read(buffer, 0, 4096)) != -1) {
                str.append(buffer, 0, read);
            }
            fr.close();
        }
        catch (IOException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        return new Object[]{suffix, str.toString().getBytes("8859_1")};
    }

    public String getTemplateData(int template_id) throws IOException {
        return this.fileCache.getCachedFileString(new File(this.config.getTemplatePath(), "/text/" + template_id + ".html"));
    }

    public void saveDemoTemplate(int template_id, byte[] data, String suffix) throws IOException {
        this.deleteDemoTemplate(template_id);
        FileOutputStream fw = new FileOutputStream(this.config.getTemplatePath() + "/text/demo/" + template_id + "." + suffix);
        fw.write(data);
        fw.flush();
        fw.close();
    }

    public Date getCurrentDate() {
        return new Date();
    }

    public String[] getDemoTemplateIds() {
        File demoDir = new File(this.config.getTemplatePath() + "/text/demo/");
        File[] file_list = demoDir.listFiles(DEMOTEMPLATEFILTER);
        String[] name_list = new String[file_list.length];
        if (file_list != null) {
            for (int i = 0; i < name_list.length; ++i) {
                String filename = file_list[i].getName();
                int dot = filename.indexOf(".");
                name_list[i] = dot > -1 ? filename.substring(0, dot) : filename;
            }
        } else {
            return new String[0];
        }
        return name_list;
    }

    public void deleteDemoTemplate(int template_id) throws IOException {
        File demoTemplateDirectory = new File(new File(this.config.getTemplatePath(), "text"), "demo");
        File[] demoTemplates = demoTemplateDirectory.listFiles();
        for (int i = 0; i < demoTemplates.length; ++i) {
            File demoTemplate = demoTemplates[i];
            String demoTemplateFileName = demoTemplate.getName();
            if (!demoTemplateFileName.startsWith(template_id + ".") || demoTemplate.delete()) continue;
            throw new IOException("fail to deleate");
        }
    }

    private SystemData getSystemDataFromDb() {
        String startDocument = this.sqlProcedureStr("StartDocGet", new String[0]);
        String[] serverMaster = this.sqlProcedure("ServerMasterGet", new String[0]);
        String[] webMaster = this.sqlProcedure("WebMasterGet", new String[0]);
        String systemMessage = this.sqlProcedureStr("SystemMessageGet", new String[0]);
        SystemData sd = new SystemData();
        sd.setStartDocument(startDocument == null ? 1001 : Integer.parseInt(startDocument));
        sd.setSystemMessage(systemMessage);
        if (serverMaster.length > 0) {
            sd.setServerMaster(serverMaster[0]);
            if (serverMaster.length > 1) {
                sd.setServerMasterAddress(serverMaster[1]);
            }
        }
        if (webMaster.length > 0) {
            sd.setWebMaster(webMaster[0]);
            if (webMaster.length > 1) {
                sd.setWebMasterAddress(webMaster[1]);
            }
        }
        return sd;
    }

    public SystemData getSystemData() {
        return this.sysData;
    }

    public void setSystemData(SystemData sd) {
        String[] sqlParams = new String[]{"" + sd.getStartDocument()};
        this.sqlUpdateProcedure("StartDocSet", sqlParams);
        sqlParams = new String[]{sd.getWebMaster(), sd.getWebMasterAddress()};
        this.sqlUpdateProcedure("WebMasterSet", sqlParams);
        sqlParams = new String[]{sd.getServerMaster(), sd.getServerMasterAddress()};
        this.sqlUpdateProcedure("ServerMasterSet", sqlParams);
        sqlParams = new String[]{sd.getSystemMessage()};
        this.sqlUpdateProcedure("SystemMessageSet", sqlParams);
        this.sysData = sd;
    }

    public void setUserFlag(UserDomainObject user, String flagName) {
        int userId = user.getId();
        this.sqlUpdateProcedure("SetUserFlag", new String[]{"" + userId, flagName});
    }

    public String[][] getAllDocumentTypes(String langPrefixStr) {
        return this.sqlProcedureMulti("GetDocTypes", new String[]{langPrefixStr});
    }

    public void unsetUserFlag(UserDomainObject user, String flagName) {
        int userId = user.getId();
        this.sqlUpdateProcedure("UnsetUserFlag", new String[]{"" + userId, flagName});
    }

    public String getFortune(String path) throws IOException {
        return this.fileCache.getCachedFileString(new File(this.config.getFortunePath(), path));
    }

    public List getQuoteList(String quoteListName) {
        LinkedList<Quote> theList = new LinkedList<Quote>();
        try {
            Quote quote;
            File file = new File(this.config.getFortunePath(), quoteListName);
            StringReader reader = new StringReader(this.fileCache.getUncachedFileString(file));
            QuoteReader quoteReader = new QuoteReader(reader);
            while (null != (quote = quoteReader.readQuote())) {
                theList.add(quote);
            }
            reader.close();
        }
        catch (IOException ignored) {
            log.debug((Object)("Failed to load quote-list " + quoteListName));
        }
        return theList;
    }

    public void setQuoteList(String quoteListName, List quoteList) throws IOException {
        FileWriter writer = new FileWriter(new File(this.config.getFortunePath(), quoteListName));
        QuoteWriter quoteWriter = new QuoteWriter(writer);
        Iterator quotesIterator = quoteList.iterator();
        while (quotesIterator.hasNext()) {
            quoteWriter.writeQuote((Quote)quotesIterator.next());
        }
        writer.flush();
        writer.close();
    }

    public List getPollList(String pollListName) {
        LinkedList<Poll> theList = new LinkedList<Poll>();
        try {
            Poll poll;
            File file = new File(this.config.getFortunePath(), pollListName);
            StringReader reader = new StringReader(this.fileCache.getUncachedFileString(file));
            PollReader pollReader = new PollReader(reader);
            while (null != (poll = pollReader.readPoll())) {
                theList.add(poll);
            }
            reader.close();
        }
        catch (IOException ignored) {
            log.debug((Object)("Failed to load poll-list " + pollListName));
        }
        return theList;
    }

    public void setPollList(String pollListName, List pollList) throws IOException {
        FileWriter writer = new FileWriter(new File(this.config.getFortunePath(), pollListName));
        PollWriter pollWriter = new PollWriter(writer);
        Iterator pollIterator = pollList.iterator();
        while (pollIterator.hasNext()) {
            pollWriter.writePoll((Poll)pollIterator.next());
        }
        writer.flush();
        writer.close();
    }

    public Map getUserFlags() {
        String[] dbData = this.sqlProcedure("GetUserFlags", new String[0]);
        return this.getUserFlags(dbData);
    }

    public Map getUserFlags(UserDomainObject user) {
        int userId = user.getId();
        String[] dbData = this.sqlProcedure("GetUserFlagsForUser", new String[]{String.valueOf(userId)});
        return this.getUserFlags(dbData);
    }

    public Map getUserFlags(int type) {
        String[] dbData = this.sqlProcedure("GetUserFlagsOfType", new String[]{String.valueOf(type)});
        return this.getUserFlags(dbData);
    }

    public Map getUserFlags(UserDomainObject user, int type) {
        int userId = user.getId();
        String[] dbData = this.sqlProcedure("GetUserFlagsForUserOfType", new String[]{String.valueOf(userId), String.valueOf(type)});
        return this.getUserFlags(dbData);
    }

    private Map getUserFlags(String[] dbData) {
        HashMap<String, UserFlag> theFlags = new HashMap<String, UserFlag>();
        for (int i = 0; i < dbData.length; i += 4) {
            String flagName = dbData[i + 1];
            int flagType = Integer.parseInt(dbData[i + 2]);
            String flagDescription = dbData[i + 3];
            UserFlag flag = new UserFlag();
            flag.setName(flagName);
            flag.setType(flagType);
            flag.setDescription(flagDescription);
            theFlags.put(flagName, flag);
        }
        return theFlags;
    }

    public PollHandlingSystem getPollHandlingSystem() {
        return new PollHandlingSystemImpl(this);
    }

    public ShoppingOrderSystem getShoppingOrderSystem() {
        return new ShoppingOrderSystemImpl(this);
    }

    public Properties getLanguageProperties(UserDomainObject user) {
        String languageIso639_2 = user.getLanguageIso639_2();
        Properties languageProperties = (Properties)this.languagePropertiesMap.get(languageIso639_2);
        if (null == languageProperties) {
            String propertiesFilename = languageIso639_2 + ".properties";
            try {
                languageProperties = Prefs.getProperties(propertiesFilename);
                this.languagePropertiesMap.put(languageIso639_2, languageProperties);
            }
            catch (IOException e) {
                log.fatal((Object)("Failed to read language properties from " + propertiesFilename), (Throwable)e);
                throw new UnhandledException((Throwable)e);
            }
        }
        return languageProperties;
    }

    public File getIncludePath() {
        return this.config.getIncludePath();
    }

    public Collator getDefaultLanguageCollator() {
        try {
            return Collator.getInstance(new Locale(LanguageMapper.convert639_2to639_1(this.config.getDefaultLanguage())));
        }
        catch (LanguageMapper.LanguageNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mainLog.info((Object)"Main log started.");
        DEMOTEMPLATEFILTER = new FileFilter(){

            public boolean accept(File file) {
                return file.length() > 0L;
            }
        };
    }

    private static class WebappRelativeFileConverter
    implements Converter {
        private WebappRelativeFileConverter() {
        }

        public Object convert(Class type, Object value) {
            return FileUtility.getFileFromWebappRelativePath((String)value);
        }
    }
}

