/*
 * Decompiled with CFR 0.152.
 */
package imcode.external.chat;

import imcode.external.chat.ChatMember;
import imcode.external.chat.ChatMessage;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import java.util.Vector;

public class ChatSystemMessage
extends ChatMessage {
    public static final int ENTER_MSG = 1;
    public static final int LEAVE_MSG = 2;
    public static final int KICKOUT_MSG = 3;
    public static final int USER_TIMEDOUT_MSG = 4;
    private ChatMember member;
    private int message;

    public ChatSystemMessage(ChatMember member, int message) {
        this.member = member;
        this.message = message;
    }

    private ChatMember getMember() {
        return this.member;
    }

    public String getLine(boolean showPrivateMessages, ChatMember lineViewer, ImcmsServices imcref, UserDomainObject user, String libName) {
        if (!(lineViewer.isShowEnterAndLeaveMessagesEnabled() || this.message != 1 && this.message != 2)) {
            return "";
        }
        String message = this.getMessageString(imcref, user, libName);
        Vector<String> vLine = new Vector<String>();
        vLine.add("#size#");
        vLine.add("" + lineViewer.getFontSize());
        vLine.add("#member#");
        vLine.add(this.getMember().getName());
        vLine.add("#message#");
        vLine.add(message);
        vLine.add("#date#");
        if (lineViewer.isShowDateTimesEnabled()) {
            vLine.add(this.formattedDateTime());
        } else {
            vLine.add("");
        }
        return imcref.getTemplateFromSubDirectoryOfDirectory("system_msg.html", user, vLine, "103", libName).trim() + "<br>\n";
    }

    private String getMessageString(ImcmsServices imcref, UserDomainObject user, String libName) {
        String templateName = null;
        switch (this.message) {
            case 1: {
                templateName = "enter_msg.html";
                break;
            }
            case 2: {
                templateName = "leave_msg.html";
                break;
            }
            case 3: {
                templateName = "kickout_msg.html";
                break;
            }
            case 4: {
                templateName = "user_timedout_msg.html";
            }
        }
        return imcref.getTemplateFromSubDirectoryOfDirectory(templateName, user, null, "103", libName).trim();
    }

    public String getLogMsg(ImcmsServices imcref, UserDomainObject user, String libName) {
        return "\t<" + this.member.getName() + ">\t(" + this.member.getIpNr() + ")\t[--- " + this.getMessageString(imcref, user, libName) + "]";
    }

    public String toString() {
        String event;
        switch (this.message) {
            case 1: {
                event = "entered";
                break;
            }
            case 2: {
                event = "left";
                break;
            }
            case 3: {
                event = "was kicked out";
                break;
            }
            case 4: {
                event = "timed out";
                break;
            }
            default: {
                event = "bad system message";
            }
        }
        return this.member.getName() + " " + event;
    }
}

