/*
 * Decompiled with CFR 0.152.
 */
package imcode.external.chat;

import imcode.external.chat.ChatMember;
import imcode.external.chat.ChatMessage;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import java.util.Vector;

public class ChatNormalMessage
extends ChatMessage {
    private String _senderStr;
    private int _msgType;
    private String _msgTypeStr;
    private String _chatMsg;
    private String _recieverStr;
    private int recipient;
    private int _sender;

    public ChatNormalMessage(String chatMsg, ChatMember senderMember, int reciever, String recieverStr, int msgType, String msgTypeStr) {
        this._chatMsg = chatMsg;
        this.recipient = reciever;
        this._recieverStr = recieverStr;
        this._msgType = msgType;
        this._msgTypeStr = msgTypeStr;
        this._senderStr = senderMember.getName();
        this._sender = senderMember.getMemberId();
    }

    public String toString() {
        return this.getLogMsg();
    }

    public String getLogMsg() {
        String recipientMessage = this.recipient == 0 ? "" : "[" + this._msgTypeStr + " " + this._recieverStr + "]";
        return "\t<" + this._senderStr + "> \t\t" + recipientMessage + "\t" + this._chatMsg.replaceAll("\n<BR>", "\n\t\t\t\t");
    }

    private String getMessage() {
        return this._chatMsg;
    }

    private int getMsgType() {
        return this._msgType;
    }

    private int getRecipient() {
        return this.recipient;
    }

    private String getRecipientStr() {
        return this._recieverStr;
    }

    private String getMsgTypeStr() {
        return this._msgTypeStr;
    }

    private String getSenderStr() {
        return this._senderStr;
    }

    private int getSender() {
        return this._sender;
    }

    public String getLine(boolean showPrivateMessages, ChatMember myMember, ImcmsServices imcref, UserDomainObject user, String libName) {
        Vector<String> vLine = new Vector<String>();
        vLine.add("#size#");
        vLine.add("" + myMember.getFontSize());
        vLine.add("#sender#");
        vLine.add(this.getSenderStr());
        vLine.add("#msgType#");
        vLine.add(this.getMsgTypeStr());
        vLine.add("#recipient#");
        vLine.add(this.getRecipientStr());
        vLine.add("#message#");
        vLine.add(this.getMessage());
        vLine.add("#date#");
        if (myMember.isShowDateTimesEnabled()) {
            vLine.add(this.formattedDateTime());
        } else {
            vLine.add("");
        }
        if (this.getMsgType() == 101 && showPrivateMessages) {
            if (this.getRecipient() == myMember.getMemberId()) {
                return ChatNormalMessage.parseChatTemplate(imcref, vLine, "private_to_msg.html", user, libName) + "<br>\n";
            }
            if (this.getSender() == myMember.getMemberId()) {
                return ChatNormalMessage.parseChatTemplate(imcref, vLine, "private_from_msg.html", user, libName) + "<br>\n";
            }
        }
        if (0 == this.recipient) {
            return ChatNormalMessage.parseChatTemplate(imcref, vLine, "standard_msg.html", user, libName) + "<br>\n";
        }
        return ChatNormalMessage.parseChatTemplate(imcref, vLine, "directed_msg.html", user, libName) + "<br>\n";
    }

    private static String parseChatTemplate(ImcmsServices imcref, Vector vLine, String templateName, UserDomainObject user, String libName) {
        return imcref.getTemplateFromSubDirectoryOfDirectory(templateName, user, vLine, "103", libName).trim();
    }
}

