/*
 * Decompiled with CFR 0.152.
 */
package imcode.external.chat;

import imcode.external.chat.ChatBase;
import imcode.external.chat.ChatMember;
import imcode.external.chat.ChatMessage;
import imcode.external.chat.ChatSystemMessage;
import imcode.external.chat.Counter;
import imcode.server.ImcmsServices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;

public class ChatGroup {
    private List _groupMembers = Collections.synchronizedList(new LinkedList());
    private Counter _msgNrCounter = new Counter();
    private static final int AUTO_LOGOUT_TIME = 30;
    private List _msgBuffer = Collections.synchronizedList(new LinkedList());
    private int _maxBufferSize = 200;

    ChatGroup() {
    }

    public Iterator getAllGroupMembers() {
        return this._groupMembers.iterator();
    }

    public List getGroupMembers() {
        return this._groupMembers;
    }

    public synchronized void addNewGroupMember(ChatMember member) {
        this._groupMembers.add(member);
        member.setCurrentGroup(this);
    }

    public synchronized void removeGroupMember(ChatMember member) {
        this._groupMembers.remove(member);
    }

    public synchronized void addNewMsg(ChatBase chatBase, ChatMessage msg, ImcmsServices imcref) throws IOException, ServletException {
        this._msgNrCounter.increment();
        msg.setIdNumber(this._msgNrCounter.getValue());
        Iterator iter = this._groupMembers.iterator();
        this.addNewMsgToGroup(msg);
        ArrayList<ChatMember> membersWhichHaveTimedOut = new ArrayList<ChatMember>();
        while (iter.hasNext()) {
            ChatMember tempMember = (ChatMember)iter.next();
            Calendar autoLogOutTime = Calendar.getInstance();
            autoLogOutTime.setTime(tempMember.getLastRequest());
            autoLogOutTime.add(12, 30);
            if (new Date().after(autoLogOutTime.getTime())) {
                membersWhichHaveTimedOut.add(tempMember);
                continue;
            }
            tempMember.addNewMsg(msg);
        }
        Iterator it = membersWhichHaveTimedOut.iterator();
        while (it.hasNext()) {
            ChatMember theMember = (ChatMember)it.next();
            ChatSystemMessage systemMessage = new ChatSystemMessage(theMember, 4);
            if (theMember.isTimedOut()) continue;
            theMember.setTimedOut(true);
            chatBase.createLeaveMessageAndAddToGroup(theMember, systemMessage, imcref);
        }
    }

    public List get_msgBuffer() {
        return this._msgBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewMsgToGroup(ChatMessage msg) {
        List list = this._msgBuffer;
        synchronized (list) {
            this.pruneBuffer();
            this._msgBuffer.add(0, msg);
        }
    }

    private void pruneBuffer() {
        if (this._msgBuffer.size() > this._maxBufferSize) {
            this._msgBuffer.remove(this._msgBuffer.size() - 1);
        }
    }
}

