/*
 * Decompiled with CFR 0.152.
 */
package imcode.external.chat;

import imcode.external.chat.ChatBase;
import imcode.external.diverse.SettingsAccessor;
import imcode.external.diverse.VariableManager;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChatError
extends ChatBase {
    private static final String ERROR_FILE = "chat_error.htm";
    private String errorMessage;

    public ChatError(HttpServletRequest req, HttpServletResponse res, String header, int errorCode) throws IOException {
        VariableManager vm = new VariableManager();
        String myErrorMessage = this.getErrorMessage(req, errorCode);
        vm.addProperty("ERROR_HEADER", header);
        vm.addProperty("ERROR_MESSAGE", myErrorMessage);
        this.sendErrorHtml(req, res, vm, ERROR_FILE);
    }

    public String getErrorMsg() {
        return this.errorMessage;
    }

    private String getErrorMessage(HttpServletRequest req, int errCode) {
        try {
            SettingsAccessor setObj = new SettingsAccessor("errmsg.ini", Utility.getLoggedOnUser(req), "103");
            setObj.setDelimiter("=");
            setObj.loadSettings();
            this.errorMessage = setObj.getSetting("" + errCode);
            if (this.errorMessage == null) {
                this.errorMessage = "Missing Errorcode " + errCode;
            }
        }
        catch (Exception e) {
            this.log("An error occured while reading the errmsg.ini file");
        }
        return this.errorMessage;
    }

    public ChatError(HttpServletRequest req, HttpServletResponse res, String header, int errorCode, String fileName) throws IOException {
        VariableManager vm = new VariableManager();
        this.errorMessage = this.getErrorMessage(req, errorCode);
        vm.addProperty("ERROR_CODE", "" + errorCode);
        vm.addProperty("ERROR_HEADER", header);
        vm.addProperty("ERROR_MESSAGE", this.errorMessage);
        this.sendErrorHtml(req, res, vm, fileName);
    }

    private void sendErrorHtml(HttpServletRequest req, HttpServletResponse res, VariableManager vm, String htmlFile) throws IOException {
        UserDomainObject user = this.getUserObj(req);
        String imagePath = this.getExternalImageFolder(req);
        vm.addProperty("IMAGE_URL", imagePath);
        vm.addProperty("SERVLET_URL", "");
        List tagsAndData = vm.getTagsAndData();
        String html = this.getTemplate(htmlFile, user, tagsAndData);
        Utility.setDefaultHtmlContentType(res);
        res.getWriter().println(html);
    }
}

